<?php
/*
@File customer_group.php(MODEL)
SALE:	 CUSTOMER_GROUP PAGE
    Manages the customer_group by inserting, deleting and updating the customer_group information. 
    It also retrieves the customer_group details if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSaleCustomerGroup extends Model {
/*
FUNCTION NAME 		-	addCustomerGroup
DESCRIPTION 		-	Adds new customer_group to the database.
INPUT PARAMETER 	-	data array containing the details of the customer_group.
OUTPUT PARAMETER 	- 	Inserts the customer_group details to the database and returns.
*/	
	public function addCustomerGroup($data) {
		$query = $this->db->query("SELECT  * FROM " .  DB_PREFIX . "customer_group");
		$getNumOfGroups = $query->num_rows;

		$this->db->query("INSERT INTO " . DB_PREFIX . "customer_group SET approval = '" . (int)$data['approval'] . "', company_id_display = '" . (int)$data['company_id_display'] . "', company_id_required = '" . (int)$data['company_id_required'] . "', tax_id_display = '" . (int)$data['tax_id_display'] . "', tax_id_required = '" . (int)$data['tax_id_required'] . "', sort_order = '" . (int)$data['sort_order'] . "'");
	
		$customer_group_id = $this->db->getLastId();
		
		foreach ($data['customer_group_description'] as $language_id => $value) {
			$sql  = "INSERT INTO " . DB_PREFIX . "customer_group_description SET customer_group_id = '" . (int)$customer_group_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "' ";
			if(!$getNumOfGroups){
				$sql .= ", is_default=1";
			}
			$this->db->query($sql);
		}
		return $customer_group_id;	
	}
/*
FUNCTION NAME 		-	editCustomerGroup
DESCRIPTION 		-	Updates the customer group for the given customer_group_id
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Retuns after updaing the customer_group
*/	
	public function editCustomerGroup($customer_group_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "customer_group SET approval = '" . (int)$data['approval'] . "', company_id_display = '" . (int)$data['company_id_display'] . "', company_id_required = '" . (int)$data['company_id_required'] . "', tax_id_display = '" . (int)$data['tax_id_display'] . "', tax_id_required = '" . (int)$data['tax_id_required'] . "', sort_order = '" . (int)$data['sort_order'] . "' WHERE customer_group_id = '" . (int)$customer_group_id . "'");
	
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_group_description WHERE customer_group_id = '" . (int)$customer_group_id . "'");

		foreach ($data['customer_group_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "customer_group_description SET customer_group_id = '" . (int)$customer_group_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}
	}
//-----------
/*
FUNCTION NAME 		-	defaultCustomerGroup
DESCRIPTION 		-	Updates the customer group for the given customer_group_id
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Retuns after updaing the customer_group
*/	
	public function defaultCustomerGroup($customer_group_id) {
		$this->db->query("UPDATE " . DB_PREFIX . "customer_group_description SET is_default =0");
		 if ((int)$customer_group_id) {
		 	$this->db->query("UPDATE " . DB_PREFIX . "customer_group_description SET is_default =1 WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		//  	$query1 = $this->db->query("SELECT  CONCAT(name, "."\" (default)\"".") AS name FROM " .  DB_PREFIX . "customer_group_description  WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		// return $query1->row;
		  } 
	}
	
	public function getCustomerGroupStatus($customer_group_id) {
			$query1 = $this->db->query("SELECT  is_default FROM " .  DB_PREFIX . "customer_group_description  WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		return $query1->row;
	}
//-----------	
/*
FUNCTION NAME 		-	deleteCustomerGroup
DESCRIPTION 		-	Deletes the customer_group for the given customer_group_id
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Returns after deleting the customer_group
*/		
	public function deleteCustomerGroup($customer_group_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_group WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_group_description WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_discount WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_special WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_reward WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "sms_kms_group WHERE sms_group_id = '" . (int)$customer_group_id . "'");
	}
/*
FUNCTION NAME 		-	getCustomerGroup
DESCRIPTION 		-	Retrieves a customer_group for the given customer_group_id
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Returns the row retrieved
*/	
	public function getCustomerGroup($customer_group_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer_group cg LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (cg.customer_group_id = cgd.customer_group_id) WHERE cg.customer_group_id = '" . (int)$customer_group_id . "' AND cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
	public function getCustomerGroupId($customer_group_name) {
		$query = $this->db->query("SELECT  * FROM " .  DB_PREFIX . "customer_group_description  WHERE name = '" . $customer_group_name . "'");
		
		return $query->row;
	}
	// public function getCustomerGroupId($customer_group_name) {
	// 	$query = $this->db->query("SELECT  * FROM " .  DB_PREFIX . "customer_group_description  WHERE name = '" . $customer_group_name . "'");
		
	// 	return $query->row;
	// }

	// public function addApiResponceId($kms_group_id,$sms_group_id)
	// {
	//  	$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_group SET sms_group_id ='".(int)$sms_group_id ."',kms_group_id = '".(int)$kms_group_id."'");

	// }
/*
FUNCTION NAME 		-	getCustomerGroups
DESCRIPTION 		-	Retrieves all the customer_groups
INPUT PARAMETER 	-	data array conatining filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/			
	public function getCustomerGroups($data = array()) {
		// var_dump($data);
		// exit(0);
		$sql = "SELECT * FROM " . DB_PREFIX . "customer_group cg LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (cg.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
		$sort_data = array(
			'cgd.name',
			'cg.sort_order'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY cgd.name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getCustomerGroupDescription
DESCRIPTION 		-	Retrieves all the customer_group_description for the given 
						customer_group_id
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Returns an array containing customer group description
*/		
	public function getCustomerGroupDescriptions($customer_group_id) {
		$customer_group_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_group_description WHERE customer_group_id = '" . (int)$customer_group_id . "'");
				
		foreach ($query->rows as $result) {
			$customer_group_data[$result['language_id']] = array(
				'name'        => $result['name'],
				'description' => $result['description']
			);
		}
		
		return $customer_group_data;
	}
/*
FUNCTION NAME 		-	getTotalCustomerGroups
DESCRIPTION 		-	Retrieves the total count for all the customer groups
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalCustomerGroups() {
		$query = $this->db->query("SELECT COUNT(DISTINCT (customer_group_id)) AS total FROM " . DB_PREFIX . "customer_group_description");
// 		SELECT COUNT( DISTINCT (
// customer_group_id
// ) )
// FROM `oc_customer_group_description` 
		return $query->row['total'];
	}
	public function addApiResponceId($kms_group_id,$sms_group_id)
	{
	 	$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_group SET sms_group_id = '" . (int)$sms_group_id . "', kms_group_id = '" . (int)$kms_group_id . "'");

	}
	 
	 	public function getApiResponceId($sms_group_id)
	{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT kms_group_id FROM `" . DB_PREFIX . "sms_kms_group` WHERE sms_group_id = '" . (int)$sms_group_id. "'");
	
		return $query->row;
	}

	public function CheckGroupNameByid(){
		$query = $this->db->query("SELECT DISTINCT(customer_group_id) FROM " . DB_PREFIX . "customer_group_description ");


		return $query->num_rows;
	}

	public function isGroupExist($group_name,$customer_group_id)
	{
	 	$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "customer_group_description` WHERE  name = '" .$group_name."' AND customer_group_id <> '".$customer_group_id."'");
	
		return ($query->num_rows>0);
	}
		
}
?>