<?php
/*
@File customer_ban_ip.php(MODEL)
SALE:	 CUSTOMER_BAN_IP PAGE
    Manages the customer_ban_ip by inserting, deleting and updating the customer_ban_ip informations. 
    It also retrieves the customer_ban_ip details if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelSaleCustomerBanIp extends Model {
/*
FUNCTION NAME 		-	addCustomerBanIp
DESCRIPTION 		-	Adds new customer_ban_ip to the database.
INPUT PARAMETER 	-	data array containing the details of the customer_ban_ip.
OUTPUT PARAMETER 	- 	Inserts the customer_ban_ip details to the database and returns.
*/	
	public function addCustomerBanIp($data) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "customer_ban_ip` SET `ip` = '" . $this->db->escape($data['ip']) . "'");
	}
/*
FUNCTION NAME 		-	editCustomerBanIp
DESCRIPTION 		-	Updates the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Retuns after updaing the ban ip
*/	
	public function editCustomerBanIp($customer_ban_ip_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "customer_ban_ip` SET `ip` = '" . $this->db->escape($data['ip']) . "' WHERE customer_ban_ip_id = '" . (int)$customer_ban_ip_id . "'");
	}
/*
FUNCTION NAME 		-	deleteCustomerBanIp
DESCRIPTION 		-	Deletes the customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Returns after deleting the ban ip
*/		
	public function deleteCustomerBanIp($customer_ban_ip_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "customer_ban_ip` WHERE customer_ban_ip_id = '" . (int)$customer_ban_ip_id . "'");
	}
/*
FUNCTION NAME 		-	getCustomerBanIp
DESCRIPTION 		-	Retrieves a customer ban ip for the given customer ban ip id
INPUT PARAMETER 	-	customer_ban_ip_id
OUTPUT PARAMETER 	- 	Returns the row retrieved
*/	
	public function getCustomerBanIp($customer_ban_ip_id) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "customer_ban_ip` WHERE customer_ban_ip_id = '" . (int)$customer_ban_ip_id . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCustomerBanIps
DESCRIPTION 		-	Retrieves all the customers ban ip
INPUT PARAMETER 	-	data array conatining filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/		
	public function getCustomerBanIps($data = array()) {
		$sql = "SELECT *, (SELECT COUNT(DISTINCT customer_id) FROM `" . DB_PREFIX . "customer_ip` ci WHERE ci.ip = cbi.ip) AS total FROM `" . DB_PREFIX . "customer_ban_ip` cbi";
				
		$sql .= " ORDER BY `ip`";	
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			
			
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
			
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalCustomerBanIps
DESCRIPTION 		-	Retrieves the total count for all the customer ban ips.
INPUT PARAMETER 	-	data array.
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalCustomerBanIps($data = array()) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_ban_ip`");
				 
		return $query->row['total'];
	}
}
?>