<?php
/*
@File alacartewiseactiveconnection.php(MODEL)
LOCALISATION:	 AlaCartewiseActiveconnection PAGE
    This class queries all the packages with the channels added to each of them.

@Author Ravi Ranjan
@date 20th Nov. 2015
*/
class ModelReportTest extends Model {

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails($package_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."subscription where product_id='".$package_id."'");
		return $query->rows;	
	 }

	/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCustomerDetails($customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."customer where customer_id='".$customer_id."'");
			return $query->rows;
	}
	public function getCustomerArea($customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."address where customer_id='".$customer_id."'");
			return $query->rows;
	}


/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the detail row.
*/	
	public function getChannelDetail($product_id) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price FROM oc_product p, oc_product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->row;	
	}
/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM oc_product p, oc_product_description pd, oc_product_to_category cat, oc_category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}
	/*
FUNCTION NAME 		-	getDailyActiveStbCount
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getDailyActiveSCCount($data) {
	$sql = "SELECT COUNT( * ) as sc_count FROM  `oc_stb` WHERE  `customer_id` !=0 AND  `is_black_list` !=1 AND is_smart_card=1";
		//var_dump($data['filter_date'] );
		if(isset($data['filter_date']))
		{
			$sql.= " AND  `active_date` <= '".$data['filter_date']."'";
		}else{
			$sql.= " AND  `active_date` <= NOW()";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->row;	
	}
	
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries the selected Package List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getPackages() {
		$query = $this->db->query("SELECT p.product_id,pd.name FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND p.is_package=0 AND p.is_ppv=0");
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getAlacarte
DESCRIPTION 		-	Queries the selected Ala carte details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getAlacarte($product_id) {
	$query = $this->db->query("SELECT COUNT(DISTINCT (c.user_id)) AS total, pd.name FROM " . DB_PREFIX . "cas_op_transactions c, " . DB_PREFIX . "product p, " . DB_PREFIX . "product_description pd
		WHERE p.product_id = c.product_id AND p.product_id = pd.product_id AND  c.product_id='".$product_id."' AND p.is_package =0");
	return $query->rows;
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>