<?php
/*
@File customer.php(MODEL)
REPORT:	 CUSTOMER PAGE
    This class queries the Total authorized subscribers as a  list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportSubsListReport extends Model {
/*
FUNCTION NAME 		-	getCustomer
DESCRIPTION 		-	Queries the customer details based on the customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the asked customer details.
*/    
    public function getCustomer($customer_id) {
		$query = $this->db->query("SELECT c.*, CONCAT(c.firstname, ' ', c.lastname) AS name,a.address_1 as address FROM " . DB_PREFIX . "customer c ," . DB_PREFIX . "address a WHERE c.status>0 and c.customer_id='".$customer_id."' AND c.address_id=a.address_id");
		// var_dump("SELECT c.*, CONCAT(c.firstname, ' ', c.lastname) AS name,a.address_1 as address FROM " . DB_PREFIX . "customer c ," . DB_PREFIX . "address a WHERE c.status>0 and c.customer_id='".$customer_id."' AND c.address_id=a.address_id");
		return $query->rows;	
	}
/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Queries all the approved customer detials from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/
	public function getCustomers($data) {
		$sql ="SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) GROUP BY c.customer_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalAuthSubs() {
			$query = $this->db->query("SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) GROUP BY c.customer_id"); 
			return $query->num_rows;
		}

  public function getStbHw($stb_no) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb   WHERE  stb_no='".$stb_no."'");

		return $query->rows;	
	}
}
?>