<?php
/*
@File settopbox.php(MODEL)
LOCALISATION:	 SETTOPBOX PAGE
    This class queries the location of all the set top boxes ie (customer address) list for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportSetTopBox extends Model {
	/*
FUNCTION NAME 		-	getCustomerAddress
DESCRIPTION 		-	Queries the address for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the row queried containing the address
*/	
	public function getCustomerAddress($customer_id) {
		$query = $this->db->query("SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(c.STBNO),CONCAT(a.address_1,' ',a.city) AS address,c.date_added,c.status FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) WHERE c.customer_id = ".$customer_id."");
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getAddress
DESCRIPTION 		-	Queries all the customers address.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the row queried containing address of each customers
*/	

	public function getAddress($data) {
		$sql="SELECT (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(c.STBNO),CONCAT(a.address_1,' ',a.city) AS address,c.date_added,c.status FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) where c.STBNO!= '' group by c.customer_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
		/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalStbAddress() {
		$query = $this->db->query("SELECT (c.customer_id) FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) where c.STBNO!= '' group by c.customer_id");
		return $query->num_rows;
	}
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>