<?php
/*
@File alacartewiseactiveconnection.php(MODEL)
LOCALISATION:	 AlaCartewiseActiveconnection PAGE
    This class queries all the packages with the channels added to each of them.

@Author Ravi Ranjan
@date 20th Nov. 2015
*/
class ModelReportProductWiseSubscriberList extends Model {

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails($data) {
		$sql="SELECT * FROM ".DB_PREFIX."subscription";
		if(isset($data['filter_package'])){
			$sql.=" WHERE product_id='".$data['filter_package']."'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		$query = $this->db->query($sql);
		return $query->rows;	
	 }
/*
FUNCTION NAME 		-	getChannelListCount
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListCount($data) {
		$sql="SELECT count(*) AS total FROM ".DB_PREFIX."subscription";
		if(isset($data['filter_package'])){
			$sql.=" WHERE product_id='".$data['filter_package']."'";
		}
		$query = $this->db->query($sql);
		return $query->row['total'];	
	 }	 

	/*
FUNCTION NAME 		-	getCustomerDetails
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCustomerDetails($customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."customer where customer_id='".$customer_id."'");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getCustomerArea
DESCRIPTION 		-	
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	
*/	
	public function getCustomerArea($customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."address where customer_id='".$customer_id."'");
			return $query->rows;
	}
/*
FUNCTION NAME 		-	getProducts
DESCRIPTION 		-	Queries the selected Package List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getProducts() {
		$query = $this->db->query("SELECT p.product_id,pd.name FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND p.is_package=0 AND p.is_ppv=0");
		return $query->rows;
	}
	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>