<?php
/*
@File product.php(MODEL)
LOCALISATION:	 PRODUCT PAGE
    	This class manages the products viewed statistics as a list 
    	to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportProduct extends Model {
/*
FUNCTION NAME 		-	getProductsviewed
DESCRIPTION 		-	Queries the product viewed field for all the products(channels & packages).
INPUT PARAMETER 	-	data array containing any filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getProductsViewed($data = array()) {
		$sql = "SELECT pd.name,p.product_id, p.model, p.viewed FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.viewed > 0 ORDER BY p.viewed DESC";
					
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalProductsViewed
DESCRIPTION 		-	Queries to get the total number of products whose total number of viewed count >0
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the products viewed.
*/	
	public function getTotalProductsViewed() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE viewed > 0");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalProdcutviews
DESCRIPTION 		-	Queries to get the total number of views by adding all the view count
						for all the products.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count retrieved.
*/	
	public function getTotalProductViews() {
      	$query = $this->db->query("SELECT SUM(viewed) AS total FROM " . DB_PREFIX . "product");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	reset
DESCRIPTION 		-	Updates the product table and set all the view count for each product as zero.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Updates the table and returns to the list page.
*/			
	public function reset() {
		$this->db->query("UPDATE " . DB_PREFIX . "product SET viewed = '0'");
	}
/*
FUNCTION NAME 		-	getPurchased
DESCRIPTION 		-	Queries the product purchased statictic for each product as a list
						to generate report
INPUT PARAMETER 	-	data array containing any filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getPurchased($data = array(),$user_id) {
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $user_id . "'");
		$flag=false;
		if($query->row['user_group_id']==1){
			$sql = "SELECT op.product_id,op.name, op.model, SUM(op.quantity) AS quantity, SUM(op.total + op.total * op.tax / 100) AS total FROM " . DB_PREFIX . "order_product op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id) ";
		}else{
			$flag=true;
			$sql = "SELECT op.product_id,op.name, op.model, SUM(op.quantity) AS quantity, SUM(op.total + op.total * op.tax / 100) AS total FROM `" . DB_PREFIX . "customer` c , `" . DB_PREFIX . "order_product` op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id) WHERE o.customer_id=c.customer_id AND c.operator_id='".$user_id."'";
		}
		
		if (!empty($data['filter_order_status_id'])) {
			if($flag)
				$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
			else
				$sql .= " WHERE o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			if($flag)
				$sql .= " AND o.order_status_id > '0'";
			else
				$sql .= " WHERE o.order_status_id > '0'";
		}
		
		if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		// if (!empty($data['filter_date_end'])) {
		// 	$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		// }
		
		$sql .= " GROUP BY op.model ORDER BY op.product_id ASC";
					
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalPurchased
DESCRIPTION 		-	Queries to get the total number of purchased product in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the order_product table.
*/	
	public function getTotalPurchased($data,$user_id) {
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $user_id . "'");
		$flag=false;
		if($query->row['user_group_id']==1){
      		$sql = "SELECT COUNT(DISTINCT op.model) AS total FROM `" . DB_PREFIX . "order_product` op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id) ";
      	}else{
      		$flag=true;
      		$sql = "SELECT COUNT(DISTINCT op.model) AS total FROM `" . DB_PREFIX . "customer` c ,`" . DB_PREFIX . "order_product` op LEFT JOIN `" . DB_PREFIX . "order` o ON (op.order_id = o.order_id) WHERE o.customer_id=c.customer_id AND c.operator_id='".$user_id."'";
      	}

		if (!empty($data['filter_order_status_id'])) {
			if($flag)
				$sql .= " AND o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
			else
				$sql .= " WHERE o.order_status_id = '" . (int)$data['filter_order_status_id'] . "'";
		} else {
			if($flag)
				$sql .= " AND o.order_status_id > '0'";
			else
				$sql .= " WHERE o.order_status_id > '0'";
		}
		
		if (!empty($data['filter_date_start'])) {
			$sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}
		
		$query = $this->db->query($sql);
				
		return $query->row['total'];
	}
}
?>
