<?php
/*
@File pckwisesubscribers.php(MODEL)
LOCALISATION:	 PCKWISESUBSCRIBERS PAGE
    This class queries the total number of subscribers for each of the packages as a list
    to generate report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportPrdWiseSubscribers extends Model {
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries the subscribers count for each of the package.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getProducts($data) {
	$sql = "SELECT d.product_id, COUNT(DISTINCT(c.customer_id)) as count,(d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id)  where pd.is_package=0 AND pd.is_ppv=0  GROUP BY c.product_id";
	if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalpkgSubs
DESCRIPTION 		-	Queries the subscribers count for each of the package.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalProdSubs()
 	{
		$query = $this->db->query("SELECT  COUNT(*) as total ,(d.product_id), (d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id) where pd.is_package=0 AND is_ppv=0 GROUP BY c.product_id");
		return $query->num_rows;
	}
/*
FUNCTION NAME 		-	getOptionId
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getOptionId($package_id)
	 {
		$query = $this->db->query("SELECT c.option_value_id,c.price,p.product_id FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_option_value c ON (p.product_id = c.product_id) LEFT JOIN " . DB_PREFIX . "option_value_description d ON (c.option_id = d.option_id) where p.is_package=0 AND p.is_ppv=0 AND p.product_id=".$package_id."");//where c.product_id ='".(int)$product_id."'");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.product_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}
/*
FUNCTION NAME 		-	getProduct
DESCRIPTION 		-	Queries the subscribers count for the given pro_id
INPUT PARAMETER 	-	pro_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getProduct($product_id) {
		$sql = "SELECT d.product_id, COUNT(DISTINCT(c.customer_id)) as count,(d.name) FROM " . DB_PREFIX . "subscription c LEFT JOIN " . DB_PREFIX . "product_description d ON (c.product_id = d.product_id) LEFT JOIN ". DB_PREFIX ."product pd ON (d.product_id = pd.product_id)  where pd.is_package=0 AND pd.is_ppv=0 and d.product_id =".(int)$product_id."  GROUP BY c.product_id";
		$query = $this->db->query($sql);
		return $query->rows;
	}

}
?>
