<?php
/*
@File pckwisesubscribers.php(MODEL)
LOCALISATION:	 PCKWISESUBSCRIBERS PAGE
    This class queries the total number of subscribers for each of the packages as a list
    to generate report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportPrdGeneral extends Model {

/*
FUNCTION NAME 		-	getSubscriptions
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getSubscriptions($data=array()) {
		$sql="SELECT * FROM oc_product_description pd,oc_product p,oc_subscription s right join oc_customer c on(s.customer_id = c.customer_id) right join oc_address a on(s.customer_id = a.customer_id) WHERE s.product_id = pd.product_id AND pd.product_id = p.product_id AND p.is_package=0 AND p.is_ppv=0 ";
		$implode = array();
		if(isset($data['filter_product'])){
			$implode[] = " s.product_id = '".$data['filter_product']."'";
		}
		if(isset($data['product_id']) && isset($data['customer_id'])){
			$implode[] = " s.product_id = '".$data['product_id']."' AND  s.customer_id = '".$data['customer_id']."'";
		}
		if ($implode) {
			$sql .= " AND " . implode(" AND ", $implode);
		}
		$sql.=" GROUP BY s.product_id, s.customer_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
		
		return $query->rows;	
	 }
/*
FUNCTION NAME 		-	getSubscriptions
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalSubscriptions($data=array()) {
		$sql="SELECT s.customer_id FROM oc_product_description pd,oc_product p,oc_subscription s right join oc_customer c on(s.customer_id = c.customer_id) right join oc_address a on(s.customer_id = a.customer_id) WHERE s.product_id = pd.product_id AND pd.product_id = p.product_id AND p.is_package=0 AND p.is_ppv=0 ";

		if(isset($data['filter_product'])){
			$sql.= " AND s.product_id = '".$data['filter_product']."'";
		}
		$sql.=" GROUP BY s.product_id, s.customer_id";
		$query = $this->db->query($sql);
		return $query->num_rows;	
	 }

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCustomerSubscription($product_id,$customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."subscription where product_id='".$product_id."' OR customer_id='".$customer_id."'");
		return $query->rows;	
	 }
	 /*
FUNCTION NAME 		-	getCustomerSubsCount
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCustomerSubsCount($product_id,$customer_id) {
		$sql="SELECT count(*) AS total FROM ".DB_PREFIX."subscription";
		if (isset($product_id) && isset($customer_id)) {
			$sql.=" WHERE product_id='".$product_id."' OR customer_id='".$customer_id."'";
		}
		$query = $this->db->query($sql);
		return $query->row['total'];	
	 }

/*
FUNCTION NAME 		-	getCustSubsPdf
DESCRIPTION 		-	
INPUT PARAMETER 	-	
OUTPUT PARAMETER 	- 	
*/	
	public function getCustSubsPdf($product_id,$customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."subscription where product_id='".$product_id."' AND customer_id='".$customer_id."'");
		return $query->row;	
	 }


	/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCustomerDetails($customer_id) {
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."customer c left join ".DB_PREFIX."address a on(c.customer_id = a.customer_id) where c.customer_id='".$customer_id."'");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries the selected Package List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getProduct($data=array()) {
		$sql ="SELECT * FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND p.is_package=0 AND p.is_ppv=0";
		if(isset($data['filter_product']))
		{
			$sql .=" AND  p.product_id = '".$data['filter_product']."'";
		}
		$query = $this->db->query($sql);
		return $query->rows;	
	}
/*
FUNCTION NAME 		-	getProductName
DESCRIPTION 		-	
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
public function getProductName($product_id) {
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."product_description  where product_id='".$product_id."'");
		return $query->row;	
	}

/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>