<?php
/*
@File package_activation_deactivation_history.php(MODEL)
LOCALISATION:	 PackageActivationDeactivationHistory PAGE
    This class queries Package Subscription details from the database for the store
    to generate a report.

@Author Mahesh Yallure 
@date 25th Nov. 2015
*/
class ModelReportPackageActivationDeactivationHistory extends Model {
	
/*
FUNCTION NAME 		-	getPkgSubscriptionDetails
DESCRIPTION 		-	Queries all Package Subscription with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getPkgSubscriptionDetails($data) {	
		$sql = "SELECT cas.tx_id, CONCAT( c.firstname,  ' ', c.lastname ) AS name, pd.name, cas.product_id,p.model, cas.user_id,sc.stb_no, cas.modify_date, cas.exp_date,cas.id
			FROM ".DB_PREFIX."cas_op_transactions cas, ".DB_PREFIX."customer c, ".DB_PREFIX."product_description pd, ".DB_PREFIX."stb sc,".DB_PREFIX."product p WHERE cas.cmd_id =6 AND cas.user_id = c.customer_id
			AND cas.user_id = sc.customer_id AND cas.product_id = pd.product_id AND cas.product_id =p.product_id";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		$query = $this->db->query($sql);
		return $query->rows;	
	}

	/*
FUNCTION NAME 		-	getPkgSubscriptionDetails
DESCRIPTION 		-	Queries all Package Subscription with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getPkgSubscriptionCount($data) {
		$sql = "SELECT count(*) AS total  FROM ".DB_PREFIX."cas_op_transactions cas, ".DB_PREFIX."customer c, ".DB_PREFIX."product_description pd, ".DB_PREFIX."stb sc,".DB_PREFIX."product p WHERE cas.cmd_id =6 AND cas.user_id = c.customer_id
			AND cas.user_id = sc.customer_id AND cas.product_id = pd.product_id AND cas.product_id =p.product_id";
		// if (isset($data['start']) || isset($data['limit'])) {
		// 	if ($data['start'] < 0) {
		// 		$data['start'] = 0;
		// 	}				

		// 	if ($data['limit'] < 1) {
		// 		$data['limit'] = 20;
		// 	}	
		
		// 	$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		// }		
		$query = $this->db->query($sql);
		return $query->row['total'];	
	}


/*
FUNCTION NAME 		-	getPkgSubscriptionDetail
DESCRIPTION 		-	Queries all Package Subscription with their descriptions.
INPUT PARAMETER 	-	product_id,customer_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getPkgSubscriptionDetail($customer_id,$product_id,$id) {	
		$sql = "SELECT CONCAT( c.firstname,  ' ', c.lastname ) AS name, pd.name, cas.product_id,p.model, cas.user_id,sc.stb_no, cas.modify_date, cas.exp_date,cas.id
			FROM ".DB_PREFIX."cas_op_transactions cas, ".DB_PREFIX."customer c, ".DB_PREFIX."product_description pd, ".DB_PREFIX."stb sc, ".DB_PREFIX."product p WHERE cas.cmd_id =6 AND cas.user_id = c.customer_id 
			AND cas.user_id = sc.customer_id AND cas.user_id = '".$customer_id."' AND cas.product_id = pd.product_id AND cas.product_id =p.product_id AND cas.product_id ='".$product_id."' AND cas.id='".$id."'";
			//var_dump($sql);exit();
		$query = $this->db->query($sql);
		return $query->rows;	
	}


		/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>
