<?php
/*
@File alacartewiseactiveconnection.php(MODEL)
LOCALISATION:	 AlaCartewiseActiveconnection PAGE
    This class queries all the packages with the channels added to each of them.

@Author MAHESH YALLURE
@date 20th Nov. 2015
*/
class ModelReportDailyActiveStbvc extends Model {
/*
FUNCTION NAME 		-	getDailyActiveStbCount
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getDailyActiveStbCount($data) {
		$sql = "SELECT COUNT( * ) as stb_count FROM  ".DB_PREFIX."stb WHERE  `customer_id` !=0 AND  `is_black_list` !=1";
		if(isset($data['filter_date']))
		{
			$sql.= " AND  `active_date` <= '".$data['filter_date']."'";
		}else{
			$sql.= " AND  `active_date` <= NOW()";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->row;	
	}

	/*
FUNCTION NAME 		-	getDailyActiveStbCount
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getDailyActiveSCCount($data) {
		$sql = "SELECT COUNT( * ) as sc_count FROM  ".DB_PREFIX."stb WHERE  `customer_id` !=0 AND  `is_black_list` !=1 AND is_smart_card=1";
		if(isset($data['filter_date']))
		{
			$sql.= " AND  `active_date` <= '".$data['filter_date']."'";
		}else{
			$sql.= " AND  `active_date` <= NOW()";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->row;	
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>