<?php
/*
@File coupon.php(MODEL)
REPORT:	 COUPON PAGE
    This class queries the coupon option used by the customer with their count from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportCoupon extends Model {
/*
FUNCTION NAME 		-	getCoupons
DESCRIPTION 		-	Queries all the coupons in the database based on the filter options given if any
INPUT PARAMETER 	-	data array conataining filter option if any
OUTPUT PARAMETER 	- 	Returns all the rows queried.
*/	
	public function getCoupons($data = array()) {
		$sql = "SELECT ch.coupon_id, c.name, c.code, COUNT(DISTINCT ch.order_id) AS `orders`, SUM(ch.amount) AS total FROM `" . DB_PREFIX . "coupon_history` ch LEFT JOIN `" . DB_PREFIX . "coupon` c ON (ch.coupon_id = c.coupon_id)"; 

		$implode = array();
		
		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(c.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(c.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
				
		$sql .= " GROUP BY ch.coupon_id ORDER BY total DESC";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalCoupons
DESCRIPTION 		-	Queries the total number of coupons used used in the each of the orders.
INPUT PARAMETER 	-	data array conataining filter option if any
OUTPUT PARAMETER 	- 	Returns a row with total count.
*/	
	public function getTotalCoupons($data = array()) {
		$sql = "SELECT COUNT(DISTINCT coupon_id) AS total FROM `" . DB_PREFIX . "coupon_history`";
		
		$implode = array();
		
		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}

		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}

		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);

		return $query->row['total'];	
	}		
}
?>