<?php
/*
@File channel_list.php(MODEL)
LOCALISATION:	 channel list PAGE
    This class queries all the  channels .

@Author MAHESH YALLURE
@date 21st Nov. 2015
*/
class ModelReportChannelList extends Model {

	/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails($data=array()) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price,p.broadcaster_id FROM ".DB_PREFIX."product p left join ".DB_PREFIX."product_description pd on(p.product_id = pd.product_id) left join ".DB_PREFIX."broadcaster b on(p.broadcaster_id=b.broadcaster_id) WHERE p.is_package =0 AND p.is_ppv =0 
				GROUP BY p.product_id ORDER BY pd.name";
				if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}				

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
				
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}	
		$query = $this->db->query($sql);
		return $query->rows;	
	 }

	 	/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.product_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the detail row.
*/	
	public function getChannelDetail($product_id) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price,p.broadcaster_id FROM oc_product p, oc_product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->row;	
	}
/*
FUNCTION NAME 		-	getCategories
DESCRIPTION 		-	
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM oc_product p, oc_product_description pd, oc_product_to_category cat, oc_category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}


		/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

	/*
FUNCTION NAME 		-	getTotalChannels
DESCRIPTION 		-	Queries to get the total number of CHANNELS raised in the database.
INPUT PARAMETER 	-
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the table.
*/	
	public function getTotalChannels($data = array()) {
		
		$sql="SELECT count(DISTINCT(p.product_id)) as total FROM ".DB_PREFIX."product p WHERE p.is_package =0 AND p.is_ppv =0";
		$query = $this->db->query($sql);

		return $query->row['total'];	
	}
/*
FUNCTION NAME 		-	getBroadcasterName
DESCRIPTION 		-	Queries to get the name of broadcaster channel belongs the database.
INPUT PARAMETER 	-	boadcaster_id
OUTPUT PARAMETER 	- 	returns a row with column name.
*/	
	public function getBroadcasterName($broadcaster_id)
	{
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."broadcaster WHERE broadcaster_id='".$broadcaster_id."'");
		return $query->row['name'];
	}

}
?>
