<?php
/*
@File settopbox.php(MODEL)
LOCALISATION:	 SETTOPBOX PAGE
    This class queries the location of all the set top boxes ie (customer address) list for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportBroadPayment extends Model {
	/*
FUNCTION NAME 		-	getCustomerAddress
DESCRIPTION 		-	Queries the address for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the row queried containing the address
*/	
	public function getCustomerAddress($customer_id) {
		$query = $this->db->query("SELECT  (c.customer_id),CONCAT(c.firstname, ' ', c.lastname) AS name,(c.STBNO),CONCAT(a.address_1,' ',a.city) AS address,c.date_added,c.status FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "address a ON (c.customer_id = a.customer_id) WHERE c.customer_id = ".$customer_id."");
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getAddress
DESCRIPTION 		-	Queries all the customers address.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the row queried containing address of each customers
*/	

	public function getBroadcasterDetails($data) {
		$sql="SELECT * FROM ".DB_PREFIX."broadcaster_to_store bs LEFT JOIN ".DB_PREFIX."broadcaster b ON(bs.broadcaster_id=b.broadcaster_id)";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
		/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalStbAddress() {

		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."broadcaster_to_store bs LEFT JOIN ".DB_PREFIX."broadcaster b ON(bs.broadcaster_id=b.broadcaster_id)");
		return $query->num_rows;
	}
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

	public function getBroadcasterChannelCount($broadcaster_id) {
		$query = $this->db->query("SELECT count(*) AS total FROM ".DB_PREFIX."broadcaster_channel WHERE `broadcaster_id`='".$broadcaster_id."'");
		return $query->row['total'];
	}


	public function getBroadcaster($broadcaster_id) {
		$order_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "broadcaster_to_store` bs LEFT JOIN `" . DB_PREFIX . "broadcaster` b ON(bs.broadcaster_id=b.broadcaster_id)  WHERE bs.broadcaster_id = '" . (int)$broadcaster_id . "'");

		if ($order_query->num_rows) {
			$reward = 0;
			
			$order_product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "broadcaster_channel WHERE broadcaster_id = '" . (int)$broadcaster_id . "'");
		
			// foreach ($order_product_query->rows as $product) {
			// 	$reward += $product['reward'];
			// }			
			
			$country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int)$order_query->row['country_id'] . "'");

			if ($country_query->num_rows) {
				$payment_iso_code_2 = $country_query->row['iso_code_2'];
				$payment_iso_code_3 = $country_query->row['iso_code_3'];
			} else {
				$payment_iso_code_2 = '';
				$payment_iso_code_3 = '';
			}

			$zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int)$order_query->row['zone_id'] . "'");

			if ($zone_query->num_rows) {
				$payment_zone_code = $zone_query->row['code'];
			} else {
				$payment_zone_code = '';
			}
			
			$country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int)$order_query->row['country_id'] . "'");

			if ($country_query->num_rows) {
				$shipping_iso_code_2 = $country_query->row['iso_code_2'];
				$shipping_iso_code_3 = $country_query->row['iso_code_3'];
			} else {
				$shipping_iso_code_2 = '';
				$shipping_iso_code_3 = '';
			}

			$zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int)$order_query->row['zone_id'] . "'");

			if ($zone_query->num_rows) {
				$shipping_zone_code = $zone_query->row['code'];
			} else {
				$shipping_zone_code = '';
			}
		
			return array(
				'broadcaster_id'          => $order_query->row['broadcaster_id'],
				'invoice_no'              => $order_query->row['broadcaster_id'],
				'invoice_prefix'          => '196',
				'store_id'                => $order_query->row['store_id'],
				'store_name'              => 'Bydesign India Pvt Ltd.',
				'store_url'               => 'http://localhost/sms/upload/',
				
				
				
				'name'              	 => $order_query->row['name'],
				// 'lastname'                => $order_query->row['lastname'],
				'telephone'              => $order_query->row['broadcaster_mobile'],
				'city'                   => $order_query->row['broadcaster_city'],
				'post'                   => $order_query->row['broadcaster_pin'],
				'email'                  => $order_query->row['broadcaster_email'],
				
				// 'payment_company'         => $order_query->row['payment_company'],
				// 'payment_company_id'      => $order_query->row['payment_company_id'],
				// 'payment_tax_id'          => $order_query->row['payment_tax_id'],
				// 'payment_address_1'       => $order_query->row['payment_address_1'],
				// 'payment_address_2'       => $order_query->row['payment_address_2'],
				// 'payment_postcode'        => $order_query->row['payment_postcode'],
				// 'payment_city'            => $order_query->row['payment_city'],
				'zone_id'         			=> $order_query->row['zone_id'],
				// 'payment_zone'            => $order_query->row[''],
				'payment_zone_code'       => $payment_zone_code,
				// 'payment_country_id'      => $order_query->row['payment_country_id'],
				// 'payment_country'         => $order_query->row['payment_country'],
				'payment_iso_code_2'      => $payment_iso_code_2,
				'payment_iso_code_3'      => $payment_iso_code_3,
				'payment_address_format'  => NULL,
				// 'payment_method'          => $order_query->row['payment_method'],
				// 'payment_code'            => $order_query->row['payment_code'],				
				// 'shipping_firstname'      => $order_query->row['shipping_firstname'],
				// 'shipping_lastname'       => $order_query->row['shipping_lastname'],
				// 'shipping_company'        => $order_query->row['shipping_company'],
				// 'shipping_address_1'      => $order_query->row['shipping_address_1'],
				// 'shipping_address_2'      => $order_query->row['shipping_address_2'],
				// 'shipping_postcode'       => $order_query->row['shipping_postcode'],
				// 'shipping_city'           => $order_query->row['shipping_city'],
				// 'shipping_zone_id'        => $order_query->row['shipping_zone_id'],
				// 'shipping_zone'           => $order_query->row['shipping_zone'],
				'shipping_zone_code'      => $shipping_zone_code,
				// 'shipping_country_id'     => $order_query->row['shipping_country_id'],
				// 'shipping_country'        => $order_query->row['shipping_country'],
				'shipping_iso_code_2'     => $shipping_iso_code_2,
				'shipping_iso_code_3'     => $shipping_iso_code_3,
				'shipping_address_format' => NULL,
				// 'shipping_method'         => $order_query->row['shipping_method'],
				// 'shipping_code'           => $order_query->row['shipping_code'],
				// 'comment'                 => $order_query->row['comment'],
				// 'total'                   => $order_query->row['total'],
				'reward'                  => $reward,
				// 'order_status_id'         => $order_query->row['order_status_id'],
				// 'affiliate_id'            => $order_query->row['affiliate_id'],
					
				// 'currency_id'             => $order_query->row['currency_id'],
				'currency_code'           => 'INR',
				'currency_value'          => '1.00000000',
				// 'ip'                      => $order_query->row['ip'],
				// 'forwarded_ip'            => $order_query->row['forwarded_ip'], 
				// 'user_agent'              => $order_query->row['user_agent'],	
				// 'accept_language'         => $order_query->row['accept_language'],					
				// 'date_added'              => $order_query->row['date_added'],
				// 'date_modified'           => $order_query->row['date_modified']
			);
		} else {
			return false;
		}
	}


/*
FUNCTION NAME 		-	getBroadcasterProducts
DESCRIPTION 		-	Retrieves the order products for the given order_id
INPUT PARAMETER 	-	order_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/		
	public function getBroadcasterProducts($order_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "broadcaster_channel WHERE broadcaster_id = '" . (int)$order_id . "'");
		
		return $query->rows;
	}


/*
FUNCTION NAME 		-	getOrderTotals
DESCRIPTION 		-	Retrieves the order total amount for the given order_id
INPUT PARAMETER 	-	order_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/					
	public function getChannelTotals($broacaster_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "broadcaster_channel WHERE broadcaster_id = '" . (int)$broacaster_id . "'");

		return $query->rows;
	}	



}
?>