<?php
/*
@File alacartewise_activeconnection_summary.php(MODEL)
LOCALISATION:	 Alacartewise_activeconnection_summary PAGE
    This class queries all the packages with the channels added to each of them.

@Author MAHESH YALLURE
@date 20th Nov. 2015
*/
class ModelReportAlacarteWiseActiveconnectionSummary extends Model {
/*
FUNCTION NAME 		-	getAlacarteWiseActiveConn
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getAlacarteWiseActiveConn($data) {
		$sql = "SELECT c.tx_id,c.product_id,pd.name as pname,c.modify_date,c.exp_date,c.cmd_id,pd.name,sc.current_stbno,CONCAT( cus.firstname,' ' ,cus.lastname) as name,p.service_id
		FROM ".DB_PREFIX."cas_op_transactions c, ".DB_PREFIX."product p,".DB_PREFIX."product_description pd,".DB_PREFIX."customer cus ,".DB_PREFIX."customer_stb_cas sc 
		WHERE p.product_id = c.product_id AND p.product_id = pd.product_id AND c.user_id=cus.customer_id AND cus.customer_id=sc.customer_id
		AND p.is_package =0 AND p.is_ppv =0";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getTotalAlaCarteWiseActiveConn
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalAlaCarteWiseActiveConn() {
		$query = $this->db->query("SELECT count(*) AS total FROM ".DB_PREFIX."cas_op_transactions c, ".DB_PREFIX."product p,".DB_PREFIX."product_description pd,".DB_PREFIX."customer cus ,".DB_PREFIX."customer_stb_cas sc 
			WHERE p.product_id = c.product_id AND p.product_id = pd.product_id AND c.user_id=cus.customer_id AND cus.customer_id=sc.customer_id
			AND p.is_package =0 AND p.is_ppv =0");

		return $query->row['total'];
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/

	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getAlacarte
DESCRIPTION 		-	Queries the selected Ala carte details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getAlacarte($tx_id) {
		$query = $this->db->query("SELECT c.product_id,c.modify_date,c.exp_date,c.cmd_id,pd.name,sc.current_stbno,sc.current_casno,CONCAT( cus.firstname,' ' ,cus.lastname) as name,p.service_id,p.status
		FROM ".DB_PREFIX."cas_op_transactions c, ".DB_PREFIX."product p,".DB_PREFIX."product_description pd,".DB_PREFIX."customer cus ,".DB_PREFIX."customer_stb_cas sc 
		WHERE c.tx_id = '".$tx_id."' AND p.product_id = c.product_id AND p.product_id = pd.product_id AND c.user_id=cus.customer_id AND cus.customer_id=sc.customer_id
		AND p.is_package =0 AND p.is_ppv =0");
		return $query->rows;
	}

}
?>