<?php
/*
@File alacartewiseactiveconnection.php(MODEL)
LOCALISATION:	 AlaCartewiseActiveconnection PAGE
    This class queries all the packages with the channels added to each of them.

@Author MAHESH YALLURE
@date 20th Nov. 2015
*/
class ModelReportAlaCartewiseActiveconnection extends Model {
/*
FUNCTION NAME 		-	getAlacarteWiseActiveConn
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getAlacarteWiseActiveConn($data) {
	$sql = "SELECT COUNT( DISTINCT(c.user_id) ) AS total, c.product_id,pd.name FROM ".DB_PREFIX."cas_op_transactions c, ".DB_PREFIX."product p,".DB_PREFIX."product_description pd
		WHERE p.product_id = c.product_id AND p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 GROUP BY  `product_id` ";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getTotalAlaCarteWiseActiveConn
DESCRIPTION 		-	Queries all the Ala Carte details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getTotalAlaCarteWiseActiveConn() {
		$query = $this->db->query("SELECT count(DISTINCT(c.product_id)) AS total FROM " . DB_PREFIX . "cas_op_transactions c," . DB_PREFIX . "product p where p.product_id=c.product_id AND p.is_package=0 AND p.is_ppv=0");
		return $query->row['total'];
	}

/*
FUNCTION NAME 		-	getAlacarte
DESCRIPTION 		-	Queries the selected Ala carte details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getAlacarte($product_id) {
		$query = $this->db->query("SELECT COUNT(DISTINCT (c.user_id)) AS total, pd.name FROM " . DB_PREFIX . "cas_op_transactions c, " . DB_PREFIX . "product p, " . DB_PREFIX . "product_description pd
		WHERE p.product_id = c.product_id AND p.product_id = pd.product_id AND  c.product_id='".$product_id."' AND p.is_package =0");
		return $query->rows;
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>