<?php
/*
@File active_deactive.php(MODEL)
REPORT:	 ACTIVE_DEACTIVE PAGE
    This class queries the active_deactive list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportActiveDeactiveHistory extends Model {
/*
FUNCTION NAME 		-	getCustomerStatus
DESCRIPTION 		-	Retrieves the historial data in terms of activations and deactivations
						for channels/packages for the customer.
INPUT PARAMETER 	-	customer_id, product_id
OUTPUT PARAMETER 	- 	Returns all the rows queried
*/
	public function getCustomerStatus($customer_id,$product_id) {
		$var ="";
		if($product_id=="")
			$var = "(c.customer_id= ".$customer_id.")";
		else
			$var = "(c.customer_id= ".$customer_id." and s.product_id =".$product_id.")";
		$query = $this->db->query("SELECT DISTINCT(CONCAT(c.firstname, ' ', c.lastname)) AS name,c.customer_id, datediff(s.expire_date,s.start_date) as status , datediff(s.expire_date,s.start_date) as due , (pd.name) as product_name,pd.product_id,STBNO,c.date_added,s.start_date,s.expire_date FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "subscription s ON (c.customer_id=s.customer_id) LEFT JOIN ". DB_PREFIX ."product_description pd ON (s.product_id=pd.product_id) where $var ORDER BY CONCAT(c.firstname, ' ', c.lastname) ASC");
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getStatus
DESCRIPTION 		-	Retrieves all the subscription status for all the orders.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing subscription staus,customer_id and other details.
*/
	public function getStatus($data = array()) {
		$sql = "SELECT s.customer_id,s.product_id,CONCAT(c.firstname, ' ', c.lastname) AS name, datediff(s.expire_date,s.start_date) as status , datediff(s.expire_date,s.start_date) as due , (pd.name) as product_name,STBNO,c.date_added,s.start_date,s.expire_date  FROM " . DB_PREFIX . "customer c," . DB_PREFIX . "subscription s RIGHT JOIN " . DB_PREFIX . "product_description pd ON (s.product_id=pd.product_id) WHERE s.customer_id=c.customer_id GROUP BY s.customer_id,s.product_id ORDER BY CONCAT(c.firstname, ' ', c.lastname) ASC ";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getStatusTotal
DESCRIPTION 		-	Retrieves all the subscription status for all the orders.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing subscription staus,customer_id and other details.
*/
	public function getStatusTotal() {
		$query = $this->db->query("SELECT s.customer_id FROM " . DB_PREFIX . "customer c," . DB_PREFIX . "subscription s RIGHT JOIN " . DB_PREFIX . "product_description pd ON (s.product_id=pd.product_id) WHERE s.customer_id=c.customer_id GROUP BY s.customer_id,s.product_id ORDER BY CONCAT(c.firstname, ' ', c.lastname) ASC ");
		return $query->num_rows;
		
	}

/*
FUNCTION NAME 		-	getServiceid
DESCRIPTION 		-	Retrieves all the subscription status for all the orders.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing subscription staus,customer_id and other details.
*/
	public function getServiceid($product_id) {
		$query = $this->db->query("SELECT service_id FROM " . DB_PREFIX . "product where product_id='".(int)$product_id."' AND is_package=0");
		return $query->row;
		
	}
}
?>
