<?php
/*
@File a_la_carte.php(MODEL)
REPORT:	 A_LA_CARTE PAGE
    This class queries the a_la_carte list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelReportAlaCarte extends Model {

/*
FUNCTION NAME 		-	getProduct
DESCRIPTION 		-	Retrieves details for the given product_id in the a_la_carte. 
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows queried
*/
	public function getProduct($product_id)
	{
		$query = $this->db->query("SELECT DISTINCT(p.product_id),(p.image) as image , (pd.name) as name , (p.model) as model,(p.price) as price , (p.quantity) as quantity , p.is_package FROM ". DB_PREFIX . "product p LEFT JOIN ". DB_PREFIX . "product_description pd ON (p.product_id=pd.product_id) where p.product_id=".$product_id."");
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getTotal_a_la_carte
DESCRIPTION 		-	Retrieves all the products for the a_la_carte
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried
*/
	public function getTotal_a_la_carte($product_id)
	{
		$sql ="SELECT count(*) AS total FROM ". DB_PREFIX . "product p LEFT JOIN ". DB_PREFIX . "product_description pd ON (p.product_id=pd.product_id) where p.is_ppv=0 AND p.is_package=0";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

/*
FUNCTION NAME 		-	getProducts
DESCRIPTION 		-	Retrieves all the products for the a_la_carte
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows queried
*/
	public function getProducts($data)
	{
		$sql ="SELECT DISTINCT(p.product_id),(p.image) as image , (pd.name) as name ,p.is_package,p.is_ppv, (p.model) as model,(p.price) as price , (p.quantity) as quantity FROM ". DB_PREFIX . "product p LEFT JOIN ". DB_PREFIX . "product_description pd ON (p.product_id=pd.product_id) WHERE p.is_package=0 AND p.is_ppv=0";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
		/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

	/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd, ".DB_PREFIX."product_to_category cat, ".DB_PREFIX."category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}

}
?>