<?php
/*
@File order.php(MODEL)
SALE:	 ORDER PAGE
    Manages the customer order by inserting, deleting and updating the order informations. 
    It also retrieves the customer orders if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelQuickSearch extends Model {


/*
FUNCTION NAME 		-	getOrders
DESCRIPTION 		-	Retrieves all the orders from the database.
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/		
	public function getOrders($data = array()) {
		// $filteredSTB= $this->getSTBFromPasscode((string)$data['filter_value']);
      	$sql = "SELECT *,CONCAT( c.firstname,' ', c.lastname ) as name FROM oc_address a LEFT JOIN oc_customer c ON ( c.customer_id = a.customer_id )";
      	$implode=array();
      	if($this->session->data['user_group_id']!=1)
      	{
      		$implode[]=" c.operator_id ='" . $this->session->data['user_id'] . "'";
      	}
		if(((!(strcasecmp('customer_unique_id',$data['filter_option'])))||(!(strcasecmp('email',$data['filter_option'])))||(!(strcasecmp('passcode',$data['filter_option'])))||(!(strcasecmp('telephone',$data['filter_option'])))||(!(strcasecmp('STBNO',$data['filter_option']))))&&(!is_null($data['filter_value'])))
		{

		 	// $filter_option="c.".$data['filter_option'];
		 	// $filter_value= $data['filter_value'];
		 	// $implode[]= " ".$filter_option." like '%" . (string)$data['filter_value'] . "%'";
		 	if(strcasecmp('passcode',$data['filter_option'])==0){
		 		$filteredSTB= $this->getSTBFromPasscode((string)$data['filter_value']);
		 		$filter_option="c.STBNO";
		 		$filter_value= $filteredSTB;
		 		$implode[]= " ".$filter_option." LIKE '%" . $this->db->escape((string)$filteredSTB) . "%'";
		 	}else{
		 		$filter_option="c.".$data['filter_option'];
		 		$filter_value= $data['filter_value'];
		 		$implode[]= " ".$filter_option." LIKE '%" . $this->db->escape((string)$data['filter_value']) . "%'";
		 	}
	 			
		}else if($data['filter_option']=='firstname'){
			$filter_value= ($data['filter_value']!= '')?$data['filter_value'] : -1;
			$implode[]= " CONCAT( c.firstname,' ',c.lastname ) like '%" . $this->db->escape((string)$filter_value) . "%'";
		}else if($data['filter_option']=='operator'){
			$filter_operator= $data['filter_operator'];
			$implode[]= " c.operator_id = ".$filter_operator."";
		}
		else{
		 	$filter_option="a.".$data['filter_option'];
		 	$filter_value= $data['filter_value'];
		 	$implode[]=" ".$filter_option." like '%" . $this->db->escape((string)$data['filter_value']) . "%'";
		}
		if($implode){
			$sql.=" WHERE ".implode( ' AND ', $implode);
		}
		$sql .= " GROUP BY c.customer_id ";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		 $query = $this->db->query($sql);
	   return $query->rows;
	}


/*
FUNCTION NAME 		-	getTotalOrders
DESCRIPTION 		-	Retrieves the total count for all the orders from the database.
INPUT PARAMETER 	-	data array containing filter options if any.
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalOrders($data = array()) {
		// $filteredSTB= $this->getSTBFromPasscode((string)$data['filter_value']);
		$sql = "SELECT COUNT(DISTINCT(c.customer_id)) AS total FROM oc_customer c LEFT JOIN oc_address a ON ( c.customer_id = a.customer_id )"; 
		$implode=array();
      	if($this->session->data['user_group_id']!=1)
      	{
      		$implode[]=" c.operator_id ='" . $this->session->data['user_id'] . "'";
      	}
		 if(((!(strcasecmp('customer_unique_id',$data['filter_option'])))||(!(strcasecmp('email',$data['filter_option'])))||(!(strcasecmp('telephone',$data['filter_option'])))||(!(strcasecmp('passcode',$data['filter_option'])))||(!(strcasecmp('STBNO',$data['filter_option']))))&&(!is_null($data['filter_value'])))
		 {
		 	// $filter_option="c.".$data['filter_option'];
		 	// $filter_value= $data['filter_value'];
		 	// $implode[]= " ".$filter_option." LIKE '%" . (string)$data['filter_value'] . "%'";
		 	if(strcasecmp('passcode',$data['filter_option'])==0){
		 		$filteredSTB= $this->getSTBFromPasscode((string)$data['filter_value']);
		 		$filter_option="c.STBNO";
		 		$filter_value= $filteredSTB;
		 		$implode[]= " ".$filter_option." LIKE '%" . $this->db->escape((string)$filteredSTB) . "%'";
		 	}else{
		 		$filter_option="c.".$data['filter_option'];
		 		$filter_value= $data['filter_value'];
		 		$implode[]= " ".$filter_option." LIKE '%" . $this->db->escape((string)$data['filter_value']) . "%'";
		 	}
	 	
		}else if($data['filter_option']=='firstname'){
			$filter_value= ($data['filter_value']!= '')?$data['filter_value'] : -1;
			$implode[]= " CONCAT( c.firstname,' ',c.lastname ) like '%" . $this->db->escape((string)$filter_value) . "%'";
		}else if($data['filter_option']=='operator'){
			$filter_operator= $data['filter_operator'];
			$implode[]= " c.operator_id = ".$filter_operator."";
		}
		else{
		 	$filter_option="a.".$data['filter_option'];
		 	$filter_value= $data['filter_value'];
		 	$implode[]= " ".$filter_option." LIKE '%" . $this->db->escape((string)$data['filter_value']) . "%'";
		 	}
		if($implode){
			$sql.=" WHERE ".implode( ' AND ', $implode);
		}
		$query = $this->db->query($sql);
	 	return $query->row['total'];
	}


public function getDetails($customer_id) {
    
      	$sql = "SELECT *FROM oc_customer c LEFT JOIN oc_address a ON ( c.customer_id = a.customer_id )WHERE c.customer_id='".$customer_id."'";
		// if (($data['filter_option'] == ('customer_id' )) && !is_null($data['filter_value']) )  {
		//  	$filter_option="c.".$data['filter_option'];
		//  	$filter_value= $data['filter_value'];
		//  	$sql .= " WHERE ".$filter_option." = '" . (string)$data['filter_value'] . "'";
	 // 			$query = $this->db->query($sql);
		//  	}
		//  	else{
		//  			$filter_option="a.".$data['filter_option'];
		//  			$filter_value= $data['filter_value'];
		//  		$sql .= " WHERE ".$filter_option." = '" . (string)$data['filter_value'] . "'";
	 // 			$query = $this->db->query($sql);
		//  	}
		
		$query = $this->db->query($sql);
	   return $query->rows;
	}

public function getOperatorList(){
	if($this->session->data['user_group_id']==1){
		$sql = "SELECT user_id, username FROM oc_user ORDER BY user_id ASC";
	}else{
		$sql = "SELECT user_id, username FROM oc_user WHERE user_id=".$this->session->data['user_id']." ORDER BY user_id ASC ";
	}
	$query = $this->db->query($sql);
	return $query->rows;
}

public function getOperatorDetails($operator_id){
	$sql = "SELECT user_id, username FROM oc_user WHERE user_id = ".$operator_id."";
	$query = $this->db->query($sql);
	return $query->row;
}

public function getOperatorIdWithSTB($operator_id){
	$sql = "SELECT operator_id, STBNO FROM oc_customer WHERE operator_id = ".$operator_id."";
	$query = $this->db->query($sql);
	return $query->rows;
}

public function getSTBFromPasscode($passcode){
	$obj = new restapi();
	$data="passcode=".$passcode;
	 		$method ="POST";
	 		$url=KMS_API."/getSTBFromPasscode";	
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
       	 	$response=json_decode($apiresult);
       	 	
       	 	foreach ($response as $key => $value) {
       	 		return $value; break;
       	 	}
       	 	
}
}
?>