<?php 
/*
@File tax_rate.php(MODEL)
LOCALISATION:	 TAX_RATE PAGE
    This class queries,adds and updates the tax_rate details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationTaxRate extends Model {
/*
FUNCTION NAME 		-	addTaxRate
DESCRIPTION 		-	Adds new tax_rate detail to the database.
INPUT PARAMETER 	-	data array containing the tax_rate description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for tax_rate and returns to 
						the tax_rate list page with a success notification
*/	
	public function addTaxRate($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "tax_rate SET name = '" . $this->db->escape($data['name']) . "', rate = '" . (float)$data['rate'] . "', `type` = '" . $this->db->escape($data['type']) . "', geo_zone_id = '" . (int)$data['geo_zone_id'] . "', date_added = NOW(), date_modified = NOW()");
		
		$tax_rate_id = $this->db->getLastId();
		
		if (isset($data['tax_rate_customer_group'])) {
			foreach ($data['tax_rate_customer_group'] as $customer_group_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tax_rate_to_customer_group SET tax_rate_id = '" . (int)$tax_rate_id . "', customer_group_id = '" . (int)$customer_group_id . "'");
			}
		}
	}
/*
FUNCTION NAME 		-	editTaxRate
DESCRIPTION 		-	Updates the tax_rate detail given for the given tax_rate_id.
INPUT PARAMETER 	-	tax_rate_id, data array containing the tax_rate description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for tax_rate and returns to 
						the tax_rate list page with a success notification
*/	
	public function editTaxRate($tax_rate_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "tax_rate SET name = '" . $this->db->escape($data['name']) . "', rate = '" . (float)$data['rate'] . "', `type` = '" . $this->db->escape($data['type']) . "', geo_zone_id = '" . (int)$data['geo_zone_id'] . "', date_modified = NOW() WHERE tax_rate_id = '" . (int)$tax_rate_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "tax_rate_to_customer_group WHERE tax_rate_id = '" . (int)$tax_rate_id . "'");
		
		if (isset($data['tax_rate_customer_group'])) {
			foreach ($data['tax_rate_customer_group'] as $customer_group_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tax_rate_to_customer_group SET tax_rate_id = '" . (int)$tax_rate_id . "', customer_group_id = '" . (int)$customer_group_id . "'");
			}
		}		
	}
/*
FUNCTION NAME 		-	deleteTaxRate
DESCRIPTION 		-	Deletes the tax_rate detail for the given tax_rate_id.
INPUT PARAMETER 	-	tax_rate_id
OUTPUT PARAMETER 	- 	Deletes the given tax_rate details and the cache for tax_rate and returns to 
						the tax_rate list page with a success notification
*/	
	public function deleteTaxRate($tax_rate_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "tax_rate WHERE tax_rate_id = '" . (int)$tax_rate_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "tax_rate_to_customer_group WHERE tax_rate_id = '" . (int)$tax_rate_id . "'");
	}
/*
FUNCTION NAME 		-	getTaxRate
DESCRIPTION 		-	Queries the tax_rate details for the given tax_rate_id from the database.
INPUT PARAMETER 	-	tax_rate_id
OUTPUT PARAMETER 	- 	Returns the asked tax_rate details.
*/	
	public function getTaxRate($tax_rate_id) {
		$query = $this->db->query("SELECT tr.tax_rate_id, tr.name AS name, tr.rate, tr.type, tr.geo_zone_id, gz.name AS geo_zone, tr.date_added, tr.date_modified FROM " . DB_PREFIX . "tax_rate tr LEFT JOIN " . DB_PREFIX . "geo_zone gz ON (tr.geo_zone_id = gz.geo_zone_id) WHERE tr.tax_rate_id = '" . (int)$tax_rate_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getTaxRates
DESCRIPTION 		-	Queries all the tax_rate details from the database.
INPUT PARAMETER 	-	data array containing the filter options if any 
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getTaxRates($data = array()) {
		$sql = "SELECT tr.tax_rate_id, tr.name AS name, tr.rate, tr.type, gz.name AS geo_zone, tr.date_added, tr.date_modified FROM " . DB_PREFIX . "tax_rate tr LEFT JOIN " . DB_PREFIX . "geo_zone gz ON (tr.geo_zone_id = gz.geo_zone_id)";

		$sort_data = array(
			'tr.name',
			'tr.rate',
			'tr.type',
			'gz.name',
			'tr.date_added',
			'tr.date_modified'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY tr.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
	
		return $query->rows;		
	}
/*
FUNCTION NAME 		-	getTaxRateCustomerGroups
DESCRIPTION 		-	Queries to get the customer group for the given tax_rate_id
INPUT PARAMETER 	-	tax_rate_id
OUTPUT PARAMETER 	- 	returns an array with the cutomer_group_id
*/		
	public function getTaxRateCustomerGroups($tax_rate_id) {
		$tax_customer_group_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tax_rate_to_customer_group WHERE tax_rate_id = '" . (int)$tax_rate_id . "'");
		
		foreach ($query->rows as $result) {
			$tax_customer_group_data[] = $result['customer_group_id'];
		}
		
		return $tax_customer_group_data;			
	}
/*
FUNCTION NAME 		-	getTotalTaxRates
DESCRIPTION 		-	Queries to get the total number of tax_rate in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the tax_rate table.
*/				
	public function getTotalTaxRates() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "tax_rate");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalTaxRatesByGeoZoneId
DESCRIPTION 		-	Queries to get total number of tax_rate in the given geo_zone_id
INPUT PARAMETER 	-	geo_zone_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the matching geo_zone_id
*/	
	public function getTotalTaxRatesByGeoZoneId($geo_zone_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "tax_rate WHERE geo_zone_id = '" . (int)$geo_zone_id . "'");
		
		return $query->row['total'];
	}
}
?>