<?php 
/*
@File tax_class.php(MODEL)
LOCALISATION:	 TAX_CLASS PAGE
    This class queries,adds and updates the tax_class details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationTaxClass extends Model {
/*
FUNCTION NAME 		-	addTaxClass
DESCRIPTION 		-	Adds new tax_class detail to the database.
INPUT PARAMETER 	-	data array containing the tax_class description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for tax_class and returns to 
						the tax_class list page with a success notification
*/	
	public function addTaxClass($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "tax_class SET title = '" . $this->db->escape($data['title']) . "', description = '" . $this->db->escape($data['description']) . "', date_added = NOW()");
		
		$tax_class_id = $this->db->getLastId();
		
		if (isset($data['tax_rule'])) {
			foreach ($data['tax_rule'] as $tax_rule) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tax_rule SET tax_class_id = '" . (int)$tax_class_id . "', tax_rate_id = '" . (int)$tax_rule['tax_rate_id'] . "', based = '" . $this->db->escape($tax_rule['based']) . "', priority = '" . (int)$tax_rule['priority'] . "'");
			}
		}
		
		$this->cache->delete('tax_class');
	}
/*
FUNCTION NAME 		-	editTaxClass
DESCRIPTION 		-	Updates the tax_class detail given for the given tax_class_id.
INPUT PARAMETER 	-	tax_class_id, data array containing the tax_class description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for tax_class and returns to 
						the tax_class list page with a success notification
*/	
	public function editTaxClass($tax_class_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "tax_class SET title = '" . $this->db->escape($data['title']) . "', description = '" . $this->db->escape($data['description']) . "', date_modified = NOW() WHERE tax_class_id = '" . (int)$tax_class_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "tax_rule WHERE tax_class_id = '" . (int)$tax_class_id . "'");

		if (isset($data['tax_rule'])) {
			foreach ($data['tax_rule'] as $tax_rule) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "tax_rule SET tax_class_id = '" . (int)$tax_class_id . "', tax_rate_id = '" . (int)$tax_rule['tax_rate_id'] . "', based = '" . $this->db->escape($tax_rule['based']) . "', priority = '" . (int)$tax_rule['priority'] . "'");
			}
		}
		
		$this->cache->delete('tax_class');
	}
/*
FUNCTION NAME 		-	deleteTaxClass
DESCRIPTION 		-	Deletes the tax_class detail for the given tax_class_id.
INPUT PARAMETER 	-	tax_class_id
OUTPUT PARAMETER 	- 	Deletes the given tax_class details and the cache for tax_class and returns to 
						the tax_class list page with a success notification
*/	
	public function deleteTaxClass($tax_class_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "tax_class WHERE tax_class_id = '" . (int)$tax_class_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "tax_rule WHERE tax_class_id = '" . (int)$tax_class_id . "'");
		
		$this->cache->delete('tax_class');
	}
/*
FUNCTION NAME 		-	getTaxClass
DESCRIPTION 		-	Queries the tax_class details for the given tax_class_id from the database.
INPUT PARAMETER 	-	tax_class_id
OUTPUT PARAMETER 	- 	Returns the asked tax_class details.
*/	
	public function getTaxClass($tax_class_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tax_class WHERE tax_class_id = '" . (int)$tax_class_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getTaxClasses
DESCRIPTION 		-	Queries all the tax_class details from the database.
INPUT PARAMETER 	-	data array containing the filter options if any 
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getTaxClasses($data = array()) {
    	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "tax_class";

			$sql .= " ORDER BY title";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}					

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
			
	  		$query = $this->db->query($sql);
		
			return $query->rows;		
		} else {
			$tax_class_data = $this->cache->get('tax_class');

			if (!$tax_class_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tax_class");
	
				$tax_class_data = $query->rows;
			
				$this->cache->set('tax_class', $tax_class_data);
			}
			
			return $tax_class_data;			
		}
	}
/*
FUNCTION NAME 		-	getTotalCurrencies
DESCRIPTION 		-	Queries to get the total number of tax_class in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the tax_class table.
*/					
	public function getTotalTaxClasses() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "tax_class");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTaxRules
DESCRIPTION 		-	Queries to get the tax_rule for the given tax_class_id
INPUT PARAMETER 	-	tax_class_id
OUTPUT PARAMETER 	- 	returns a row with tax_rule
*/		
	public function getTaxRules($tax_class_id) {
      	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tax_rule WHERE tax_class_id = '" . (int)$tax_class_id . "'");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalTaxRulesByTaxRateId
DESCRIPTION 		-	Queries to get the total number of tax_rules for the given tax_rate_id.
INPUT PARAMETER 	-	tax_rate_id
OUTPUT PARAMETER 	- 	returns a row with column total containing count for matching tax_rate_id
*/	
	public function getTotalTaxRulesByTaxRateId($tax_rate_id) {
      	$query = $this->db->query("SELECT COUNT(DISTINCT tax_class_id) AS total FROM " . DB_PREFIX . "tax_rule WHERE tax_rate_id = '" . (int)$tax_rate_id . "'");
		
		return $query->row['total'];
	}		
}
?>