<?php 
/*
@File return_status.php(MODEL)
LOCALISATION:	 RETURN_STATUS PAGE
    This class queries,adds and updates the return status details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationReturnStatus extends Model {
/*
FUNCTION NAME 		-	addReturnStatus
DESCRIPTION 		-	Adds new return_status detail to the database.
INPUT PARAMETER 	-	data array containing the return_status description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for return_status and returns to 
						the return_status list page with a success notification
*/	
	public function addReturnStatus($data) {
		foreach ($data['return_status'] as $language_id => $value) {
			if (isset($return_status_id)) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "return_status SET return_status_id = '" . (int)$return_status_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
			} else {
				$this->db->query("INSERT INTO " . DB_PREFIX . "return_status SET language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
				
				$return_status_id = $this->db->getLastId();
			}
		}
		
		$this->cache->delete('return_status');
	}
/*
FUNCTION NAME 		-	editReturnStatus
DESCRIPTION 		-	Updates the return_status detail given for the given return_status_id.
INPUT PARAMETER 	-	return_status_id, data array containing the return_status description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for return_status and returns to 
						the return_status list page with a success notification
*/
	public function editReturnStatus($return_status_id, $data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "return_status WHERE return_status_id = '" . (int)$return_status_id . "'");

		foreach ($data['return_status'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "return_status SET return_status_id = '" . (int)$return_status_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->cache->delete('return_status');
	}
/*
FUNCTION NAME 		-	deleteReturnStatus
DESCRIPTION 		-	Deletes the return_status detail for the given return_status_id.
INPUT PARAMETER 	-	return_status_id
OUTPUT PARAMETER 	- 	Deletes the given return_status details and the cache for return_status and returns to 
						the return_status list page with a success notification
*/	
	public function deleteReturnStatus($return_status_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "return_status WHERE return_status_id = '" . (int)$return_status_id . "'");
	
		$this->cache->delete('return_status');
	}
/*
FUNCTION NAME 		-	getReturnStatus
DESCRIPTION 		-	Queries the return_status details for the given return_status_id from the database.
INPUT PARAMETER 	-	return_status_id
OUTPUT PARAMETER 	- 	Returns the asked return_status details.
*/		
	public function getReturnStatus($return_status_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "return_status WHERE return_status_id = '" . (int)$return_status_id . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getReturnStatuses
DESCRIPTION 		-	Queries all the return_status details from the database.
INPUT PARAMETER 	-	data array containing filter values if any.
OUTPUT PARAMETER 	- 	Returns all the return_status details queried.
*/			
	public function getReturnStatuses($data = array()) {
      	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "return_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'";
			
			$sql .= " ORDER BY name";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$return_status_data = $this->cache->get('return_status.' . (int)$this->config->get('config_language_id'));
		
			if (!$return_status_data) {
				$query = $this->db->query("SELECT return_status_id, name FROM " . DB_PREFIX . "return_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY name");
	
				$return_status_data = $query->rows;
			
				$this->cache->set('return_status.' . (int)$this->config->get('config_language_id'), $return_status_data);
			}	
	
			return $return_status_data;				
		}
	}
/*
FUNCTION NAME 		-	getReturnStatusDescriptions
DESCRIPTION 		-	Queries to get the description for the given return_status from the database.
INPUT PARAMETER 	-	return_status_id
OUTPUT PARAMETER 	- 	returns a row with the return_status description
*/	
	public function getReturnStatusDescriptions($return_status_id) {
		$return_status_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "return_status WHERE return_status_id = '" . (int)$return_status_id . "'");
		
		foreach ($query->rows as $result) {
			$return_status_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $return_status_data;
	}
/*
FUNCTION NAME 		-	getTotalReturnStatuses
DESCRIPTION 		-	Queries to get the total number of return_status in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the return_status table.
*/	
	public function getTotalReturnStatuses() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "return_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}	
}
?>