<?php 
/*
@File return_reason.php(MODEL)
LOCALISATION:	 RETURN_REASON PAGE
    This class queries,adds and updates the return reason details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationReturnReason extends Model {
/*
FUNCTION NAME 		-	addReturnReason
DESCRIPTION 		-	Adds new return_reason detail to the database.
INPUT PARAMETER 	-	data array containing the return_reason description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for return_reason and returns to 
						the return_reason list page with a success notification
*/	
	public function addReturnReason($data) {
		foreach ($data['return_reason'] as $language_id => $value) {
			if (isset($return_reason_id)) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "return_reason SET return_reason_id = '" . (int)$return_reason_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
			} else {
				$this->db->query("INSERT INTO " . DB_PREFIX . "return_reason SET language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
				
				$return_reason_id = $this->db->getLastId();
			}
		}
		
		$this->cache->delete('return_reason');
	}
/*
FUNCTION NAME 		-	editReturnReason
DESCRIPTION 		-	Updates the return_reason detail given for the given return_reason_id.
INPUT PARAMETER 	-	return_reason_id, data array containing the return_reason description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for return_reason and returns to 
						the return_reason list page with a success notification
*/
	public function editReturnReason($return_reason_id, $data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "'");

		foreach ($data['return_reason'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "return_reason SET return_reason_id = '" . (int)$return_reason_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->cache->delete('return_reason');
	}
/*
FUNCTION NAME 		-	deleteReturnReason
DESCRIPTION 		-	Deletes the return_reason detail for the given return_reason_id.
INPUT PARAMETER 	-	return_reason_id
OUTPUT PARAMETER 	- 	Deletes the given return_reason details and the cache for return_reason and returns to 
						the return_reason list page with a success notification
*/	
	public function deleteReturnReason($return_reason_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "'");
	
		$this->cache->delete('return_reason');
	}
/*
FUNCTION NAME 		-	getReturnReason
DESCRIPTION 		-	Queries the return_reason details for the given return_reason_id from the database.
INPUT PARAMETER 	-	return_reason_id
OUTPUT PARAMETER 	- 	Returns the asked return_reason details.
*/		
	public function getReturnReason($return_reason_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getReturnReasons
DESCRIPTION 		-	Queries all the return_reason details from the database.
INPUT PARAMETER 	-	data array containing filter values if any.
OUTPUT PARAMETER 	- 	Returns all the return_reason details queried.
*/			
	public function getReturnReasons($data = array()) {
      	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "return_reason WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'";
			
			$sql .= " ORDER BY name";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$return_reason_data = $this->cache->get('return_reason.' . (int)$this->config->get('config_language_id'));
		
			if (!$return_reason_data) {
				$query = $this->db->query("SELECT return_reason_id, name FROM " . DB_PREFIX . "return_reason WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY name");
	
				$return_reason_data = $query->rows;
			
				$this->cache->set('return_reason.' . (int)$this->config->get('config_language_id'), $return_reason_data);
			}	
	
			return $return_reason_data;				
		}
	}
/*
FUNCTION NAME 		-	getReturnReasonDescriptions
DESCRIPTION 		-	Queries to get the description for the given return_reason from the database.
INPUT PARAMETER 	-	return_reason_id
OUTPUT PARAMETER 	- 	returns a row with the return reason description
*/	
	public function getReturnReasonDescriptions($return_reason_id) {
		$return_reason_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "return_reason WHERE return_reason_id = '" . (int)$return_reason_id . "'");
		
		foreach ($query->rows as $result) {
			$return_reason_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $return_reason_data;
	}
/*
FUNCTION NAME 		-	getTotalReturnReasons
DESCRIPTION 		-	Queries to get the total number of return_reason in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the country table.
*/	
	public function getTotalReturnReasons() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "return_reason WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}	
}
?>