<?php 
/*
@File order_status.php(MODEL)
LOCALISATION:	 ORDER_STATUS PAGE
    This class queries,adds and updates the order status details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationOrderStatus extends Model {
/*
FUNCTION NAME 		-	addOrderStatus
DESCRIPTION 		-	Adds new order_status detail to the database.
INPUT PARAMETER 	-	data array containing the order_status description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for order_status and returns to 
						the order_status list page with a success notification
*/	
	public function addOrderStatus($data) {
		foreach ($data['order_status'] as $language_id => $value) {
			if (isset($order_status_id)) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "order_status SET order_status_id = '" . (int)$order_status_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
			} else {
				$this->db->query("INSERT INTO " . DB_PREFIX . "order_status SET language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
				
				$order_status_id = $this->db->getLastId();
			}
		}
		
		$this->cache->delete('order_status');
	}
/*
FUNCTION NAME 		-	editOrderStatus
DESCRIPTION 		-	Updates the order_status detail given for the given order_status_id.
INPUT PARAMETER 	-	order_status_id, data array containing the order_status description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for order_status and returns to 
						the order_status list page with a success notification
*/
	public function editOrderStatus($order_status_id, $data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "order_status WHERE order_status_id = '" . (int)$order_status_id . "'");

		foreach ($data['order_status'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "order_status SET order_status_id = '" . (int)$order_status_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->cache->delete('order_status');
	}
/*
FUNCTION NAME 		-	deleteOrderStatus
DESCRIPTION 		-	Deletes the order_status detail for the given order_status_id.
INPUT PARAMETER 	-	order_status_id
OUTPUT PARAMETER 	- 	Deletes the given order_status details and the cache for order_status and returns to 
						the order_status list page with a success notification
*/	
	public function deleteOrderStatus($order_status_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "order_status WHERE order_status_id = '" . (int)$order_status_id . "'");
	
		$this->cache->delete('order_status');
	}
/*
FUNCTION NAME 		-	getOrderStatus
DESCRIPTION 		-	Queries the order_status details for the given order_status_id from the database.
INPUT PARAMETER 	-	order_status_id
OUTPUT PARAMETER 	- 	Returns the asked order_status details.
*/		
	public function getOrderStatus($order_status_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_status WHERE order_status_id = '" . (int)$order_status_id . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCountries
DESCRIPTION 		-	Queries all the order_status details from the database.
INPUT PARAMETER 	-	data array containing filter values if any.
OUTPUT PARAMETER 	- 	Returns all the order_status details queried.
*/			
	public function getOrderStatuses($data = array()) {
      	if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "order_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'";
			
			$sql .= " ORDER BY name";	
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$order_status_data = $this->cache->get('order_status.' . (int)$this->config->get('config_language_id'));
		
			if (!$order_status_data) {
				$query = $this->db->query("SELECT order_status_id, name FROM " . DB_PREFIX . "order_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY name");
	
				$order_status_data = $query->rows;
			
				$this->cache->set('order_status.' . (int)$this->config->get('config_language_id'), $order_status_data);
			}	
	
			return $order_status_data;				
		}
	}
/*
FUNCTION NAME 		-	getOrderStatusDescriptions
DESCRIPTION 		-	Queries to get description for the given order_status_id
INPUT PARAMETER 	-	order_status_id
OUTPUT PARAMETER 	- 	returns a row with the description.
*/	
	public function getOrderStatusDescriptions($order_status_id) {
		$order_status_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_status WHERE order_status_id = '" . (int)$order_status_id . "'");
		
		foreach ($query->rows as $result) {
			$order_status_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $order_status_data;
	}
/*
FUNCTION NAME 		-	getTotalOrderStatuses
DESCRIPTION 		-	Queries to get the total number of order_statuses in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the order_status table.
*/	
	public function getTotalOrderStatuses() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order_status WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row['total'];
	}	
}
?>