<?php
/*
@File currency.php(MODEL)
LOCALISATION:	 CURRENCY PAGE
    This class queries,adds and updates the currency details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationCurrency extends Model {
/*
FUNCTION NAME 		-	addCurrency
DESCRIPTION 		-	Adds new currency detail to the database.
INPUT PARAMETER 	-	data array containing the currency description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for currency and returns to 
						the currency list page with a success notification
*/	
	public function addCurrency($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "currency SET title = '" . $this->db->escape($data['title']) . "', code = '" . $this->db->escape($data['code']) . "', symbol_left = '" . $this->db->escape($data['symbol_left']) . "', symbol_right = '" . $this->db->escape($data['symbol_right']) . "', decimal_place = '" . $this->db->escape($data['decimal_place']) . "', value = '" . $this->db->escape($data['value']) . "', status = '" . (int)$data['status'] . "', date_modified = NOW()");

		if ($this->config->get('config_currency_auto')) {
			$this->updateCurrencies(true);
		}

		$this->cache->delete('currency');
	}
/*
FUNCTION NAME 		-	editCurrency
DESCRIPTION 		-	Updates the currency detail given for the given currency_id.
INPUT PARAMETER 	-	currency_id, data array containing the currency description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for currency and returns to 
						the currency list page with a success notification
*/	
	public function editCurrency($currency_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "currency SET title = '" . $this->db->escape($data['title']) . "', code = '" . $this->db->escape($data['code']) . "', symbol_left = '" . $this->db->escape($data['symbol_left']) . "', symbol_right = '" . $this->db->escape($data['symbol_right']) . "', decimal_place = '" . $this->db->escape($data['decimal_place']) . "', value = '" . $this->db->escape($data['value']) . "', status = '" . (int)$data['status'] . "', date_modified = NOW() WHERE currency_id = '" . (int)$currency_id . "'");

		$this->cache->delete('currency');
	}
/*
FUNCTION NAME 		-	deleteCurrency
DESCRIPTION 		-	Deletes the currency detail for the given currency_id.
INPUT PARAMETER 	-	currency_id
OUTPUT PARAMETER 	- 	Deletes the given currency details and the cache for currency and returns to 
						the currency list page with a success notification
*/	
	public function deleteCurrency($currency_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "currency WHERE currency_id = '" . (int)$currency_id . "'");
	
		$this->cache->delete('currency');
	}
/*
FUNCTION NAME 		-	getCurrency
DESCRIPTION 		-	Queries the currency details for the given currency_id from the database.
INPUT PARAMETER 	-	currency_id
OUTPUT PARAMETER 	- 	Returns the asked currency details.
*/
	public function getCurrency($currency_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "currency WHERE currency_id = '" . (int)$currency_id . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCurrencyByCode
DESCRIPTION 		-	Queries the currency details for the given code from the database.
INPUT PARAMETER 	-	currency variable containing currency code.
OUTPUT PARAMETER 	- 	Returns the row queried
*/		
	public function getCurrencyByCode($currency) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "currency WHERE code = '" . $this->db->escape($currency) . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCurrencies
DESCRIPTION 		-	Queries all the currency details from the database.
INPUT PARAMETER 	-	data array containing the filter options if any 
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/		
	public function getCurrencies($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "currency";

			$sort_data = array(
				'title',
				'code',
				'value',
				'date_modified'
			);	
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY title";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
			
			$query = $this->db->query($sql);
	
			return $query->rows;
		} else {
			$currency_data = $this->cache->get('currency');

			if (!$currency_data) {
				$currency_data = array();
				
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "currency ORDER BY title ASC");
	
				foreach ($query->rows as $result) {
      				$currency_data[$result['code']] = array(
        				'currency_id'   => $result['currency_id'],
        				'title'         => $result['title'],
        				'code'          => $result['code'],
						'symbol_left'   => $result['symbol_left'],
						'symbol_right'  => $result['symbol_right'],
						'decimal_place' => $result['decimal_place'],
						'value'         => $result['value'],
						'status'        => $result['status'],
						'date_modified' => $result['date_modified']
      				);
    			}	
			
				$this->cache->set('currency', $currency_data);
			}
			
			return $currency_data;			
		}
	}	
/*
FUNCTION NAME 		-	updateCurrencies
DESCRIPTION 		-	update the currency details for the selected currency.
INPUT PARAMETER 	-	force variable.
OUTPUT PARAMETER 	- 	updates the database with new values.
*/
	public function updateCurrencies($force = false) {
		if (extension_loaded('curl')) {
			$data = array();
			
			if ($force) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "currency WHERE code != '" . $this->db->escape($this->config->get('config_currency')) . "'");
			} else {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "currency WHERE code != '" . $this->db->escape($this->config->get('config_currency')) . "' AND date_modified < '" .  $this->db->escape(date('Y-m-d H:i:s', strtotime('-1 day'))) . "'");
			}
			
			foreach ($query->rows as $result) {
				$data[] = $this->config->get('config_currency') . $result['code'] . '=X';
			}	
			
			$curl = curl_init();
			
			curl_setopt($curl, CURLOPT_URL, 'http://download.finance.yahoo.com/d/quotes.csv?s=' . implode(',', $data) . '&f=sl1&e=.csv');
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			
			$content = curl_exec($curl);
			
			curl_close($curl);
			
			$lines = explode("\n", trim($content));
				
			foreach ($lines as $line) {
				$currency = utf8_substr($line, 4, 3);
				$value = utf8_substr($line, 11, 6);
				
				if ((float)$value) {
					$this->db->query("UPDATE " . DB_PREFIX . "currency SET value = '" . (float)$value . "', date_modified = '" .  $this->db->escape(date('Y-m-d H:i:s')) . "' WHERE code = '" . $this->db->escape($currency) . "'");
				}
			}
			
			$this->db->query("UPDATE " . DB_PREFIX . "currency SET value = '1.00000', date_modified = '" .  $this->db->escape(date('Y-m-d H:i:s')) . "' WHERE code = '" . $this->db->escape($this->config->get('config_currency')) . "'");
			
			$this->cache->delete('currency');
		}
	}
/*
FUNCTION NAME 		-	getTotalCurrencies
DESCRIPTION 		-	Queries to get the total number of currencies in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the currency table.
*/	
	public function getTotalCurrencies() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "currency");
		
		return $query->row['total'];
	}
}
?>