<?php
/*
@File country.php(MODEL)
LOCALISATION:	 COUNTRY PAGE
    This class queries and adds the country details to the database for the store.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelLocalisationCountry extends Model {
/*
FUNCTION NAME 		-	addCountry
DESCRIPTION 		-	Adds new country detail to the database.
INPUT PARAMETER 	-	data array containing the country description.
OUTPUT PARAMETER 	- 	Adds to the database, deletes the cache for country and returns to 
						the country list page with a success notification
*/	
	public function addCountry($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "country SET name = '" . $this->db->escape($data['name']) . "', iso_code_2 = '" . $this->db->escape($data['iso_code_2']) . "', iso_code_3 = '" . $this->db->escape($data['iso_code_3']) . "', address_format = '" . $this->db->escape($data['address_format']) . "', postcode_required = '" . (int)$data['postcode_required'] . "', status = '" . (int)$data['status'] . "'");
	
		$this->cache->delete('country');
	}
/*
FUNCTION NAME 		-	editCountry
DESCRIPTION 		-	Updates the country detail given for the given country_id.
INPUT PARAMETER 	-	country_id, data array containing the country description.
OUTPUT PARAMETER 	- 	Updates the database, deletes the cache for country and returns to 
						the country list page with a success notification
*/	
	public function editCountry($country_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "country SET name = '" . $this->db->escape($data['name']) . "', iso_code_2 = '" . $this->db->escape($data['iso_code_2']) . "', iso_code_3 = '" . $this->db->escape($data['iso_code_3']) . "', address_format = '" . $this->db->escape($data['address_format']) . "', postcode_required = '" . (int)$data['postcode_required'] . "', status = '" . (int)$data['status'] . "' WHERE country_id = '" . (int)$country_id . "'");
	
		$this->cache->delete('country');
	}
/*
FUNCTION NAME 		-	deleteCountry
DESCRIPTION 		-	Deletes the country detail for the given country_id.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	Deletes the given country details and the cache for country and returns to 
						the country list page with a success notification
*/	
	public function deleteCountry($country_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "country WHERE country_id = '" . (int)$country_id . "'");
		
		$this->cache->delete('country');
	}
/*
FUNCTION NAME 		-	getCountry
DESCRIPTION 		-	Queries the country details for the given country_id from the database.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	Returns the asked country details.
*/	
	public function getCountry($country_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "country WHERE country_id = '" . (int)$country_id . "'");
		
		return $query->row;
	}

/*
FUNCTION NAME 		-	getZone
DESCRIPTION 		-	Queries the zone details for the given zone_id from the database.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	Returns the asked country details.
*/	
	public function getZone($zone_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "zone WHERE zone_id = '" . (int)$zone_id . "'");
		
		return $query->row;
	}

/*
FUNCTION NAME 		-	getPostCode
DESCRIPTION 		-	Queries the postcode details for the given region_id from the database.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	Returns the asked regions details.
*/	
	public function getPostCode($region_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "region WHERE region_id = '" . (int)$region_id . "'");
		
		return $query->row;
	}	
/*
FUNCTION NAME 		-	getCountries
DESCRIPTION 		-	Queries all the country details  from the database.
INPUT PARAMETER 	-	data array containing filter values if any.
OUTPUT PARAMETER 	- 	Returns all the country details queried.
*/		
	public function getCountries($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "country";
			
			$sort_data = array(
				'name',
				'iso_code_2',
				'iso_code_3'
			);	
			
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY name";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}					

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}		
			
			$query = $this->db->query($sql);

			return $query->rows;
		} else {
			$country_data = $this->cache->get('country');
		
			if (!$country_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "country ORDER BY name ASC");
	
				$country_data = $query->rows;
			
				$this->cache->set('country', $country_data);
			}

			return $country_data;			
		}	
	}
/*
FUNCTION NAME 		-	getTotalCountries
DESCRIPTION 		-	Queries to get the total number of countries in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	returns a row with column total containing count for the country table.
*/	
	public function getTotalCountries() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "country");
		
		return $query->row['total'];
	}	
}
?>