<?php
/*
@File customer.php(MODEL)
SALE:	 CUSTOMER PAGE
    Manages the customer account by inserting, deleting and updating the customer informations. 
    It also retrieves the customer details if requiered.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelKmsCommands extends Model {

public function getUserDetails($data=array()) {
      	$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$data['filter_email'] . "'");
	
		return $query->rows;
	}


/*
FUNCTION NAME 		-	addCustomer
DESCRIPTION 		-	Adds new customer to the database.
INPUT PARAMETER 	-	data array containing the details of the customer.
OUTPUT PARAMETER 	- 	Inserts the customer details to the database and returns.
*/	
	public function addCustomer($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "customer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', STBNO='" . $this->db->escape($data['STBNO'])."',CASNO='" . $this->db->escape($data['CASNO'])."',email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', fax = '" . $this->db->escape($data['fax']) . "', newsletter = '" . (int)$data['newsletter'] . "', customer_group_id = '" . (int)$data['customer_group_id'] . "', salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "', status = '" . (int)$data['status'] . "', date_added = NOW()");
      	
      	$customer_id = $this->db->getLastId();
      	//-----------------------Added to sync the stb and cas no. -------
  		$this->db->query("INSERT INTO " . DB_PREFIX . "customer_stb_cas SET customer_id = '" . (int)$customer_id . "', current_stbno = '" . $this->db->escape($data['STBNO'])."', current_casno = '" . $this->db->escape($data['CASNO'])."'");
  		$this->db->query("UPDATE " . DB_PREFIX . "stb SET customer_id = '" . (int)$customer_id . "',is_avail='0' WHERE stb_no = '" . $data['STBNO'] . "'");
  		$this->db->query("UPDATE " . DB_PREFIX . "cas SET customer_id = '" . (int)$customer_id . "',is_avail='0' WHERE cas_id = '" . $data['CASNO'] . "'");
		//--------------------------------------------------------
      	if (isset($data['address'])) {		
      		foreach ($data['address'] as $address) {	
      			$this->db->query("INSERT INTO " . DB_PREFIX . "address SET customer_id = '" . (int)$customer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', company_id = '" . $this->db->escape($address['company_id']) . "', tax_id = '" . $this->db->escape($address['tax_id']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
				
				if (isset($address['default'])) {
					$address_id = $this->db->getLastId();
					
					$this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . $address_id . "' WHERE customer_id = '" . (int)$customer_id . "'");
				}
			}
		}
		return $this->db->escape($data['STBNO']);
	}
/*
FUNCTION NAME 		-	editCustomer
DESCRIPTION 		-	Updates the customer information based on the new values given in the array.
INPUT PARAMETER 	-	data array containing the information of the customer
OUTPUT PARAMETER 	- 	void
*/	
	public function editCustomer($customer_id, $data) {

		$q = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
	
		$old_stb =$q->row['STBNO'];
		$old_cas = $q->row['CASNO'];
		$this->db->query("UPDATE " . DB_PREFIX . "stb SET customer_id = '0',is_avail='1' WHERE stb_no = '" . $old_stb . "'");
  		$this->db->query("UPDATE " . DB_PREFIX . "cas SET customer_id = '0',is_avail='1' WHERE cas_id = '" . $old_cas. "'");

		//-----------------------Added to sync the stb and cas no. -------
  		$this->db->query("UPDATE " . DB_PREFIX . "customer_stb_cas SET current_stbno = '" . $this->db->escape($data['STBNO'])."', current_casno = '" . $this->db->escape($data['CASNO'])."', status ='Pending' WHERE customer_id = '" . (int)$customer_id . "'");
  		$this->db->query("UPDATE " . DB_PREFIX . "stb SET customer_id = '" . (int)$customer_id . "',is_avail='0' WHERE stb_no = '" . $data['STBNO'] . "'");
  		$this->db->query("UPDATE " . DB_PREFIX . "cas SET customer_id = '" . (int)$customer_id . "',is_avail='0' WHERE cas_id = '" . $data['CASNO'] . "'");
		//--------------------------------------------------------


	  	 $errd = $this->db->query("UPDATE " . DB_PREFIX . "customer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', STBNO='" . $this->db->escape($data['STBNO'])."',CASNO='" . $this->db->escape($data['CASNO'])."',email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', fax = '" . $this->db->escape($data['fax']) . "', newsletter = '" . (int)$data['newsletter'] . "', customer_group_id = '" . (int)$data['customer_group_id'] . "', status = '" . (int)$data['status'] . "' WHERE customer_id = '" . (int)$customer_id . "'");
	     // echo "in model".$errd;

	     if(!strcmp($errd,'1062')){
	     	return $errd;
	     }
      	if ($data['password']) {
        	$this->db->query("UPDATE " . DB_PREFIX . "customer SET salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "' WHERE customer_id = '" . (int)$customer_id . "'");
      	}
      	
      	$this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int)$customer_id . "'");
      	
      	if (isset($data['address'])) {
      		foreach ($data['address'] as $address) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "address SET address_id = '" . (int)$address['address_id'] . "', customer_id = '" . (int)$customer_id . "', firstname = '" . $this->db->escape($address['firstname']) . "', lastname = '" . $this->db->escape($address['lastname']) . "', company = '" . $this->db->escape($address['company']) . "', company_id = '" . $this->db->escape($address['company_id']) . "', tax_id = '" . $this->db->escape($address['tax_id']) . "', address_1 = '" . $this->db->escape($address['address_1']) . "', address_2 = '" . $this->db->escape($address['address_2']) . "', city = '" . $this->db->escape($address['city']) . "', postcode = '" . $this->db->escape($address['postcode']) . "', country_id = '" . (int)$address['country_id'] . "', zone_id = '" . (int)$address['zone_id'] . "'");
					
				if (isset($address['default'])) {
					$address_id = $this->db->getLastId();
						
					$this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int)$address_id . "' WHERE customer_id = '" . (int)$customer_id . "'");
				}
			}
		}
	}
/*
FUNCTION NAME 		-	editCustomer
DESCRIPTION 		-	Updates the token for the given customer_id
INPUT PARAMETER 	-	customer_id, token
OUTPUT PARAMETER 	- 	Returns after updation
*/	
	public function editToken($customer_id, $token) {
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET token = '" . $this->db->escape($token) . "' WHERE customer_id = '" . (int)$customer_id . "'");
	}
/*
FUNCTION NAME 		-	deleteCustomer
DESCRIPTION 		-	Deletes the customer for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns after deleting the customer
*/		
	public function deleteCustomer($customer_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_ip WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int)$customer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "sms_kms_map WHERE user_id = '" . (int)$customer_id . "'");
	}

	public function CheckBeforedeleteCustomer($customer_id){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
		if($query->row['STBNO']==0|| $query->row['STBNO']==0)
			return 0;
		else
			return 1;
	}
/*
FUNCTION NAME 		-	getCustomer
DESCRIPTION 		-	Retrieves the customer details for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
	public function getCustomer($customer_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'");
	
		return $query->row;
	}
	public function getCustomerIdBySTB($STBNO) {
		$query = $this->db->query("SELECT customer_id FROM `" . DB_PREFIX . "customer` WHERE STBNO = '" .$STBNO . "'");
	
		return $query->row;
	}

	public function addApiResponceId($apiuser_id,$user_id)
	{
	 	$this->db->query("INSERT INTO " . DB_PREFIX . "sms_kms_map SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");

	}
	 public function getCustomerNameById($customer_id){
	 	$query = $this->db->query("SELECT username FROM `" . DB_PREFIX . "customer` WHERE customer_id = '" . (int)$customer_id. "'");
	
	 	return $query->row;

	 }
	public function getApiResponceId($customer_id)
	{
	 	// $this->db->query("INSERT INTO " . DB_PREFIX . "user_api_response SET user_id = '" . (int)$user_id . "', api_user_id = '" . (int)$apiuser_id . "'");
	 	$query = $this->db->query("SELECT api_user_id FROM `" . DB_PREFIX . "sms_kms_map` WHERE user_id = '" . (int)$customer_id . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCutomerBySTBNO
DESCRIPTION 		-	Retrieves the customer details for the given STBNO
INPUT PARAMETER 	-	STBNO
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
    public function getCustomerBySTBNO($STBNO) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE STBNO = '" . $STBNO . "'");
	
		return $query->row;
	}

	public function getSTBExist($STBNO){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb WHERE stb_no = '" . $STBNO . "'");
		if($query->num_rows){
			return 1;
		}else{
			return 0;
		}
	}

/*
FUNCTION NAME 		-	getCutomerByCASNO
DESCRIPTION 		-	Retrieves the customer details for the given CASNO
INPUT PARAMETER 	-	CASNO
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/		
	public function getCustomerByCASNO($CASNO) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE CASNO = '" . $CASNO . "'");
	
		return $query->row;
	}

	public function getCASExist($CASNO){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cas WHERE cas_id = '" . $CASNO . "'");
		if($query->num_rows){
			return 1;
		}else{
			return 0;
		}
	}
/*
FUNCTION NAME 		-	getCutomerByEmail
DESCRIPTION 		-	Retrieves the customer details for the given email id
INPUT PARAMETER 	-	email id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
	public function getCustomerByEmail($email) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");
	
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Retrieves all the customer details from the database
INPUT PARAMETER 	-	data array conatining filter options if any.
OUTPUT PARAMETER 	- 	Returns all th rows retrieved.
*/				
	public function getCustomers($data = array()) {
		$sql = "SELECT *, CONCAT(c.firstname, ' ', c.lastname) AS name, cgd.name AS customer_group FROM " . DB_PREFIX . "customer c LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		$implode = array();
		
		if (!empty($data['filter_name'])) {
			$implode[] = "CONCAT(c.firstname, ' ', c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "c.email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
		}

		if (isset($data['filter_newsletter']) && !is_null($data['filter_newsletter'])) {
			$implode[] = "c.newsletter = '" . (int)$data['filter_newsletter'] . "'";
		}	
				
		if (!empty($data['filter_customer_group_id'])) {
			$implode[] = "c.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
		}	
			
		if (!empty($data['filter_ip'])) {
			$implode[] = "c.customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer_ip WHERE ip = '" . $this->db->escape($data['filter_ip']) . "')";
		}	
				
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$implode[] = "c.status = '" . (int)$data['filter_status'] . "'";
		}	
		
		if (isset($data['filter_approved']) && !is_null($data['filter_approved'])) {
			$implode[] = "c.approved = '" . (int)$data['filter_approved'] . "'";
		}	
				
		if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(c.date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if ($implode) {
			$sql .= " AND " . implode(" AND ", $implode);
		}
		
		$sort_data = array(
			'name',
			'c.email',
			'customer_group',
			'c.status',
			'c.approved',
			'c.ip',
			'c.date_added'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);
		
		return $query->rows;	
	}
/*
FUNCTION NAME 		-	approve
DESCRIPTION 		-	Approves the customer's account and enables the customer to login to
						his account.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Updates customer account, sends mail to his registered account 
						and returns with a notification message.
*/		
	public function approve($customer_id) {
		$customer_info = $this->getCustomer($customer_id);

		if ($customer_info) {
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET approved = '1' WHERE customer_id = '" . (int)$customer_id . "'");

			$this->language->load('mail/customer');
			
			$this->load->model('setting/store');
						
			$store_info = $this->model_setting_store->getStore($customer_info['store_id']);
			
			if ($store_info) {
				$store_name = $store_info['name'];
				$store_url = $store_info['url'] . 'index.php?route=account/login';
			} else {
				$store_name = $this->config->get('config_name');
				$store_url = HTTP_CATALOG . 'index.php?route=account/login';
			}
	
			$message  = sprintf($this->language->get('text_approve_welcome'), $store_name) . "\n\n";
			$message .= $this->language->get('text_approve_login') . "\n";
			$message .= $store_url . "\n\n";
			$message .= $this->language->get('text_approve_services') . "\n\n";
			$message .= $this->language->get('text_approve_thanks') . "\n";
			$message .= $store_name;
	
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');							
			$mail->setTo($customer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(html_entity_decode(sprintf($this->language->get('text_approve_subject'), $store_name), ENT_QUOTES, 'UTF-8'));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();
		}		
	}
/*
FUNCTION NAME 		-	getAddress
DESCRIPTION 		-	Retrieves the address detail for the given adress_id
INPUT PARAMETER 	-	address_id
OUTPUT PARAMETER 	- 	Returns an array containing the address details
*/			
	public function getAddress($address_id) {
		$address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE address_id = '" . (int)$address_id . "'");

		if ($address_query->num_rows) {
			$country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int)$address_query->row['country_id'] . "'");
			
			if ($country_query->num_rows) {
				$country = $country_query->row['name'];
				$iso_code_2 = $country_query->row['iso_code_2'];
				$iso_code_3 = $country_query->row['iso_code_3'];
				$address_format = $country_query->row['address_format'];
			} else {
				$country = '';
				$iso_code_2 = '';
				$iso_code_3 = '';	
				$address_format = '';
			}
			
			$zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int)$address_query->row['zone_id'] . "'");
			
			if ($zone_query->num_rows) {
				$zone = $zone_query->row['name'];
				$zone_code = $zone_query->row['code'];
			} else {
				$zone = '';
				$zone_code = '';
			}		
		
			return array(
				'address_id'     => $address_query->row['address_id'],
				'customer_id'    => $address_query->row['customer_id'],
				'firstname'      => $address_query->row['firstname'],
				'lastname'       => $address_query->row['lastname'],
				'company'        => $address_query->row['company'],
				'company_id'     => $address_query->row['company_id'],
				'tax_id'         => $address_query->row['tax_id'],
				'address_1'      => $address_query->row['address_1'],
				'address_2'      => $address_query->row['address_2'],
				'postcode'       => $address_query->row['postcode'],
				'city'           => $address_query->row['city'],
				'zone_id'        => $address_query->row['zone_id'],
				'zone'           => $zone,
				'zone_code'      => $zone_code,
				'country_id'     => $address_query->row['country_id'],
				'country'        => $country,	
				'iso_code_2'     => $iso_code_2,
				'iso_code_3'     => $iso_code_3,
				'address_format' => $address_format
			);
		}
	}
/*
FUNCTION NAME 		-	getAddresses
DESCRIPTION 		-	Retrieves all the address detail for the given customer_id from the database
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns an array contaning the address infomation
*/			
	public function getAddresses($customer_id) {
		$address_data = array();
		
		$query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int)$customer_id . "'");
	
		foreach ($query->rows as $result) {
			$address_info = $this->getAddress($result['address_id']);
		
			if ($address_info) {
				$address_data[$result['address_id']] = $address_info;
			}
		}		
		
		return $address_data;
	}	
/*
FUNCTION NAME 		-	getTotalCustomers
DESCRIPTION 		-	Retrieves the total count for all the customers
						from the database.
INPUT PARAMETER 	-	data array containing filter options if any
OUTPUT PARAMETER 	- 	Returns the total count.
*/				
	public function getTotalCustomers($data = array()) {
      	$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer";
		
		$implode = array();
		
		if (!empty($data['filter_name'])) {
			$implode[] = "CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
		}
		
		if (isset($data['filter_newsletter']) && !is_null($data['filter_newsletter'])) {
			$implode[] = "newsletter = '" . (int)$data['filter_newsletter'] . "'";
		}
				
		if (!empty($data['filter_customer_group_id'])) {
			$implode[] = "customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
		}	
		
		if (!empty($data['filter_ip'])) {
			$implode[] = "customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer_ip WHERE ip = '" . $this->db->escape($data['filter_ip']) . "')";
		}	
						
		if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$implode[] = "status = '" . (int)$data['filter_status'] . "'";
		}			
		
		if (isset($data['filter_approved']) && !is_null($data['filter_approved'])) {
			$implode[] = "approved = '" . (int)$data['filter_approved'] . "'";
		}		
				
		if (!empty($data['filter_date_added'])) {
			$implode[] = "DATE(date_added) = DATE('" . $this->db->escape($data['filter_date_added']) . "')";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
				
		$query = $this->db->query($sql);
				
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalCustomrsAwaitingApproval
DESCRIPTION 		-	Retrieves the total count for all the customers awaiting for approval
						from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalCustomersAwaitingApproval() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE status = '0' OR approved = '0'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalOrderPending
DESCRIPTION 		-	Retrieves the total count for all the orders pending from the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalOrderPending() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "order WHERE order_status_id = '1'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalAddressesByCustomerId
DESCRIPTION 		-	Retrieves the total count for all the addresses for the given 
						customer_id from the database.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalAddressesByCustomerId($customer_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int)$customer_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalAddressesByCountryId
DESCRIPTION 		-	Retrieves the total count for all the addresses for the given 
						country_id from the database.
INPUT PARAMETER 	-	country_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalAddressesByCountryId($country_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "address WHERE country_id = '" . (int)$country_id . "'");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalAddressesByZoneId
DESCRIPTION 		-	Retrieves the total count for all the addresses for the given 
						zone_id from the database.
INPUT PARAMETER 	-	zone_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalAddressesByZoneId($zone_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "address WHERE zone_id = '" . (int)$zone_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalCustomersByCustomerGroupId
DESCRIPTION 		-	Retrieves the total count for all the customers for the given 
						customer_group_id from the database.
INPUT PARAMETER 	-	customer_group_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalCustomersByCustomerGroupId($customer_group_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '" . (int)$customer_group_id . "'");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	addHistory
DESCRIPTION 		-	Adds new customer history for the given customer_id to the database.
INPUT PARAMETER 	-	customer_id, comment
OUTPUT PARAMETER 	- 	Inserts the customer history to the database and returns.
*/
	public function addHistory($customer_id, $comment) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "customer_history SET customer_id = '" . (int)$customer_id . "', comment = '" . $this->db->escape(strip_tags($comment)) . "', date_added = NOW()");
	}	
/*
FUNCTION NAME 		-	getHistories
DESCRIPTION 		-	Retrieves all the customer history from the database for the given customer_id
INPUT PARAMETER 	-	customer_id, start, limit for retrieval in blocks
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/	
	public function getHistories($customer_id, $start = 0, $limit = 10) { 
		if ($start < 0) {
			$start = 0;
		}
		
		if ($limit < 1) {
			$limit = 10;
		}	
		
		$query = $this->db->query("SELECT comment, date_added FROM " . DB_PREFIX . "customer_history WHERE customer_id = '" . (int)$customer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalHistories
DESCRIPTION 		-	Retrieves the total count for all the customer_history for the given 
						customer_id from the database.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalHistories($customer_id) {
	  	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_history WHERE customer_id = '" . (int)$customer_id . "'");

		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	addTransaction
DESCRIPTION 		-	Adds new customer transaction for the given customer_id to the database.
INPUT PARAMETER 	-	customer_id, description, amount, order_id
OUTPUT PARAMETER 	- 	Inserts the customer transaction to the database and returns.
*/			
	public function addTransaction($customer_id, $description = '', $amount = '', $order_id = 0) {
		$customer_info = $this->getCustomer($customer_id);
		
		if ($customer_info) { 
			$this->db->query("INSERT INTO " . DB_PREFIX . "customer_transaction SET customer_id = '" . (int)$customer_id . "', order_id = '" . (int)$order_id . "', description = '" . $this->db->escape($description) . "', amount = '" . (float)$amount . "', date_added = NOW()");

			$this->language->load('mail/customer');
			
			if ($customer_info['store_id']) {
				$this->load->model('setting/store');
		
				$store_info = $this->model_setting_store->getStore($customer_info['store_id']);
				
				if ($store_info) {
					$store_name = $store_info['name'];
				} else {
					$store_name = $this->config->get('config_name');
				}	
			} else {
				$store_name = $this->config->get('config_name');
			}
						
			$message  = sprintf($this->language->get('text_transaction_received'), $this->currency->format($amount, $this->config->get('config_currency'))) . "\n\n";
			$message .= sprintf($this->language->get('text_transaction_total'), $this->currency->format($this->getTransactionTotal($customer_id)));
								
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');
			$mail->setTo($customer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(html_entity_decode(sprintf($this->language->get('text_transaction_subject'), $this->config->get('config_name')), ENT_QUOTES, 'UTF-8'));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();
		}
	}
/*
FUNCTION NAME 		-	deleteTransaction
DESCRIPTION 		-	Deletes the customer transaction for the given order_id
INPUT PARAMETER 	-	order_id
OUTPUT PARAMETER 	- 	Returns after deleting te transaction
*/	
	public function deleteTransaction($order_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_transaction WHERE order_id = '" . (int)$order_id . "'");
	}
/*
FUNCTION NAME 		-	getTransactions
DESCRIPTION 		-	Retrieves all the transactions for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/	
	public function getTransactions($customer_id, $start = 0, $limit = 10) {
		if ($start < 0) {
			$start = 0;
		}
		
		if ($limit < 1) {
			$limit = 10;
		}	
				
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int)$customer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalTransactions
DESCRIPTION 		-	Retrieves the total count for all the customer transactions for the given 
						customer_id from the database.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalTransactions($customer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total  FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int)$customer_id . "'");
	
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTransactionTotal
DESCRIPTION 		-	Retrieves the total amount for all the customer transaction for the given 
						customer_id from the database.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the total amount.
*/		
	public function getTransactionTotal($customer_id) {
		$query = $this->db->query("SELECT SUM(amount) AS total FROM " . DB_PREFIX . "customer_transaction WHERE customer_id = '" . (int)$customer_id . "'");
	
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalTransactionsByOrderId
DESCRIPTION 		-	Retrieves the total count for all the customers transaction for the given 
						order_id from the database.
INPUT PARAMETER 	-	order_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalTransactionsByOrderId($order_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_transaction WHERE order_id = '" . (int)$order_id . "'");
	
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	addReward
DESCRIPTION 		-	Adds new customer reward for the given customer_id to the database.
INPUT PARAMETER 	-	customer_id, description, points, order_id
OUTPUT PARAMETER 	- 	Inserts the customer reward points to the database and returns.
*/				
	public function addReward($customer_id, $description = '', $points = '', $order_id = 0) {
		$customer_info = $this->getCustomer($customer_id);
			
		if ($customer_info) { 
			$this->db->query("INSERT INTO " . DB_PREFIX . "customer_reward SET customer_id = '" . (int)$customer_id . "', order_id = '" . (int)$order_id . "', points = '" . (int)$points . "', description = '" . $this->db->escape($description) . "', date_added = NOW()");

			$this->language->load('mail/customer');
			
			if ($order_id) {
				$this->load->model('sale/order');
		
				$order_info = $this->model_sale_order->getOrder($order_id);
				
				if ($order_info) {
					$store_name = $order_info['store_name'];
				} else {
					$store_name = $this->config->get('config_name');
				}	
			} else {
				$store_name = $this->config->get('config_name');
			}		
				
			$message  = sprintf($this->language->get('text_reward_received'), $points) . "\n\n";
			$message .= sprintf($this->language->get('text_reward_total'), $this->getRewardTotal($customer_id));
				
			$mail = new Mail();
			$mail->protocol = $this->config->get('config_mail_protocol');
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->hostname = $this->config->get('config_smtp_host');
			$mail->username = $this->config->get('config_smtp_username');
			$mail->password = $this->config->get('config_smtp_password');
			$mail->port = $this->config->get('config_smtp_port');
			$mail->timeout = $this->config->get('config_smtp_timeout');
			$mail->setTo($customer_info['email']);
			$mail->setFrom($this->config->get('config_email'));
			$mail->setSender($store_name);
			$mail->setSubject(html_entity_decode(sprintf($this->language->get('text_reward_subject'), $store_name), ENT_QUOTES, 'UTF-8'));
			$mail->setText(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
			$mail->send();
		}
	}
/*
FUNCTION NAME 		-	deleteReward
DESCRIPTION 		-	Deletes the customer reward points for the given order_id
INPUT PARAMETER 	-	order_id
OUTPUT PARAMETER 	- 	Returns after deleting the reward
*/
	public function deleteReward($order_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "customer_reward WHERE order_id = '" . (int)$order_id . "'");
	}
/*
FUNCTION NAME 		-	getRewards
DESCRIPTION 		-	Retrieves all the customer rewards for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/	
	public function getRewards($customer_id, $start = 0, $limit = 10) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int)$customer_id . "' ORDER BY date_added DESC LIMIT " . (int)$start . "," . (int)$limit);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalRewards
DESCRIPTION 		-	Retrieves the total count for all the rewards for the given 
						customer_id from the database.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/
	public function getTotalRewards($customer_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int)$customer_id . "'");
	
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getRewardTotal
DESCRIPTION 		-	Retrieves the total count for all the customer rewards for the given 
						customer_id from the database.
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/		
	public function getRewardTotal($customer_id) {
		$query = $this->db->query("SELECT SUM(points) AS total FROM " . DB_PREFIX . "customer_reward WHERE customer_id = '" . (int)$customer_id . "'");
	
		return $query->row['total'];
	}		
/*
FUNCTION NAME 		-	getTotalCustomerRewardsByOrderId
DESCRIPTION 		-	Retrieves the total count for all the customer rewards for the given 
						order_id from the database.
INPUT PARAMETER 	-	order_id
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalCustomerRewardsByOrderId($order_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_reward WHERE order_id = '" . (int)$order_id . "'");
	
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getIpsByCustomerId
DESCRIPTION 		-	Retrieves all the customer ips for the given customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/	
	public function getIpsByCustomerId($customer_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_ip WHERE customer_id = '" . (int)$customer_id . "'");

		return $query->rows;
	}	
/*
FUNCTION NAME 		-	getTotalCustomersByIp
DESCRIPTION 		-	Retrieves the total count for all the customer_ip for the given 
						ip from the database.
INPUT PARAMETER 	-	ip
OUTPUT PARAMETER 	- 	Returns the total count.
*/	
	public function getTotalCustomersByIp($ip) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer_ip WHERE ip = '" . $this->db->escape($ip) . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	addBanIp
DESCRIPTION 		-	Inserts the ban ip details to the database.
INPUT PARAMETER 	-	ip address
OUTPUT PARAMETER 	- 	Returns after inserting the ban ip
*/	
	public function addBanIp($ip) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "customer_ban_ip` SET `ip` = '" . $this->db->escape($ip) . "'");
	}
/*
FUNCTION NAME 		-	removeBanIp
DESCRIPTION 		-	Deletes the customer ban ip from the database.
INPUT PARAMETER 	-	ip address
OUTPUT PARAMETER 	- 	Returns after deleting te ban ip
*/		
	public function removeBanIp($ip) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "customer_ban_ip` WHERE `ip` = '" . $this->db->escape($ip) . "'");
	}
/*
FUNCTION NAME 		-	getTotalBanIpsByIp
DESCRIPTION 		-	Retrieves the total count for all the customer ban ip for the given 
						ip from the database.
INPUT PARAMETER 	-	ip
OUTPUT PARAMETER 	- 	Returns the total count.
*/			
	public function getTotalBanIpsByIp($ip) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "customer_ban_ip` WHERE `ip` = '" . $this->db->escape($ip) . "'");
				 
		return $query->row['total'];
	}	
}
?>