<?php
/*
@File layout.php(MODEL)
DESIGN:	 LAYOUT PAGE
    Manages the layout 

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelDesignLayout extends Model {
/*
FUNCTION NAME 		-	addLayout
DESCRIPTION 		-	Adds new layout detail to the database.
INPUT PARAMETER 	-	new layout details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the layout list page with a success notification
*/		
	public function addLayout($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "layout SET name = '" . $this->db->escape($data['name']) . "'");
	
		$layout_id = $this->db->getLastId();
		
		if (isset($data['layout_route'])) {
			foreach ($data['layout_route'] as $layout_route) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "layout_route SET layout_id = '" . (int)$layout_id . "', store_id = '" . (int)$layout_route['store_id'] . "', route = '" . $this->db->escape($layout_route['route']) . "'");
			}	
		}
	}
/*
FUNCTION NAME 		-	editLayout
DESCRIPTION 		-	Updates layout details for the selected layout_id.
INPUT PARAMETER 	-	layout_id, new layout details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the layout list page with a success notification
*/	
	public function editLayout($layout_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "layout SET name = '" . $this->db->escape($data['name']) . "' WHERE layout_id = '" . (int)$layout_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "layout_route WHERE layout_id = '" . (int)$layout_id . "'");
		
		if (isset($data['layout_route'])) {
			foreach ($data['layout_route'] as $layout_route) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "layout_route SET layout_id = '" . (int)$layout_id . "', store_id = '" . (int)$layout_route['store_id'] . "', route = '" . $this->db->escape($layout_route['route']) . "'");
			}
		}
	}
/*
FUNCTION NAME 		-	deleteLayout
DESCRIPTION 		-	Deletes layout detail from the database for the selected layout_id.
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the layout list page with a success notification
*/	
	public function deleteLayout($layout_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "layout WHERE layout_id = '" . (int)$layout_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "layout_route WHERE layout_id = '" . (int)$layout_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "category_to_layout WHERE layout_id = '" . (int)$layout_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_layout WHERE layout_id = '" . (int)$layout_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "information_to_layout WHERE layout_id = '" . (int)$layout_id . "'");		
	}
/*
FUNCTION NAME 		-	getLayout
DESCRIPTION 		-	Retrieves layout details from the database based on the given layout_id.
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the layout.
*/	
	public function getLayout($layout_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "layout WHERE layout_id = '" . (int)$layout_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getLayouts
DESCRIPTION 		-	Retrieves all the layouts from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing layout details.
*/			 
	public function getLayouts($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "layout";
		
		$sort_data = array('name');	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}		
		
		$query = $this->db->query($sql);

		return $query->rows;
	}
/*
FUNCTION NAME 		-	getLayoutRoutes
DESCRIPTION 		-	Retrieves the row having the route detail for the layout_id
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Returns the rows retrieved
*/		
	public function getLayoutRoutes($layout_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "layout_route WHERE layout_id = '" . (int)$layout_id . "'");
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalLayouts
DESCRIPTION 		-	Retrieves the count for the total number of layouts.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count for layouts.
*/		
	public function getTotalLayouts() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "layout");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	checkDuplicateLayout
DESCRIPTION 		-	Retrieves the count for the total number of layouts.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count for layouts.
*/		
	public function checkDuplicateLayout($layout ,$layout_id) {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "layout WHERE name = '" .$layout . "' AND layout_id <> '".$layout_id."'");
		
		return $query->row['total'];
	}
		
}
?>