<?php
/*
@File product_subscription.php(MODEL)
DESIGN:	 ProductSubscription PAGE
    This class retrieves the product_subscription staus detials.

@Author Ravi Ranjan
@date 19 Jan. 2016
*/
class ModelCommandsProductSubscription extends Model {

	/*
	FUNCTION NAME 		-	getActivationTransactions
	DESCRIPTION 		-	Retrieves all transation details.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
	*/		
	public function getSubscribeProducts($data) {
		$sql = "SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,cas.stbno as STBNO FROM oc_cas_op_transactions cas 
inner join oc_customer c ON cas.user_id=c.customer_id inner join
(select max(id) as mId from oc_cas_op_transactions where cmd_id in (10,11) group by user_id,product_id,cmd_id)x 
on cas.id = x.mId ";
		/*$test = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (10) GROUP BY cas.user_id,cas.product_id");
		$id_list1 = "";
		foreach ($test->rows as $key ) {
			$id_list1 = $id_list1.",".$key['id'];
		}
		$id_list1 = trim($id_list1,",");
		$test1 = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (11) GROUP BY cas.user_id,cas.product_id");
		$id_list2 = "";
		foreach ($test1->rows as $key ) {
			$id_list2 = $id_list2.",".$key['id'];
		}
		$id_list2 = trim($id_list2,",");
		$id_list = $id_list1.",".$id_list2;
		$id_list = trim($id_list,",");

		$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,cas.stbno as STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) where";*/
		$implode = array();
		if($this->session->data['user_group_id']!=1)
      	{
      		$implode[] =" c.operator_id ='" . $this->session->data['user_id'] . "' ";
      	}
		if(!empty($data['filter_value']))
		{
			$implode[] = "  c.STBNO like '%".$this->db->escape($data['filter_value'])."%'";
		}
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
		if (isset($data['start']) || isset($data['limit'])) {
		
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= "  ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
		return $query->rows;
	}
	/*
	FUNCTION NAME 		-	getTotalStbActivations
	DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
	*/		
	public function getTotalProductSubscription($data) {
		$sql = "SELECT count(*) as total FROM oc_cas_op_transactions cas 
inner join oc_customer c ON cas.user_id=c.customer_id inner join
(select max(id) as mId from oc_cas_op_transactions where cmd_id in (10,11) group by user_id,product_id,cmd_id)x 
on cas.id = x.mId ";
		/*$test = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (10) GROUP BY cas.user_id,cas.product_id");
		$id_list1 = "";
		foreach ($test->rows as $key ) {
			$id_list1 = $id_list1.",".$key['id'];
		}
		$id_list1 = trim($id_list1,",");
		$test1 = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (11) GROUP BY cas.user_id,cas.product_id");
		$id_list2 = "";
		foreach ($test1->rows as $key ) {
			$id_list2 = $id_list2.",".$key['id'];
		}
		$id_list2 = trim($id_list2,",");

		$id_list = $id_list1.",".$id_list2;
		$id_list = trim($id_list,",");
		if(strlen($id_list)==0){
			$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) where (cmd_id=10 OR cmd_id=11)";
		}else{
			$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) where (cmd_id=10 OR cmd_id=11) AND cas.id IN (".$id_list.")";
		}*/
		$implode = array();
		if($this->session->data['user_group_id']!=1)
      	{
      		$implode[] =" c.operator_id ='" . $this->session->data['user_id'] . "'";
      	}
		if(!empty($data['filter_value']))
		{
			$implode[]= " c.STBNO like '%".$this->db->escape($data['filter_value'])."%'";
		}
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
	   	$query = $this->db->query($sql);
		return $query->row['total'];
	}

	/*
	FUNCTION NAME 		-	getTotalStbActivations
	DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
	INPUT PARAMETER 	-	void
	OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
	*/		
	public function getProductsName($id) {
		$query = $this->db->query("SELECT name FROM " . DB_PREFIX . "product_description WHERE product_id='".$id."'");
		return $query->row;
	}

		/*
		FUNCTION NAME 		-	getSTBs
		DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
		*/		
		public function getSTBs($data=array()) {
		$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
		if(!empty($data['filter_no'])){
			$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
		/*
		FUNCTION NAME 		-	addToCasOpTransanction
		DESCRIPTION 		-	Queries to add the response data of api in the database.
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	void.
		*/
		public function addToCasOpTransanction($target,$user_id,$cmd_id,$tx_id,$ack_is='-1',$nack_is='-1',$payload,$product_id,$end_time,$order_id=0,$operator_id,$stbno)
		{
			if($end_time==NULL){
				$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."',stbno='".$stbno."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."	',nack_type=-1,initiated_by='Admin',payload='".$payload."',product_id='".$product_id."',target_level='".$target."',order_id='".$order_id."',operator_id='".$operator_id."'");
			}else{
				$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."',stbno='".$stbno."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',product_id='".$product_id."',exp_date='".$end_time."',target_level='".$target."',order_id='".$order_id."',operator_id='".$operator_id."'");
			}
		}


		/*
		FUNCTION NAME 		-	getTransactionDetails
		DESCRIPTION 		-	Retrieves transaction details.
		INPUT PARAMETER 	-	$id
		OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
		*/	
		public function getTransactionDetails($id)
		{
			$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c left join ".DB_PREFIX."sms_kms_map k on c.user_id=k.user_id WHERE c.id='".$id."'");
			return $query->row;
		}

		/*
		FUNCTION NAME 		-	getApiResponceId
		DESCRIPTION 		-	Retrieves Kms id.
		INPUT PARAMETER 	-	$id
		OUTPUT PARAMETER 	- 	Returns kms_stb_id.
		*/

			public function getApiResponceId($sms_stb_no)
			{
			 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
				return $query->row;
			}	
			public function getKmsProductId($sms_product_id)
			{
			 	$query = $this->db->query("SELECT api_product_id FROM `" . DB_PREFIX . "sms_kms_product` WHERE product_id = '" . (int)$sms_product_id . "'");
				return $query->row['api_product_id'];
			}	

			/*
			FUNCTION NAME 		-	isSTBPaired
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns rows.
			*/

			public function isSTBPaired($stb_no)
			{
			 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
				return ($query->row['customer_id'] > 0);
			}	

			/*
			FUNCTION NAME 		-	getCustomerId
			DESCRIPTION 		-	.
			INPUT PARAMETER 	-	stb_no
			OUTPUT PARAMETER 	- 	Returns Customer Id.
			*/
				public function getCustomerId($stb_no)
				{
				 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
					return $query->row['customer_id'];
				}

			/*
		FUNCTION NAME 		-	getEventDetails
		DESCRIPTION 		-	.
		INPUT PARAMETER 	-	event_id
		OUTPUT PARAMETER 	- 	Returns Number of column.
		*/
		public function getChannelExist($channel_id){
		 	$query = $this->db->query("SELECT * FROM ".DB_PREFIX."product WHERE `product_id`='".$channel_id."'");
			return $query->num_rows;
		}

		public function getStbno($customer_id){
	 		$query = $this->db->query("SELECT `STBNO` FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
			return $query->row['STBNO'];
		}
		public function updateExpiryFlag($product_id,$customer_id){
			$query = $this->db->query("UPDATE " . DB_PREFIX . "subscription SET  is_cancel=1 WHERE product_id = '" . (int)$product_id. "' AND customer_id = '" . (int)$customer_id. "'");
		}
	
	public function canResend($id){
		
	 // 	$query = $this->db->query("SELECT `user_id`,`product_id` FROM ".DB_PREFIX."cas_op_transactions WHERE cmd_id = 10 AND `id`='".$id."'");
	 // 	$status = $this->db->query("SELECT MAX(id) as id,exp_date FROM ".DB_PREFIX."cas_op_transactions WHERE `user_id`='".$query->row['user_id']."' AND `product_id`='".$query->row['product_id']."'");
	 // 	$cmd_status = $this->db->query("SELECT cmd_id FROM ".DB_PREFIX."cas_op_transactions WHERE `id`='".$status->row['id']."'");
	 	
	 // 	$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
	 	
		// $date = DateTime::createFromFormat('Y-m-d H:i:s', $status->row['exp_date']);
	
	 // 	$diff=date_diff($date,$now_datetime);
	 	
	 // 	if($diff->format("%R%a")>0 || $cmd_status->row['cmd_id']==11){
	 // 		return false;
	 // 	}else{
	 // 		return true;
	 // 	}
		// return true;

		$query = $this->db->query("SELECT exp_date FROM ".DB_PREFIX."cas_op_transactions WHERE `id`='".$id."'");
		$exp_date = $query->row['exp_date'];
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('Y-m-d H:i:s');

		if($exp_date > $current_date){
			return 1;
		}
		else {
			return 0;
		}
	}

	// public function canDeactive($id){
	// 	$query = $this->db->query("SELECT max(id) as id,cmd_id FROM ".DB_PREFIX."cas_op_transactions WHERE `id` > '".$id."' and cmd_id IN (10,11) group by cmd_id");
	// 	// var_dump($query);exit();
	// 	if($query->num_rows==2){
	// 		$checking = array();
	// 		foreach ($query->rows as $key ) {
	// 			$checking[$key['cmd_id']]=$key['id'];
	// 		}
	// 		if($checking[10]<$checking[11])
	// 			return true;
	// 		else
	// 			return false; 
	// 	}else{ 
	// 		$query = $this->db->query("SELECT exp_date FROM ".DB_PREFIX."cas_op_transactions WHERE `id` = '".$id."' ");
	// 		$exp_date = $query->row['exp_date'];
	// 		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
	// 		$current_date = $currDate->format('Y-m-d H:i:s');

	// 		if($query->num_rows==1){
	// 			if($exp_date < $current_date)
	// 				return true;
	// 			else 
	// 				return false;	
	// 		}else{				
	// 			if($exp_date > $current_date)
	// 				return true;
	// 			else 
	// 				return false;
	// 		}
	// 	}

	// }

	public function canDeactive($id,$user_id,$product_id){
			
		// $query = $this->db->query("SELECT count(*) AS total FROM ".DB_PREFIX."subscription s LEFT JOIN ".DB_PREFIX."cas_op_transactions cas ON (s.customer_id = cas.user_id) WHERE cas.id='".$id."' AND s.is_cancel=0 AND s.expire_date<NOW() AND cas.user_id='".$user_id."' AND cas.product_id='".$product_id."'");
		// var_dump("SELECT count(*) AS total FROM ".DB_PREFIX."subscription s LEFT JOIN ".DB_PREFIX."cas_op_transactions cas ON (s.customer_id = cas.user_id) WHERE cas.id='".$id."'  AND cas.user_id='".$user_id."' AND cas.product_id='".$product_id."' AND s.is_cancel=0 AND s.expire_date<NOW() ");exit();
		// if($query->row['total']>=1){
		// 	return false;
		// }else{
			$query = $this->db->query("SELECT max(id) as id,cmd_id FROM ".DB_PREFIX."cas_op_transactions WHERE `id` > '".$id."' and cmd_id IN (10,11) AND user_id = '".$user_id."' AND product_id = '".$product_id."' group by cmd_id");
			// var_dump($query);exit();	
			if($query->num_rows==2){
				$checking = array();
				foreach ($query->rows as $key ) {
					$checking[$key['cmd_id']]=$key['id'];
				}
				if($checking[10]<$checking[11]){
					$query = $this->db->query("SELECT id FROM ".DB_PREFIX."cas_op_transactions WHERE `id` > '".$id."' AND user_id = '".$user_id."' AND product_id = '".$product_id."' AND cmd_id = 10");
					if($query->num_rows>=1)
						return false;
					else
						return true;
				}else{
					return false; 
				}
			}else{
				if($query->num_rows==1) {
					$query = $this->db->query("SELECT exp_date FROM ".DB_PREFIX."cas_op_transactions WHERE `id` = '".$id."' AND user_id = '".$user_id."' AND product_id = '".$product_id."' ");
					$exp_date = $query->row['exp_date'];
					$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
					$current_date = $currDate->format('Y-m-d H:i:s');
					if($exp_date < $current_date)
						return true;
					else {
						$query = $this->db->query("SELECT id FROM ".DB_PREFIX."cas_op_transactions WHERE `id` > '".$id."' AND user_id = '".$user_id."' AND product_id = '".$product_id."' AND cmd_id =11 and ack_ctr=1");
						if($query->num_rows>=1)
							return false;	
						else
							return true;
					}
				} else {
					
					$query = $this->db->query("SELECT exp_date FROM ".DB_PREFIX."cas_op_transactions WHERE `id` = '".$id."' AND user_id = '".$user_id."' AND product_id = '".$product_id."' ");
					$exp_date = $query->row['exp_date'];
					$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
					$current_date = $currDate->format('Y-m-d H:i:s');					
					if($exp_date > $current_date)
						return true;
					else 
						return false;
				}
			}
		// }
	}


	public function getMaxExpiry($user_id,$product_id)	{
		$query = $this->db->query("SELECT id,exp_date FROM ".DB_PREFIX."cas_op_transactions c WHERE c.product_id='".$product_id."' AND c.user_id='".$user_id."' ORDER BY ID DESC LIMIT 1");
		return $query->row;
	}

	public function getUserId($id)	{
		$query = $this->db->query("SELECT user_id FROM ".DB_PREFIX."cas_op_transactions c WHERE c.id='".$id."'");
		return $query->row['user_id'];
	}

	public function getProductId($id)	{
		$query = $this->db->query("SELECT product_id FROM ".DB_PREFIX."cas_op_transactions c WHERE c.id='".$id."'");
		return $query->row['product_id'];
	}

	

	public function getIdsForExpiryUpdate($user_id,$product_id,$id)	{


		$query_desub = $this->db->query("SELECT MAX(id) as id FROM ".DB_PREFIX."cas_op_transactions WHERE user_id=".$user_id." AND product_id=".$product_id." AND cmd_id=11 and ack_ctr=1");
		$id_list='';					
		if($query_desub->row["id"]==NULL){
			$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET  exp_date = NOW() WHERE user_id=".$user_id." AND product_id=".$product_id." and cmd_id=10"); 
		}else{
			$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET  exp_date = NOW() WHERE user_id =".$user_id." and product_id=".$product_id." and cmd_id=10 and id >".$query_desub->row['id']);
		}

	}

	public function updateExpiry($user_id,$product_id)	{
		$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET  exp_date = NOW() WHERE user_id = '" .$user_id. "' AND product_id = '" .$product_id. "' AND cmd_id=10");
		// -----------------------------6 apr 2017-----------------------------------------------------------
		$this->db->query("UPDATE " . DB_PREFIX . "subscription SET  expire_date = NOW() WHERE customer_id = '" .$user_id. "' AND product_id = '" .$product_id. "' AND is_cancel=1");
		// ----------------------------------------------------------------------------------------------
	}
	public function getProductNo($product_id) {
		$query = $this->db->query("SELECT `model` FROM ".DB_PREFIX."product WHERE `product_id`='".$product_id."'");
		return $query->row['model'];
	}

	public function isNvod($product_no)	{
		$query = $this->db->query("SELECT is_nvod FROM `" . DB_PREFIX . "product` WHERE model = '" . (int)$product_no . "'");
		return $query->row;
	}

	public function getStbNoFromId($id){
	 	$query = $this->db->query("SELECT `user_id` FROM ".DB_PREFIX."cas_op_transactions WHERE `id`='".$id."'");
	 	$query1 = $this->db->query("SELECT `stb_no` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$query->row['user_id']."'");
	 	if($query1->num_rows==1){
			return $query1->row['stb_no'];
	 	} else {
			return '0';
		}
	}

	public function isBlacklist($stb_no){	 	
	 	$query = $this->db->query("SELECT `is_black_list` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_black_list'];
	 	}else{
	 		return 0;
		}		
	}

	public function InsertUpdateSubscriptionDesubscriptionExpiryForDesubscription($user_id,$cmd_id,$tx_id,$ack_is,$operator_id,$stbno,$product_id)	{  
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('Y-m-d H:i:s');

		$query_desub = $this->db->query("SELECT MAX(id) as id FROM ".DB_PREFIX."subscriptionDesubscription WHERE user_id=".$user_id." AND stbno = '".$stbno."' AND product_id = ".$product_id." AND cmd_id=10");
		if($query_desub->row["id"]){
			$this->db->query("UPDATE " . DB_PREFIX . "subscriptionDesubscription SET  exp_date = '".$current_date."' WHERE id=".$query_desub->row["id"]);	
		}

		$this->db->query("INSERT INTO " . DB_PREFIX . "subscriptionDesubscription SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',product_id='".$product_id."',user_id='".$user_id."', stbno='".$stbno."', ack_ctr='".$ack_is."',modify_date='".$current_date."',operator_id='".$operator_id."'");

	}

	public function isDeSubscribed($user_id,$stbno,$product_id){
		$query_desub = $this->db->query("SELECT cmd_id from ".DB_PREFIX."subscriptionDesubscription where id= (SELECT MAX(id) as id FROM ".DB_PREFIX."subscriptionDesubscription WHERE user_id=".$user_id." AND stbno = '".$stbno."' AND product_id=".$product_id.")");
		if($query_desub->row!=NULL){
			return $query_desub->row["cmd_id"];
		}else{
			return 71;
		}

	}

}
?>