<?php
/*
@File box_suspend.php(MODEL)
DESIGN:	 BoxSuspention PAGE
    This class retrieves the stb number detials along with their Suspention.

@Author Jotiba Patil 
@date 22 Jan. 2018
*/
class ModelCommandsBoxSuspend extends Model {

/*
FUNCTION NAME 		-	getSuspendResume
DESCRIPTION 		-	Retrieves all transation details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getSuspendResume($data) {
		// echo "<pre>"; print_r($data); 
		switch ($data['target_level']) {
			case 1:
				$sql="SELECT id,tx_id,cmd_id,target_level,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,c.STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=23";
				if(isset($data['filter_value']))
				{
					$sql .=" AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";			
				}
			break;
			default:
				$sql="SELECT id,tx_id,cmd_id,target_level,user_id,ack_ctr,nack_ctr,payload,product_id,modify_date,exp_date,c.STBNO FROM ".DB_PREFIX."cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=23 ";
				if(isset($data['filter_lco']))
				{	#cas.user_id == LCO ID	
					$sql .=" AND cas.user_id = '".$this->db->escape($data['filter_lco'])."'";			
				}
			break;
		}

		if($this->session->data['user_group_id']!=1){
	      	$sql.=" AND cas.operator_id ='" . $this->session->data['user_id'] . "'";
	    }

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		// echo $sql;
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalSuspendResume
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	/*public function getTotalSuspendResume($data) {
		// var_dump($data); die;
		switch ($data['target_level']) {
			case 1:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions cas left join ".DB_PREFIX."customer c ON(cas.user_id=c.customer_id) WHERE cmd_id=23";
				if(isset($data['filter_value']))
				{
					$sql .= " AND c.STBNO = '".$this->db->escape($data['filter_value'])."'";
				}
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND c.operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;
			case 2:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE target_level=2 AND cmd_id=23";	
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;
			case 3:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE target_level=3 AND cmd_id=23";							
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;
			case 4:
				$sql="SELECT  count(*) AS total FROM " . DB_PREFIX . "cas_op_transactions WHERE target_level=4 AND cmd_id=23";							
				if($this->session->data['user_group_id']!=1)
		      	{
		      		$sql.=" AND operator_id ='" . $this->session->data['user_id'] . "'";
		      	}
			break;				
			default:
				return 0;
			break;
		}
		
	   $query = $this->db->query($sql);
		return $query->row['total'];;
	}	*/

/*
FUNCTION NAME 		-	addToCasOpTransanction
DESCRIPTION 		-	Queries to add the response data of api in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	void.
*/
	public function addToCasOpTransanction($stbno,$target_level,$target1,$id,$payload,$ack_is,$nack_is,$operator_id,$cmd_type){
		$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$id."',cmd_id=23,order_id=0,product_id=0,user_id='".$target1."',stbno='".$stbno."',ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,exp_date=now(),initiated_by='Admin',payload='".$payload."',target_level='".$target_level."',cmd_type=".$cmd_type.",operator_id='".$operator_id."' ");
	}

	public function updateSuspendStatusByStbno($suspendStatus,$stbno){
		$this->db->query("update ".DB_PREFIX."stb SET is_suspend=".$suspendStatus." WHERE stb_no= '".$stbno."' ");
	}

	public function updateSuspendStatusByLcoId($suspendStatus,$operator_id){
		$this->db->query("update ".DB_PREFIX."stb SET is_suspend=".$suspendStatus." WHERE operator_id= ".$operator_id." ");
	}

	public function updateSuspendStatusOcUser($suspendStatus,$operator_id){
		$this->db->query("update ".DB_PREFIX."user SET is_suspend=".$suspendStatus." WHERE user_id= ".$operator_id." ");
	}
	public function updateLcoStatusByUserId($userStatus,$user_id){
		$this->db->query("update ".DB_PREFIX."user SET status=".$userStatus." WHERE user_id= ".$user_id." ");
	}

	public function updateSuspendStatusOcStbLcoWise($suspendStatus,$operator_id){
		$this->db->query("update ".DB_PREFIX."stb SET is_suspend=".$suspendStatus." WHERE operator_id= ".$operator_id." ");
	}

/*
FUNCTION NAME 		-	getTransactionDetails
DESCRIPTION 		-	Retrieves transaction details.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
*/	
	public function getTransactionDetails($id)
	{
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c WHERE c.id='".$id."' ");
		return $query->row;
	}

/*
FUNCTION NAME 		-	isSTBPaired
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns rows.
*/

	public function isSTBPaired($stb_no) {
		$user_id = $this->session->data['user_id'];
		if($user_id!=1){
	 		$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."' AND `operator_id`='".$user_id."'");
		}else{
			$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	}
		return $query->num_rows;
	}	

	public function isSTBPairedValid($stb_no){
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL)
		return $query->row['customer_id'];
		
	}	

	public function isCustomerEnabled($stb_no){
	 	$query = $this->db->query("SELECT `status` FROM ".DB_PREFIX."customer WHERE `STBNO`='".$stb_no."'");
	 	if($query->row!=NULL)
		return $query->row['status'];
	}	

/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/

	public function getCustomerId($stb_no){
	 	$query = $this->db->query("SELECT customer_id,api_user_id,c.operator_id FROM ".DB_PREFIX."customer c left join ".DB_PREFIX."sms_kms_map sk ON(c.customer_id=sk.user_id)  WHERE `STBNO`='".$stb_no."'");
		return $query->row;
	}

	public function getStbNo($customer_id){
	 	$query = $this->db->query("SELECT `STBNO` FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
		return $query->row['STBNO'];
	}

	public function isActive($stb_no){
	 	$query = $this->db->query("SELECT `is_active` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_active'];
	 	}else{
	 		return '-1';
		}
	}	

	public function isBlacklist($stb_no){	 	
	 	$query = $this->db->query("SELECT `is_black_list` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_black_list'];
	 	}else{
	 		return 0;
		}		
	}

	public function isStbRMA($stb_no){	 	
	 	$query = $this->db->query("SELECT `box_status` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['box_status'];
	 	}else{
	 		return 0;
		}		
	}

	public function getAllRegions(){
		$sql ="SELECT region_name,pin FROM ".DB_PREFIX."region";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getAllGroups(){
		$sql ="SELECT customer_group_id,name FROM ".DB_PREFIX."customer_group_description";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getAllOperators(){
		if($this->session->data['user_group_id']==1){
			$sql ="SELECT user_id,username FROM ".DB_PREFIX."user";
		}else{
			$sql ="SELECT user_id,username FROM ".DB_PREFIX."user WHERE user_id=".$this->session->data['user_id'];
		} 
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getAllPackages(){
		$sql ="SELECT pd.product_id as package_id,name as package_name FROM ".DB_PREFIX."product_description 	pd INNER JOIN ".DB_PREFIX."product p ON p.product_id = pd.product_id WHERE p.is_package=1";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getGroupIdById($groupId){
		$query= $this->db->query("SELECT k.kms_group_id, k.sms_group_id FROM ".DB_PREFIX."customer_group_description g,".DB_PREFIX."sms_kms_group k WHERE g.customer_group_id=".$groupId." AND g.customer_group_id=k.sms_group_id");
		return $query->row;
	}

	public function getRegionNameByPin($postcode){
	 	$query = $this->db->query("SELECT `region_name` FROM ".DB_PREFIX."region WHERE pin=".$postcode."");
		return $query->row['region_name'];
	}

	public function getGroupNameById($groupId){
	 	$query = $this->db->query("SELECT name as group_name FROM ".DB_PREFIX."customer_group_description WHERE customer_group_id=".$groupId."");
		return $query->row['group_name'];
	}

	public function getLcoNameById($lcoId){
	 	$query = $this->db->query("SELECT username as lco_name FROM ".DB_PREFIX."user WHERE user_id=".$lcoId."");
		return $query->row['lco_name'];
	}
	public function getPacakgeNameById($packageId){
	 	$query = $this->db->query("SELECT name as package_name FROM ".DB_PREFIX."product p
	 			 INNER JOIN ".DB_PREFIX."product_description pd ON pd.product_id = p.product_id  
	 			 WHERE pd.product_id=".$packageId." AND p.is_package=1");
		return $query->row['package_name'];
	}

}
?>