<?php
/*
@File box_activation.php(MODEL)
DESIGN:	 BoxActivation PAGE
    This class retrieves the stb number detials along with their activation.

@Author Mahesh Yallure 
@date 19 Jan. 2016
*/
class ModelCommandsBoxActivation extends Model {

/*
FUNCTION NAME 		-	getActivationTransactions
DESCRIPTION 		-	Retrieves all transation details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getActivationTransactions($data) {
		$sql = "SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,CONCAT(c.firstname,' ',c.lastname) as name,cas.stbno as STBNO,	modify_date,exp_date FROM ".DB_PREFIX."cas_op_transactions cas
inner join ".DB_PREFIX."customer c on cas.user_id = c.customer_id
inner join (select max(id) as mId from  ".DB_PREFIX."cas_op_transactions cc where cmd_id in  (0,1) group by user_id,cmd_id)x 
on cas.id = x.mId ";
		/*$test = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (0) GROUP BY cas.user_id");
		$id_list1 = "";
		foreach ($test->rows as $key ) {
			$id_list1 = $id_list1.",".$key['id'];
		}
		$id_list1 = trim($id_list1,",");
		$test1 = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (1) GROUP BY cas.user_id");
		$id_list2 = "";
		foreach ($test1->rows as $key ) {
			$id_list2 = $id_list2.",".$key['id'];
		}
		$id_list2 = trim($id_list2,",");

		$id_list = $id_list1.",".$id_list2;
		$id_list = trim($id_list,",");
		if(strlen($id_list)==0){
			$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,CONCAT(c.firstname,' ',c.lastname) as name,cas.stbno as STBNO,	modify_date,exp_date FROM ".DB_PREFIX."cas_op_transactions cas,".DB_PREFIX."customer c WHERE cmd_id IN (0,1) AND user_id=customer_id";
		}else{
			$sql="SELECT id,tx_id,cmd_id,user_id,ack_ctr,nack_ctr,CONCAT(c.firstname,' ',c.lastname) as name,cas.stbno as STBNO,	modify_date,exp_date FROM ".DB_PREFIX."cas_op_transactions cas,".DB_PREFIX."customer c WHERE cmd_id IN (0,1) AND user_id=customer_id AND cas.id IN (".$id_list.")";
		}*/
		$implode = array();
			if($this->session->data['user_group_id']!=1)
	      	{
	      		$implode[]=" c.operator_id ='" . $this->session->data['user_id'] . "'";
	      	}
			if(isset($data['filter_value'])){
				$implode[]=" c.STBNO like '%".$this->db->escape($data['filter_value'])."%'";			
			}
			if ($implode) {
				$sql .= " WHERE " . implode(" AND ", $implode);
			}	
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " ORDER BY id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}
			$query = $this->db->query($sql);
			return $query->rows;
	}
/*
FUNCTION NAME 		-	getTotalStbActivations
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalStbActivations($data) {
		$sql = "SELECT count(*) as total FROM ".DB_PREFIX."cas_op_transactions cas
inner join ".DB_PREFIX."customer c on cas.user_id = c.customer_id
inner join (select max(id) as mId from  ".DB_PREFIX."cas_op_transactions cc where cmd_id in  (0,1) group by user_id,cmd_id)x 
on cas.id = x.mId";
		/*$test = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (0) GROUP BY cas.user_id");
		$id_list1 = "";
		foreach ($test->rows as $key ) {
			$id_list1 = $id_list1.",".$key['id'];
		}
		$id_list1 = trim($id_list1,",");
		$test1 = $this->db->query("SELECT MAX(id) AS id FROM ".DB_PREFIX."cas_op_transactions cas WHERE cas.cmd_id IN (1) GROUP BY cas.user_id");
		$id_list2 = "";
		foreach ($test1->rows as $key ) {
			$id_list2 = $id_list2.",".$key['id'];
		}
		$id_list2 = trim($id_list2,",");

		$id_list = $id_list1.",".$id_list2;
		$id_list = trim($id_list,",");
		if(strlen($id_list)==0){
			$sql = "SELECT count(*) AS total FROM ".DB_PREFIX."cas_op_transactions cas,".DB_PREFIX."customer c WHERE cmd_id IN (0,1) AND user_id=customer_id";
		}else{
			$sql = "SELECT count(*) AS total FROM ".DB_PREFIX."cas_op_transactions cas,".DB_PREFIX."customer c WHERE cmd_id IN (0,1) AND user_id=customer_id AND cas.id IN (".$id_list.")";
		}*/
		$implode = array();
			if($this->session->data['user_group_id']!=1)
	      	{
	      		$implode[]="  c.operator_id ='" . $this->session->data['user_id'] . "'";
	      	}
			if(isset($data['filter_value'])){
				$implode[]="  c.STBNO like '%".$this->db->escape($data['filter_value'])."%'";			
			}
			if ($implode) {
				$sql .= " WHERE " . implode(" AND ", $implode);
			}
			$query = $this->db->query($sql);
			return $query->row['total'];
	}

/*
FUNCTION NAME 		-	getSTBs
DESCRIPTION 		-	Retrieves all the mapping between cas number, stb number and customer id.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getSTBs($data=array()) {
		$sql="SELECT id,stb_no FROM " . DB_PREFIX . "stb WHERE customer_id!=0";
		if(!empty($data['filter_no'])){
			$sql.=" AND stb_no LIKE '" . $this->db->escape($data['filter_no']) . "%'";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;
	}
/*
FUNCTION NAME 		-	addToCasOpTransanction
DESCRIPTION 		-	Queries to add the response data of api in the database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	void.
*/
	public function addToCasOpTransanction($user_id,$cmd_id,$tx_id,$ack_is,$nack_is,$payload,$expiry_time,$operator_id,$stbno)
	 {	//$customer_id,$cmd_id,$id,$ack_is,$nack_is,$payload
		if($expiry_time==NULL){
			$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."', stbno='".$stbno."', ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',nack_type=-1,initiated_by='Admin',payload='".$payload."',operator_id='".$operator_id."'");
		}else{
			$this->db->query("INSERT INTO " . DB_PREFIX . "cas_op_transactions SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."', stbno='".$stbno."', ack_ctr='".$ack_is."',nack_ctr='".$nack_is."',exp_date='".$expiry_time."',nack_type=-1,initiated_by='Admin',payload='".$payload."',operator_id='".$operator_id."'");
		}
	}

	public function addToActivationDeactivation($user_id,$cmd_id,$tx_id,$ack_is,$expiry_time,$operator_id,$stbno)
	 {	
		$this->db->query("INSERT INTO " . DB_PREFIX . "activationDeactivation SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."', stbno='".$stbno."', ack_ctr='".$ack_is."',exp_date='".$expiry_time."',operator_id='".$operator_id."'");
	}	


/*
FUNCTION NAME 		-	getTransactionDetails
DESCRIPTION 		-	Retrieves transaction details.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns transaction id,cmd id,user id of transaction query.
*/	
	public function getTransactionDetails($id)
	{
		$query = $this->db->query("SELECT * FROM ".DB_PREFIX."cas_op_transactions c left join ".DB_PREFIX."sms_kms_map k on c.user_id=k.user_id WHERE c.id='".$id."' ");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getApiResponceId
DESCRIPTION 		-	Retrieves Kms id.
INPUT PARAMETER 	-	$id
OUTPUT PARAMETER 	- 	Returns kms_stb_id.
*/

	public function getApiResponceId($sms_stb_no)
	{
	 	$query = $this->db->query("SELECT kms_stb_id FROM `" . DB_PREFIX . "sms_kms_stb` WHERE sms_stb_id = '" . (int)$sms_stb_no . "'");
		return $query->row;
	}	

/*
FUNCTION NAME 		-	isSTBPaired
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns rows.
*/

	public function isSTBPaired($stb_no) {
		$user_id = $this->session->data['user_id'];
		if($user_id!=1){
	 		$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."' AND `operator_id`='".$user_id."'");
		}else{
			$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	}
		return $query->num_rows;
	}	

	public function isSTBPairedValid($stb_no){
	 	$query = $this->db->query("SELECT `customer_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL)
		return $query->row['customer_id'];
		
	}	

	public function isCustomerEnabled($stb_no){
	 	$query = $this->db->query("SELECT `status` FROM ".DB_PREFIX."customer WHERE `STBNO`='".$stb_no."'");//
		return $query->row['status'];
	}	

/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/

	public function getCustomerId($stb_no)
	{
	 	$query = $this->db->query("SELECT `customer_id`,`operator_id` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		return $query->row;
	}
/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/
	public function setSTBActiveDeactive($is_active,$cust_id,$type)	{
		//$type  here 1=>box activation 2=>resend 3=>deactivation
		if($type!=2){
			$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET is_active='".$is_active."',active_date=now() WHERE `customer_id`='".$cust_id."'");	
		}
		if($type == 2){			
			$query = $this->db->query("SELECT `active_date` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$cust_id."'");
			if( $query->row["active_date"] =="" || $query->row["active_date"] ==NULL ){
				$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET is_active='".$is_active."',active_date=now() WHERE `customer_id`='".$cust_id."'");		
			}else{
				$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET is_active='".$is_active."' WHERE `customer_id`='".$cust_id."'");	
			}
		}
	}

	public function setSTBActiveDeactiveOnlyForDeactivation($is_active,$cust_id,$type)	{
		//$type  here 1=>box activation 2=>resend 3=>deactivation
		if($type==3){
			$query = $this->db->query("SELECT `is_active` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$cust_id."'");
			if( $query->row["is_active"] == 1){
				$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET is_active='".$is_active."',active_date=now() WHERE `customer_id`='".$cust_id."'");			
			}else{
				$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET is_active='".$is_active."' WHERE `customer_id`='".$cust_id."'");	
			}

		}
	}

	/*
FUNCTION NAME 		-	getCasID
DESCRIPTION 		-	Retrieves cas and stb number for the given customer_id
INPUT PARAMETER 	-	cas_no
OUTPUT PARAMETER 	- 	Returns a row conatining the customer stb and cas details.
*/	
	public function addPasscode($stb_no,$pass_code){
		$query = $this->db->query("SELECT `pass_code` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
		if($query->row["pass_code"]==""){
			$query = $this->db->query("UPDATE  ".DB_PREFIX."stb SET `pass_code`='".$pass_code."' WHERE `stb_no`='".$stb_no."'");	
		}
	}

		/*
FUNCTION NAME 		-	getCustomerId
DESCRIPTION 		-	.
INPUT PARAMETER 	-	stb_no
OUTPUT PARAMETER 	- 	Returns Customer Id.
*/

	public function getStbNo($customer_id){
	 	$query = $this->db->query("SELECT `STBNO` FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
		return $query->row['STBNO'];
	}

	public function getStbNoFromId($id){
	 	$query = $this->db->query("SELECT `user_id` FROM ".DB_PREFIX."cas_op_transactions WHERE `id`='".$id."'");
	 	$query1 = $this->db->query("SELECT `stb_no` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$query->row['user_id']."'");
	 	if($query1->num_rows==1){
			return $query1->row['stb_no'];
	 	} else {
			return '0';
		}
	}
	
	public function getStbNoStatus($customer_id){
	 	$query = $this->db->query("SELECT `status` FROM ".DB_PREFIX."customer WHERE `customer_id`='".$customer_id."'");
		return $query->row['status'];
	}

	public function canResend($id){
	 	$query = $this->db->query("SELECT `user_id` FROM ".DB_PREFIX."cas_op_transactions WHERE cmd_id = 0 AND `id`='".$id."' AND exp_date>NOW()");
	 	// $status = $this->db->query("SELECT `is_active` FROM ".DB_PREFIX."stb WHERE `customer_id`='".$query->row['user_id']."'");
	 	
		// return $status->row['is_active'];
		if($query->row!=NULL){
			return 1;
		}else{
			return 0;
		}
	}

	public function canSendDeactivation($user_id){
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('Y-m-d H:i:s');
	 	$query = $this->db->query("SELECT `name` FROM ".DB_PREFIX."cas_op_transactions cas INNER JOIN oc_product_description pd ON (cas.product_id=pd.product_id) WHERE cmd_id IN (10,6) AND `exp_date`>'".$current_date."' AND user_id='".$user_id."'");
		return $query->num_rows;
	}

	public function isActive($stb_no){
	 	
	 	// $query = $this->db->query("SELECT `is_active` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	$query = $this->db->query("select aa.user_id,aa.stbno from oc_activationDeactivation aa inner join 
					(select max(id) as id from oc_activationDeactivation ad group by user_id ) A
					on aa.id = A.id
					where cmd_id =0 and exp_date >now() and aa.stbno like '".$stb_no."'");

	 	if($query->row!=NULL){
			return 1;//$query->row['is_active'];
	 	}else{
	 		return 0;
		}
		
	}	

	public function isBlacklist($stb_no){	 	
	 	$query = $this->db->query("SELECT `is_black_list` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_black_list'];
	 	}else{
	 		return 0;
		}		
	}

	public function getIdsForExpiryUpdate($user_id,$id)	{
		$query_desub = $this->db->query("SELECT MAX(id) as id FROM ".DB_PREFIX."cas_op_transactions WHERE user_id=".$user_id." AND cmd_id=1 and ack_ctr=1");
		$id_list='';					
		if($query_desub->row["id"]==NULL){
			$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET  exp_date = NOW() WHERE user_id=".$user_id." AND cmd_id=0");
		}else{
			$this->db->query("UPDATE " . DB_PREFIX . "cas_op_transactions SET  exp_date = NOW() WHERE user_id =".$user_id." and cmd_id=0 and id >".$query_desub->row['id']);	
		}
	}

	public function InsertUpdateActivationExpiryForDeactivation($user_id,$cmd_id,$tx_id,$ack_is,$operator_id,$stbno)	{  
		$currDate = new DateTime("now",new DateTimeZone('Asia/Calcutta'));  
		$current_date = $currDate->format('Y-m-d H:i:s');

		$query_desub = $this->db->query("SELECT MAX(id) as id FROM ".DB_PREFIX."activationDeactivation WHERE user_id=".$user_id." AND stbno = '".$stbno."' AND cmd_id=0");
		if($query_desub->row["id"]){
			$this->db->query("UPDATE " . DB_PREFIX . "activationDeactivation SET  exp_date = '".$current_date."' WHERE id=".$query_desub->row["id"]);	
		}

		$this->db->query("INSERT INTO " . DB_PREFIX . "activationDeactivation SET tx_id='".$tx_id."',cmd_id='".$cmd_id."',user_id='".$user_id."', stbno='".$stbno."', ack_ctr='".$ack_is."',modify_date='".$current_date."',operator_id='".$operator_id."'");

	}

	public function isDeactivated($user_id,$stbno){
		$query_desub = $this->db->query("SELECT cmd_id from ".DB_PREFIX."activationDeactivation where id= (SELECT MAX(id) as id FROM ".DB_PREFIX."activationDeactivation WHERE user_id=".$user_id." AND stbno = '".$stbno."')");
		return $query_desub->row["cmd_id"];

	}

}
?>