<?php
/*
@File review.php(MODEL)
CATALOG:	 REVIEW PAGE
    Manages the review list by retrieving/adding/editing it from database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogReview extends Model {
/*
FUNCTION NAME 		-	addReview
DESCRIPTION 		-	Adds new review detail to the database.
INPUT PARAMETER 	-	Review details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the review list page with a success notification
*/	
	public function addReview($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "review SET author = '" . $this->db->escape($data['author']) . "', product_id = '" . $this->db->escape($data['product_id']) . "', text = '" . $this->db->escape(strip_tags($data['text'])) . "', rating = '" . (int)$data['rating'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");
	
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	editReview
DESCRIPTION 		-	Updates review details for the selected review_id.
INPUT PARAMETER 	-	review_id, new review details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the review list page with a success notification
*/	
	public function editReview($review_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "review SET author = '" . $this->db->escape($data['author']) . "', product_id = '" . $this->db->escape($data['product_id']) . "', text = '" . $this->db->escape(strip_tags($data['text'])) . "', rating = '" . (int)$data['rating'] . "', status = '" . (int)$data['status'] . "', date_added = NOW() WHERE review_id = '" . (int)$review_id . "'");
	
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	deleteReview
DESCRIPTION 		-	Deletes review detail form the database for the selected review_id.
INPUT PARAMETER 	-	review_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the review list page with a success notification
*/	
	public function deleteReview($review_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "review WHERE review_id = '" . (int)$review_id . "'");
		
		$this->cache->delete('product');
	}
/*
FUNCTION NAME 		-	getReview
DESCRIPTION 		-	Retrieves review from the database based on the given review_id.
INPUT PARAMETER 	-	review_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the review.
*/	
	public function getReview($review_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT pd.name FROM " . DB_PREFIX . "product_description pd WHERE pd.product_id = r.product_id AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "') AS product FROM " . DB_PREFIX . "review r WHERE r.review_id = '" . (int)$review_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getReviews
DESCRIPTION 		-	Retrieves all the reviews from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing review details.
*/	
	public function getReviews($data = array()) {
		$sql = "SELECT r.review_id, pd.name, r.author, r.rating, r.status, r.date_added FROM " . DB_PREFIX . "review r LEFT JOIN " . DB_PREFIX . "product_description pd ON (r.product_id = pd.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'";																																					  
		
		$sort_data = array(
			'pd.name',
			'r.author',
			'r.rating',
			'r.status',
			'r.date_added'
		);	
			
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY r.date_added";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}																																							  
																																							  
		$query = $this->db->query($sql);																																				
		
		return $query->rows;	
	}
/*
FUNCTION NAME 		-	getTotalReviews
DESCRIPTION 		-	Retrieves the count for total number of reviews
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalReviews() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "review");
		
		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalReviewsAwaitingApproval
DESCRIPTION 		-	Retrieves the count for awaiting approval reviews
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matched
*/	
	public function getTotalReviewsAwaitingApproval() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "review WHERE status = '0'");
		
		return $query->row['total'];
	}	
}
?>