<?php
/*
@File information.php(MODEL)
CATALOG:	 INFORMATION PAGE
    Manages the information list by retrieving/adding/editing it from database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogInformation extends Model {
/*
FUNCTION NAME 		-	addInformation
DESCRIPTION 		-	Adds new information detail to the database.
INPUT PARAMETER 	-	information details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the information list page with a success notification
*/	
	public function addInformation($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "information SET sort_order = '" . (int)$data['sort_order'] . "', bottom = '" . (isset($data['bottom']) ? (int)$data['bottom'] : 0) . "', status = '" . (int)$data['status'] . "'");

		$information_id = $this->db->getLastId(); 
		
		foreach ($data['information_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "information_description SET information_id = '" . (int)$information_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}
		
		if (isset($data['information_store'])) {
			foreach ($data['information_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "information_to_store SET information_id = '" . (int)$information_id . "', store_id = '" . (int)$store_id . "'");
			}
		}

		if (isset($data['information_layout'])) {
			foreach ($data['information_layout'] as $store_id => $layout) {
				if ($layout) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "information_to_layout SET information_id = '" . (int)$information_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
				
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'information_id=" . (int)$information_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('information');
	}
/*
FUNCTION NAME 		-	editInformation
DESCRIPTION 		-	Updates information details for the selected information_id.
INPUT PARAMETER 	-	information_id, category details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the information list page with a success notification
*/	
	public function editInformation($information_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "information SET sort_order = '" . (int)$data['sort_order'] . "', bottom = '" . (isset($data['bottom']) ? (int)$data['bottom'] : 0) . "', status = '" . (int)$data['status'] . "' WHERE information_id = '" . (int)$information_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "information_description WHERE information_id = '" . (int)$information_id . "'");
					
		foreach ($data['information_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "information_description SET information_id = '" . (int)$information_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "information_to_store WHERE information_id = '" . (int)$information_id . "'");
		
		if (isset($data['information_store'])) {
			foreach ($data['information_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "information_to_store SET information_id = '" . (int)$information_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "information_to_layout WHERE information_id = '" . (int)$information_id . "'");

		if (isset($data['information_layout'])) {
			foreach ($data['information_layout'] as $store_id => $layout) {
				if ($layout['layout_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "information_to_layout SET information_id = '" . (int)$information_id . "', store_id = '" . (int)$store_id . "', layout_id = '" . (int)$layout['layout_id'] . "'");
				}
			}
		}
				
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'information_id=" . (int)$information_id. "'");
		
		if ($data['keyword']) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "url_alias SET query = 'information_id=" . (int)$information_id . "', keyword = '" . $this->db->escape($data['keyword']) . "'");
		}
		
		$this->cache->delete('information');
	}
/*
FUNCTION NAME 		-	deleteInformation
DESCRIPTION 		-	Deletes information detail form the database for the selected information_id.
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the information list page with a success notification
*/	
	public function deleteInformation($information_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "information WHERE information_id = '" . (int)$information_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "information_description WHERE information_id = '" . (int)$information_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "information_to_store WHERE information_id = '" . (int)$information_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "information_to_layout WHERE information_id = '" . (int)$information_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'information_id=" . (int)$information_id . "'");

		$this->cache->delete('information');
	}	
/*
FUNCTION NAME 		-	getInformation
DESCRIPTION 		-	Retrieves information details from the database based on the given information_id.
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the information.
*/
	public function getInformation($information_id) {
		$query = $this->db->query("SELECT DISTINCT *, (SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'information_id=" . (int)$information_id . "') AS keyword FROM " . DB_PREFIX . "information WHERE information_id = '" . (int)$information_id . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getInformations
DESCRIPTION 		-	Retrieves all the informations from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing information details.
*/			
	public function getInformations($data = array()) {
		if ($data) {
			$sql = "SELECT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
			$sort_data = array(
				'id.title',
				'i.sort_order'
			);		
		
			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				$sql .= " ORDER BY " . $data['sort'];	
			} else {
				$sql .= " ORDER BY id.title";	
			}
			
			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC";
			} else {
				$sql .= " ASC";
			}
		
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}		

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	
			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}	
			
			$query = $this->db->query($sql);
			
			return $query->rows;
		} else {
			$information_data = $this->cache->get('information.' . (int)$this->config->get('config_language_id'));
		
			if (!$information_data) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information i LEFT JOIN " . DB_PREFIX . "information_description id ON (i.information_id = id.information_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY id.title");
	
				$information_data = $query->rows;
			
				$this->cache->set('information.' . (int)$this->config->get('config_language_id'), $information_data);
			}	
	
			return $information_data;			
		}
	}
/*
FUNCTION NAME 		-	getInformationDescriptions
DESCRIPTION 		-	Retrieves the description for the given information_id
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the information description
*/	
	public function getInformationDescriptions($information_id) {
		$information_description_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information_description WHERE information_id = '" . (int)$information_id . "'");

		foreach ($query->rows as $result) {
			$information_description_data[$result['language_id']] = array(
				'title'       => $result['title'],
				'description' => $result['description']
			);
		}
		
		return $information_description_data;
	}
/*
FUNCTION NAME 		-	getInformationStores
DESCRIPTION 		-	Retrieves the rows containing the details about the given information_id to extract the 
						store mapped. 
INPUT PARAMETER 	-	information_id
OUTPUT PARAMETER 	- 	Returns the information_store_data containing the store_id for the selected information_id
*/
	public function getInformationStores($information_id) {
		$information_store_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information_to_store WHERE information_id = '" . (int)$information_id . "'");

		foreach ($query->rows as $result) {
			$information_store_data[] = $result['store_id'];
		}
		
		return $information_store_data;
	}
/*
FUNCTION NAME 		-	getInformationLayouts
DESCRIPTION 		-	Retrieves the layout selected for the given information_id
INPUT PARAMETER 	-	category_id
OUTPUT PARAMETER 	- 	Returns the information_layout_data containing the layout id.
*/
	public function getInformationLayouts($information_id) {
		$information_layout_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "information_to_layout WHERE information_id = '" . (int)$information_id . "'");
		
		foreach ($query->rows as $result) {
			$information_layout_data[$result['store_id']] = $result['layout_id'];
		}
		
		return $information_layout_data;
	}
/*
FUNCTION NAME 		-	getTotalInformations
DESCRIPTION 		-	Retrieves the row containing the count of rows in information table.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows in the information database.
*/		
	public function getTotalInformations() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "information");
		
		return $query->row['total'];
	}	
/*
FUNCTION NAME 		-	getTotalCategoriesByLayoutId
DESCRIPTION 		-	Generates a row containing the count of rows in information_to_layout table for the given layout_id.
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matching the layout_id in the database.
*/	
	public function getTotalInformationsByLayoutId($layout_id) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "information_to_layout WHERE layout_id = '" . (int)$layout_id . "'");

		return $query->row['total'];
	}
/*
FUNCTION NAME 		-	getTotalCategoriesByLayoutId
DESCRIPTION 		-	Generates a row containing the count of rows in information_to_layout table for the given layout_id.
INPUT PARAMETER 	-	layout_id
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of rows matching the layout_id in the database.
*/	
	public function checkDuplicateInformation($title) {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "information_description WHERE title = '" .$title . "'");

		return $query->row['total'];
	}

}
?>