<?php
/*
@File filter.php(MODEL)
CATALOG:	 FILTER PAGE
    Manages the filter list by retrieving/adding/editing it from database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogFilter extends Model {
/*
FUNCTION NAME 		-	addFilter
DESCRIPTION 		-	Adds new filter detail to the database generating unique filter_id.
INPUT PARAMETER 	-	filter details as an array 
OUTPUT PARAMETER 	- 	Adds to the database and returns to the filter list page with a success notification
*/	
	public function addFilter($data) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "filter_group` SET sort_order = '" . (int)$data['sort_order'] . "'");
		
		$filter_group_id = $this->db->getLastId();
		
		foreach ($data['filter_group_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "filter_group_description SET filter_group_id = '" . (int)$filter_group_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}

		if (isset($data['filter'])) {
			foreach ($data['filter'] as $filter) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "filter SET filter_group_id = '" . (int)$filter_group_id . "', sort_order = '" . (int)$filter['sort_order'] . "'");
				
				$filter_id = $this->db->getLastId();
				
				foreach ($filter['filter_description'] as $language_id => $filter_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "filter_description SET filter_id = '" . (int)$filter_id . "', language_id = '" . (int)$language_id . "', filter_group_id = '" . (int)$filter_group_id . "', name = '" . $this->db->escape($filter_description['name']) . "'");
				}
			}
		}		
	}
/*
FUNCTION NAME 		-	editFilter
DESCRIPTION 		-	Updates filter details for the filter_group_id.
INPUT PARAMETER 	-	filter_group_id, filter details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the filter list page with a success notification
*/	
	public function editFilter($filter_group_id, $data) {
		$this->db->query("UPDATE `" . DB_PREFIX . "filter_group` SET sort_order = '" . (int)$data['sort_order'] . "' WHERE filter_group_id = '" . (int)$filter_group_id . "'");

		$this->db->query("DELETE FROM " . DB_PREFIX . "filter_group_description WHERE filter_group_id = '" . (int)$filter_group_id . "'");

		foreach ($data['filter_group_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "filter_group_description SET filter_group_id = '" . (int)$filter_group_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
		}
				
		$this->db->query("DELETE FROM " . DB_PREFIX . "filter WHERE filter_group_id = '" . (int)$filter_group_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "filter_description WHERE filter_group_id = '" . (int)$filter_group_id . "'");
		
		if (isset($data['filter'])) {
			foreach ($data['filter'] as $filter) {
				if ($filter['filter_id']) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "filter SET filter_id = '" . (int)$filter['filter_id'] . "', filter_group_id = '" . (int)$filter_group_id . "', sort_order = '" . (int)$filter['sort_order'] . "'");
				} else {
					$this->db->query("INSERT INTO " . DB_PREFIX . "filter SET filter_group_id = '" . (int)$filter_group_id . "', sort_order = '" . (int)$filter['sort_order'] . "'");
				}
				
				$filter_id = $this->db->getLastId();
				
				foreach ($filter['filter_description'] as $language_id => $filter_description) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "filter_description SET filter_id = '" . (int)$filter_id . "', language_id = '" . (int)$language_id . "', filter_group_id = '" . (int)$filter_group_id . "', name = '" . $this->db->escape($filter_description['name']) . "'");
				}
			}
		}		
	}
/*
FUNCTION NAME 		-	deleteFilter
DESCRIPTION 		-	Deletes filter detail form the database for the given filter_group_id
INPUT PARAMETER 	-	filter_group_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the filter_group list page with a success notification
*/	
	public function deleteFilter($filter_group_id) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "filter_group` WHERE filter_group_id = '" . (int)$filter_group_id . "'");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "filter_group_description` WHERE filter_group_id = '" . (int)$filter_group_id . "'");	
		$this->db->query("DELETE FROM `" . DB_PREFIX . "filter` WHERE filter_group_id = '" . (int)$filter_group_id . "'");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "filter_description` WHERE filter_group_id = '" . (int)$filter_group_id . "'");
	}
/*
FUNCTION NAME 		-	getFilterGroup
DESCRIPTION 		-	Retrieves filter_group details from the database based on the given filter_group_id.
INPUT PARAMETER 	-	filter_group_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the filter_group asked.
*/	
	public function getFilterGroup($filter_group_id) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "filter_group` fg LEFT JOIN " . DB_PREFIX . "filter_group_description fgd ON (fg.filter_group_id = fgd.filter_group_id) WHERE fg.filter_group_id = '" . (int)$filter_group_id . "' AND fgd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getFilterGroups
DESCRIPTION 		-	Retrieves all the filter_groups from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing filter_group details.
*/			
	public function getFilterGroups($data = array()) {
		$sql = "SELECT * FROM `" . DB_PREFIX . "filter_group` fg LEFT JOIN " . DB_PREFIX . "filter_group_description fgd ON (fg.filter_group_id = fgd.filter_group_id) WHERE fgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
		
		$sort_data = array(
			'fgd.name',
			'fg.sort_order'
		);	
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY fgd.name";	
		}
		
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);

		return $query->rows;
	}
/*
FUNCTION NAME 		-	getFilterGroupDescriptions
DESCRIPTION 		-	Retrieves the description for the given filter_group_id
INPUT PARAMETER 	-	filter_group_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the filter group description
*/	
	public function getFilterGroupDescriptions($filter_group_id) {
		$filter_group_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "filter_group_description WHERE filter_group_id = '" . (int)$filter_group_id . "'");
				
		foreach ($query->rows as $result) {
			$filter_group_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $filter_group_data;
	}
/*
FUNCTION NAME 		-	getFilter
DESCRIPTION 		-	Retrieves the filter details for the given filter_id
INPUT PARAMETER 	-	filter_id
OUTPUT PARAMETER 	- 	Retruns a row conatining the filter detial asked
*/	
	public function getFilter($filter_id) {
		$query = $this->db->query("SELECT *, (SELECT name FROM " . DB_PREFIX . "filter_group_description fgd WHERE f.filter_group_id = fgd.filter_group_id AND fgd.language_id = '" . (int)$this->config->get('config_language_id') . "') AS `group` FROM " . DB_PREFIX . "filter f LEFT JOIN " . DB_PREFIX . "filter_description fd ON (f.filter_id = fd.filter_id) WHERE f.filter_id = '" . (int)$filter_id . "' AND fd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getFilters
DESCRIPTION 		-	Retrieves all the filter from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing filter details.
*/	
	public function getFilters($data) {
		$sql = "SELECT *, (SELECT name FROM " . DB_PREFIX . "filter_group_description fgd WHERE f.filter_group_id = fgd.filter_group_id AND fgd.language_id = '" . (int)$this->config->get('config_language_id') . "') AS `group` FROM " . DB_PREFIX . "filter f LEFT JOIN " . DB_PREFIX . "filter_description fd ON (f.filter_id = fd.filter_id) WHERE fd.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		if (!empty($data['filter_name'])) {
			$sql .= " AND fd.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}
		
		$sql .= " ORDER BY f.sort_order ASC";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}					

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getFilterDescriptions
DESCRIPTION 		-	Retrieves the description for the given filter_group_id
INPUT PARAMETER 	-	filter_group_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the filter group description
*/	
	public function getFilterDescriptions($filter_group_id) {
		$filter_data = array();
		
		$filter_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "filter WHERE filter_group_id = '" . (int)$filter_group_id . "'");
				
		foreach ($filter_query->rows as $filter) {
			$filter_description_data = array();
			
			$filter_description_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "filter_description WHERE filter_id = '" . (int)$filter['filter_id'] . "'");			
			
			foreach ($filter_description_query->rows as $filter_description) {
				$filter_description_data[$filter_description['language_id']] = array('name' => $filter_description['name']);
			}
			
			$filter_data[] = array(
				'filter_id'          => $filter['filter_id'],
				'filter_description' => $filter_description_data,
				'sort_order'         => $filter['sort_order']
			);
		}
		
		return $filter_data;
	}
/*
FUNCTION NAME 		-	getTotalFilterGroups
DESCRIPTION 		-	Retrieves all the filter group count from the database.
INPUT PARAMETER 	-	void.
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of filter group.
*/	
	public function getTotalFilterGroups() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "filter_group`"); 
		
		return $query->row['total'];
	}		
}
?>
