<?php
/*
@File download.php(MODEL)
CATALOG:	 DOWNLOAD PAGE
    Manages the download list by retrieving/adding/editing it from database.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelCatalogDownload extends Model {
/*
FUNCTION NAME 		-	addDownload
DESCRIPTION 		-	Adds new download detail to the database generating unique id.
INPUT PARAMETER 	-	download details as an array
OUTPUT PARAMETER 	- 	Adds the detial to the database and returns to the download list page with a success notification
*/	
	public function addDownload($data) {
      	$this->db->query("INSERT INTO " . DB_PREFIX . "download SET filename = '" . $this->db->escape($data['filename']) . "', mask = '" . $this->db->escape($data['mask']) . "', remaining = '" . (int)$data['remaining'] . "', date_added = NOW()");

      	$download_id = $this->db->getLastId(); 

      	foreach ($data['download_description'] as $language_id => $value) {
        	$this->db->query("INSERT INTO " . DB_PREFIX . "download_description SET download_id = '" . (int)$download_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
      	}	
	}
/*
FUNCTION NAME 		-	editDownload
DESCRIPTION 		-	Updates download details for the given download_id.
INPUT PARAMETER 	-	download_id, download details as an array
OUTPUT PARAMETER 	- 	Adds detail to the database and returns to the download list page with a success notification
*/	
	public function editDownload($download_id, $data) {
		if (!empty($data['update'])) {
			$download_info = $this->getDownload($download_id);
        	
			if ($download_info) {
      			$this->db->query("UPDATE " . DB_PREFIX . "order_download SET `filename` = '" . $this->db->escape($data['filename']) . "', mask = '" . $this->db->escape($data['mask']) . "', remaining = '" . (int)$data['remaining'] . "' WHERE `filename` = '" . $this->db->escape($download_info['filename']) . "'");
			}
		}		
		
        $this->db->query("UPDATE " . DB_PREFIX . "download SET filename = '" . $this->db->escape($data['filename']) . "', mask = '" . $this->db->escape($data['mask']) . "', remaining = '" . (int)$data['remaining'] . "' WHERE download_id = '" . (int)$download_id . "'");

      	$this->db->query("DELETE FROM " . DB_PREFIX . "download_description WHERE download_id = '" . (int)$download_id . "'");

      	foreach ($data['download_description'] as $language_id => $value) {
        	$this->db->query("INSERT INTO " . DB_PREFIX . "download_description SET download_id = '" . (int)$download_id . "', language_id = '" . (int)$language_id . "', name = '" . $this->db->escape($value['name']) . "'");
      	}
	}
/*
FUNCTION NAME 		-	deleteDownload
DESCRIPTION 		-	Deletes download detail form the database for the selected download_id.
INPUT PARAMETER 	-	download_id
OUTPUT PARAMETER 	- 	Deletes detail from the database and returns to the download list page with a success notification
*/	
	public function deleteDownload($download_id) {
      	$this->db->query("DELETE FROM " . DB_PREFIX . "download WHERE download_id = '" . (int)$download_id . "'");
	  	$this->db->query("DELETE FROM " . DB_PREFIX . "download_description WHERE download_id = '" . (int)$download_id . "'");	
	}	
/*
FUNCTION NAME 		-	getDownload
DESCRIPTION 		-	Retrieves download from the database based on the given download_id.
INPUT PARAMETER 	-	download_id
OUTPUT PARAMETER 	- 	Retruns a row queried containing details of the download.
*/
	public function getDownload($download_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "download d LEFT JOIN " . DB_PREFIX . "download_description dd ON (d.download_id = dd.download_id) WHERE d.download_id = '" . (int)$download_id . "' AND dd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		
		return $query->row;
	}
/*
FUNCTION NAME 		-	getDownloads
DESCRIPTION 		-	Retrieves all the downloads from the database. 
INPUT PARAMETER 	-	data array for filter options if any.
OUTPUT PARAMETER 	- 	Returns all the rows queried, containing download details.
*/	
	public function getDownloads($data = array()) {
		$sql = "SELECT * FROM " . DB_PREFIX . "download d LEFT JOIN " . DB_PREFIX . "download_description dd ON (d.download_id = dd.download_id) WHERE dd.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		if (!empty($data['filter_name'])) {
			$sql .= " AND dd.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
		}
		
		$sort_data = array(
			'dd.name',
			'd.remaining'
		);
	
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];	
		} else {
			$sql .= " ORDER BY dd.name";	
		}
			
		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}			

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
	
		return $query->rows;
	}
/*
FUNCTION NAME 		-	getDownloadDescriptions
DESCRIPTION 		-	Retrieves the description for the given download_id
INPUT PARAMETER 	-	download_id
OUTPUT PARAMETER 	- 	Retruns an array conatining the download description
*/	
	public function getDownloadDescriptions($download_id) {
		$download_description_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "download_description WHERE download_id = '" . (int)$download_id . "'");
		
		foreach ($query->rows as $result) {
			$download_description_data[$result['language_id']] = array('name' => $result['name']);
		}
		
		return $download_description_data;
	}
/*
FUNCTION NAME 		-	getTotalDownloads
DESCRIPTION 		-	Retrieves the row containing the count of rows in the download database.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of downloads in the database.
*/	
	public function getTotalDownloads() {
      	$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "download");
		
		return $query->row['total'];
	}	
}
?>