<?php
/*
@File customer.php(MODEL)
REPORT:	 CUSTOMER PAGE
    This class queries the Total authorized subscribers as a  list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelBulkStbRenewedAfterExpiry extends Model {
	/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Queries all the approved customer detials from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/
	public function getCustomersFilter($data) {
		/*$sql =$sql ="select Y.STBNO,Y.customer_unique_id,concat(Y.firstname,' ',Y.lastname) as name,X.* FROM
(select A.user_id,A.modify_date as lastDeactiveDate,min(B.modify_date) as currentActiveDate ,
	 datediff(min(B.modify_date),A.modify_date) as delay_in_days 
from 
	(select c.id,c.user_id,c.modify_date from oc_cas_op_transactions c inner join 
	(select max(id) as maxId from oc_cas_op_transactions where cmd_id=1 group by user_id) cc 
		on c.id=cc.maxId where c.cmd_id=1
	) A inner join
	oc_cas_op_transactions B on A.user_id = B.user_id
	where B.id > A.id and B.cmd_id =0 
	group by B.user_id) X inner join 
	".DB_PREFIX."customer Y on X.user_id = Y.customer_id WHERE delay_in_days BETWEEN 0 AND ".$data['filter_delay']." ";*/
	$sql = "select B.stbno as STBNO,c.customer_unique_id,concat(c.firstname,' ',c.lastname) as name,
B.user_id, A.modify_date as lastDeactiveDate ,datediff(B.modify_date,A.modify_date) as delay_in_days,
B.modify_date as currentActiveDate  FROM
(select ad.* from oc_activationDeactivation ad inner join 
(select max(id) as mxId from oc_activationDeactivation a where cmd_id =1 group by user_id) ax 
on ad.id = ax.mxId) A 
inner join 
(select ad.* from oc_activationDeactivation ad inner join 
(select max(id) as mxId from oc_activationDeactivation a where cmd_id=0 group by user_id) ax 
on ad.id = ax.mxId) B
on A.user_id = B.user_id 
inner join oc_customer c on B.user_id = c.customer_id 
where A.id < B.id Having delay_in_days BETWEEN 0 AND ".$data['filter_delay']." ORDER BY delay_in_days DESC";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		// var_dump($sql);
		$query = $this->db->query($sql);
		return $query->rows;	
	}

	 /*
FUNCTION NAME         -    getCustomerpdf
DESCRIPTION         -    Queries all the approved customer detials from the database. 
INPUT PARAMETER     -    void
OUTPUT PARAMETER     -     Returns all the rows retrieved
*/
    public function getCustomerpdf($data) {
      /* $sql =$sql ="select Y.STBNO,Y.customer_unique_id,concat(Y.firstname,' ',Y.lastname) as name,X.* FROM
(select A.user_id,A.modify_date as lastDeactiveDate,min(B.modify_date) as currentActiveDate ,
	 datediff(min(B.modify_date),A.modify_date) as delay_in_days 
from 
	(select c.id,c.user_id,c.modify_date from oc_cas_op_transactions c inner join 
	(select max(id) as maxId from oc_cas_op_transactions where cmd_id=1 group by user_id) cc 
		on c.id=cc.maxId where c.cmd_id=1
	) A inner join
	oc_cas_op_transactions B on A.user_id = B.user_id
	where B.id > A.id and B.cmd_id =0 
	group by B.user_id) X inner join 
	".DB_PREFIX."customer Y on X.user_id = Y.customer_id WHERE delay_in_days BETWEEN 0 AND ".$data['dalay_period']." ";*/
	$sql = "select B.stbno as STBNO,c.customer_unique_id,concat(c.firstname,' ',c.lastname) as name,
			B.user_id, A.modify_date as lastDeactiveDate ,datediff(B.modify_date,A.modify_date) as delay_in_days,
			B.modify_date as currentActiveDate  FROM
			(select ad.* from oc_activationDeactivation ad inner join 
			(select max(id) as mxId from oc_activationDeactivation a where cmd_id =1 group by user_id) ax 
			on ad.id = ax.mxId) A 
			inner join 
			(select ad.* from oc_activationDeactivation ad inner join 
			(select max(id) as mxId from oc_activationDeactivation a where cmd_id=0 group by user_id) ax 
			on ad.id = ax.mxId) B
			on A.user_id = B.user_id 
			inner join oc_customer c on B.user_id = c.customer_id 
			where A.id < B.id Having delay_in_days BETWEEN 0 AND ".$data['dalay_period']." ORDER BY delay_in_days DESC";
        $query = $this->db->query($sql);
        return $query->rows;    
    }
/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalCustomers($data=array()) {
		$sql ="select count(*) as total FROM
			(select ad.* from oc_activationDeactivation ad inner join 
			(select max(id) as mxId from oc_activationDeactivation a where cmd_id =1 group by user_id) ax 
			on ad.id = ax.mxId) A 
			inner join 
			(select ad.* from oc_activationDeactivation ad inner join 
			(select max(id) as mxId from oc_activationDeactivation a where cmd_id=0 group by user_id) ax 
			on ad.id = ax.mxId) B
			on A.user_id = B.user_id 
			inner join oc_customer c on B.user_id = c.customer_id 
			where A.id < B.id and datediff(B.modify_date,A.modify_date) BETWEEN 0 AND ".$data['filter_delay'];

		$query = $this->db->query($sql);
		return $query->row['total'];
	}
}
?>