<?php

class ModelBulkStbBulkSubscription extends Model {


	public function validateSTB($stbNo){
		$user_id = $this->session->data['user_id'];
	 	if($user_id!=1){
	 		$query = $this->db->query("SELECT * from ".DB_PREFIX."customer WHERE STBNO LIKE '".$stbNo."' AND operator_id='".$user_id."' ");
	 	}
	 	else{
	 		$query = $this->db->query("SELECT * from ".DB_PREFIX."customer WHERE STBNO LIKE '".$stbNo."'");
	 	}
	 	//return $query->rows;
        if($query->num_rows)
        	return true;
        else
            return false;
	}

	public function checkSTBStatus($stbNo){
		$user_id = $this->session->data['user_id'];
		$now_datetime = new DateTime("now", new DateTimeZone('Asia/Kolkata'));
		$current_date = $now_datetime->format('Y-m-d H:i:s');
		if($user_id!=1){
		 	$query = $this->db->query("SELECT a.cmd_id,a.exp_date from oc_activationDeactivation a 
						inner join oc_customer c on a.user_id = c.customer_id 
						where c.operator_id =".$user_id." AND  c.STBNO like '".$stbNo."' order by a.id desc limit 1 ");			
		}else{
			$query = $this->db->query("SELECT a.cmd_id,a.exp_date from oc_activationDeactivation a 
						inner join oc_customer c on a.user_id = c.customer_id 
						where  c.STBNO like '".$stbNo."' order by a.id desc limit 1 ");
		}	
		if($query->num_rows){
			if($query->rows[0]['cmd_id']==0 and $query->rows[0]['exp_date']>$current_date){
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	public function isBlacklist($stb_no){	 	
	 	$query = $this->db->query("SELECT `is_black_list` FROM ".DB_PREFIX."stb WHERE `stb_no`='".$stb_no."'");
	 	if($query->row!=NULL){
			return $query->row['is_black_list'];
	 	}else{
	 		return 0;
		}		
	}
	
	public function validateProductID($product_id){
		$query = $this->db->query("SELECT * from ".DB_PREFIX."product WHERE product_id = '".$product_id."' AND status=1");
	 	 	
	 	// return $query->rows;
        if($query->num_rows)
        	return true;
        else
            return false;
	}

	public function validateNvod($product_id){
		$query = $this->db->query("SELECT * from ".DB_PREFIX."product WHERE product_id = '".$product_id."' AND is_nvod=1");	 	
		if($query->num_rows)
        	return true;
        else
            return false; 
	}

	public function isCustomerEnabled($stb_no){
	 	$query = $this->db->query("SELECT `status` FROM ".DB_PREFIX."customer WHERE `STBNO`='".$stb_no."'");
		return $query->row['status'];
	}	


	public function getCustomerDetails($stb_no) {
		$query = $this->db->query("SELECT customer_id,customer_group_id,firstname,lastname,email,telephone,address_id,fax from ".DB_PREFIX."customer WHERE STBNO LIKE '".$stb_no."'");
		return $query->row;
	}

	public function getProductDetails($product_id) {
		$query = $this->db->query("SELECT name from ".DB_PREFIX."product_description WHERE product_id = '".$product_id."'");
		return $query->rows;
	}

	public function getProductPriceDetails($product_id) {
		$query = $this->db->query("SELECT price,model,is_package,is_ppv,tax_class_id from ".DB_PREFIX."product WHERE product_id = '".$product_id."'");
		return $query->rows;
	}

	public function getOptionDetails($product_id,$subs_month) {
		$query_1 = $this->db->query("SELECT option_value_id,option_id from ".DB_PREFIX."option_value_description WHERE name = '".$subs_month."'");
        if($query_1->num_rows){
			$query = $this->db->query("SELECT product_option_value_id,product_option_id,price from ".DB_PREFIX."product_option_value WHERE product_id = '".$product_id."' AND option_value_id = '".$query_1->row['option_value_id']."'");
			if($query->num_rows)
	        	return true;
	        else
	            return false; 
	    }else{
	    	return false;
	    }
	}

	public function getFlatShippingDetails() {
		
		$query = $this->db->query("SELECT * FROM  ".DB_PREFIX."setting WHERE  `group` =  'flat' AND  `key` =  'flat_cost'");
		
		return $query->rows;
	}

	public function getProductOptionDetails($product_id,$subs_month) {
		$query_1 = $this->db->query("SELECT option_value_id,option_id from ".DB_PREFIX."option_value_description WHERE name = '".$subs_month."'");

		$query = $this->db->query("SELECT product_option_value_id,product_option_id,price from ".DB_PREFIX."product_option_value WHERE product_id = '".$product_id."' AND option_value_id = '".$query_1->row['option_value_id']."'");
		return $query->rows;
	}	

	public function getAddressDetails($address_id) {
		$query = $this->db->query("SELECT address_id AS payment_address,firstname AS payment_firstname,lastname AS payment_lastname,company AS payment_company,company_id AS payment_company_id,tax_id AS payment_tax_id,address_1 AS payment_address_1, address_2 AS payment_address_2,city AS payment_city,postcode AS payment_postcode,country_id AS payment_country_id,zone_id AS payment_zone_id from ".DB_PREFIX."address WHERE address_id = '".$address_id."'");
		return $query->rows;
	}

	public function getTotal(){
		$count = 0;
		$dir = getcwd();
		$dir .= "/log/Bulk_Stb_Subscription/";
		// $files = scandir($dir);
		$files = preg_grep('~\.(gz)$~', scandir($dir));
		foreach ($files as $file){
			if ($file == '.' || $file == '..')
	        	    continue;
			$count++;
		}
		return $count;
	}

	public function getBulkRegistrationLogList($data){

		$prefix_download_url = HTTPS_SERVER."/log/Bulk_Stb_Subscription/";
		$dir = getcwd();
		$dir .= "/log/Bulk_Stb_Subscription/";
		// $files = scandir($dir);
		$files = preg_grep('~\.(gz)$~', scandir($dir));
		$zipFileArray = array();
		$fileDescArray[] = array();
		
		foreach ($files as $file){
			if ($file == '.' || $file == '..')
	    	    continue;
			else
				array_push($zipFileArray,$file);
		}  
		$i=0;

		foreach ($zipFileArray as $zipFile){ 
			$pieces = explode(".", $zipFile);
			$final_url = $prefix_download_url.$zipFile; 
			$date=$pieces[0];
			$fileDescArray[] = array( "name" => $zipFile, "date" => $date ,"download_url" => $final_url );
			$i = $i+1;
		}
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}
		}

		$j=0;
		$count = 0;
		for ($j=$data['start']+1;$j<=$i;$j++){
			if($fileDescArray && ($count<$data['limit'])){
				$count++;
				$result[$j] = array(
					'name'                  => $fileDescArray[$j]['name'],
					'date'                  => $fileDescArray[$j]['date'],
					'download_url'			=> $fileDescArray[$j]['download_url']
				);
			}
		}
		if($count == 0)
			$result = null;

		if($result!=null)
			$result = array_reverse($result);
		
		return $result;
	}

	public function getPNo($p_id) {
      	$query = $this->db->query("SELECT model FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$p_id . "' ");
		return $query->row['model'];
	}

	public function isLCOBalance($product_id,$data,$stb_no) {
		$orderAmount = $data['order_total']['2']['value'];
		/*$balance = $this->db->query("SELECT `credit` FROM ".DB_PREFIX."user us inner join ".DB_PREFIX."customer c on(us.user_id = c.operator_id) WHERE c.STBNO ='".$stb_no."'"); */
		$balance = $this->db->query("SELECT `credit` FROM ".DB_PREFIX."user us where user_id = ".$this->session->data['user_id']); 
		$avail_baance = $balance->row['credit'];
		if ($orderAmount <= $avail_baance) {
			return 0;
		}else{
			return 1;		
		}
	}

	public function isBasicPackageAvailable($customer_id,$product_id,$isBasePack) {
		if($isBasePack){
			$query = $this->db->query("SELECT pd.name as productName, pd.product_id FROM " . DB_PREFIX . "subscriptionDesubscription sd 
				     INNER JOIN ".DB_PREFIX."product p ON p.product_id = sd.product_id INNER JOIN ".DB_PREFIX."product_description pd ON 
				     pd.product_id = p.product_id WHERE sd.user_id=".$customer_id."  AND sd.exp_date > NOW() AND p.is_package = 1 AND p.package_type=1 ");
			// var_dump($query->num_rows); die;
			if($query->num_rows>0){
				if($query->num_rows>1)
					return 201;// for Multiple base pack subscribed;
				elseif($query->row['product_id']==$product_id)
					return 101; // for only one base pack subscribed and to extend the expiry.
				else
					return 301; // different base pack subscripiton available.
			}else{
				return 101; // no base pack subscription available. Trigger new subscription. 
			}
		}else{
			$query = $this->db->query("SELECT pd.name as productName, pd.product_id FROM " . DB_PREFIX . "subscriptionDesubscription sd 
				     INNER JOIN ".DB_PREFIX."product p ON p.product_id = sd.product_id INNER JOIN ".DB_PREFIX."product_description pd ON 
				     pd.product_id = p.product_id WHERE sd.user_id=".$customer_id."  AND sd.exp_date > NOW() AND p.is_package = 1 AND p.package_type=1 ");
			if($query->num_rows>0){
				if($query->num_rows>1)
					return 201;// for Multiple base pack subscribed;
				else
					return 101;
			}else{
				return 401; // no base pack available and subscribed package is not basepack;
			}
		}
	}

	public function getTaxRate($customer_id,$value,$tax_class_id){
		$tax_rates = array();
		$customer_group_id=0;
		$tax_amount = 0;
		$query = $this->db->query("SELECT customer_group_id,country_id,zone_id FROM " . DB_PREFIX . "customer c inner join ".DB_PREFIX."address a on c.address_id = a.address_id where c.customer_id=".$customer_id);
		$customer_data = $query->row;
		
		if($query->num_rows>0){
			$tax_query = $this->db->query("SELECT tr2.tax_rate_id, tr2.name, tr2.rate, tr2.type, tr1.priority FROM " . DB_PREFIX . "tax_rule tr1 LEFT JOIN " . DB_PREFIX . "tax_rate tr2 ON (tr1.tax_rate_id = tr2.tax_rate_id) INNER JOIN " . DB_PREFIX . "tax_rate_to_customer_group tr2cg ON (tr2.tax_rate_id = tr2cg.tax_rate_id) LEFT JOIN " . DB_PREFIX . "zone_to_geo_zone z2gz ON (tr2.geo_zone_id = z2gz.geo_zone_id) LEFT JOIN " . DB_PREFIX . "geo_zone gz ON (tr2.geo_zone_id = gz.geo_zone_id) WHERE tr1.tax_class_id = '" . (int)$tax_class_id . "' AND tr2cg.customer_group_id = '" . (int)$customer_data['customer_group_id'] . "' AND z2gz.country_id = '" . (int)$customer_data['country_id'] . "' AND (z2gz.zone_id = '0' OR z2gz.zone_id = '" . (int)$customer_data['zone_id'] . "') ORDER BY tr1.priority ASC");
			
			foreach ($tax_query->rows as $result) {
				$tax_rates[$result['tax_rate_id']] = array(
					'tax_rate_id' => $result['tax_rate_id'],
					'name'        => $result['name'],
					'rate'        => $result['rate'],
					'type'        => $result['type'],
					'priority'    => $result['priority']
				);
			}
		}
		
		$tax_rate_data = array();
		
		foreach ($tax_rates as $tax_rate) {
			if (isset($tax_rate_data[$tax_rate['tax_rate_id']])) {
				$amount = $tax_rate_data[$tax_rate['tax_rate_id']]['amount'];
			} else {
				$amount = 0;
			}
			
			if ($tax_rate['type'] == 'F') {
				$amount += $tax_rate['rate'];
			} elseif ($tax_rate['type'] == 'P') {
				$amount += ($value / 100 * $tax_rate['rate']);
			}
		
			$tax_rate_data[$tax_rate['tax_rate_id']] = array(
				'tax_rate_id' => $tax_rate['tax_rate_id'],
				'name'        => $tax_rate['name'],
				'rate'        => $tax_rate['rate'],
				'type'        => $tax_rate['type'],
				'amount'      => $amount
			);
		}
		
		return $tax_rate_data;
	}
	
}
?>