<?php

class ModelBulkServiceWiseTotActiveProducts extends Model {

/*
FUNCTION NAME 		-	getTotalServiceWiseTotalActiveProducts
DESCRIPTION 		-	Queries count the service list details.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getTotalServiceWiseTotalActiveProducts($data) {
		// $sql = "SELECT count(*) as total from oc_product p WHERE (p.is_package=0 AND p.is_ppv=0)";
		$sql = "SELECT * FROM  `oc_sms_kms_prod_pkg` skpp ";
			if(isset($data['filter_product'])){
				$sql .= " WHERE skpp.product_id=".$data['filter_product']." ";					
			}
		$sql .= "GROUP BY skpp.product_id";	  
		$query = $this->db->query($sql);
		if($query->row!=Null)
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getServiceWiseTotalActiveProductsDetails
DESCRIPTION 		-	Queries all the service list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getServiceWiseTotalActiveProductsDetails($data) { 
		$sql = "SELECT p.product_id, p.model AS service_number, pd.name AS service_name, skp.api_product_id FROM  `oc_product` p
				INNER JOIN oc_product_description pd ON pd.product_id = p.product_id
				INNER JOIN oc_sms_kms_product skp ON skp.product_id = pd.product_id
				WHERE (p.is_package=0 and p.is_ppv=0) ";
				if(isset($data['filter_product'])){
					$sql .= " AND skp.product_id=".$data['filter_product']." ";					
				}
				if (isset($data['start']) || isset($data['limit'])) {
					if ($data['start'] < 0) {
						$data['start'] = 0;
					}				

					if ($data['limit'] < 1) {
						$data['limit'] = 20;
					}	
				
					$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				}
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getServiceWiseTotalActiveProductsDetailsPDF
DESCRIPTION 		-	Queries all the service list details with their descriptions for pdf.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/
	public function getServiceWiseTotalActiveProductsDetailsPDF($filter_product) { 
		$sql = "SELECT p.product_id, p.model AS service_number, pd.name AS service_name, skp.api_product_id FROM  `oc_product` p
				INNER JOIN oc_product_description pd ON pd.product_id = p.product_id
				INNER JOIN oc_sms_kms_product skp ON skp.product_id = pd.product_id
				WHERE (p.is_package=0 and p.is_ppv=0) ";
				if($filter_product!=''){
					$sql .= " AND skp.product_id=".$filter_product." ";					
				}
		$query = $this->db->query($sql);
		return $query->rows;
	}

/*
FUNCTION NAME 		-	getKmsPackageIdList
DESCRIPTION 		-	Queries the selected package_id List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getKmsPackageIdList($api_product_id)
	{
		$sql="SELECT group_concat(skpp.package_id) as package_id FROM  `oc_sms_kms_prod_pkg` skpp WHERE product_id = ".$api_product_id." ";
		$query = $this->db->query($sql);
		if($query->row!=Null)
		return $query->row['package_id'];
	}

/*
FUNCTION NAME 		-	getSmsPackageIdList
DESCRIPTION 		-	Queries the selected package_id List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getSmsPackageIdList($kmsPkgIdList)
	{
		$sql="SELECT GROUP_CONCAT( skp.product_id ) AS package_id FROM  `oc_sms_kms_product` skp WHERE skp.api_product_id IN (".$kmsPkgIdList.") AND skp.is_package =1 "; 
		$query = $this->db->query($sql);
		if($query->row!=Null)
		return $query->row['package_id'];
	}	

/*
FUNCTION NAME 		-	getProducts
DESCRIPTION 		-	Queries the selected Products List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getProducts() {
		$query = $this->db->query("SELECT p.product_id,pd.name FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND (p.is_package=0 AND is_ppv=0 AND p.is_nvod=0)");
		return $query->rows;
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>