<?php

class ModelBulkProductModificationLogs extends Model {

	public function getTotalProductModificationLogs($data){
		$sql = "SELECT count(*) AS total from oc_logProductModification pm ";

		if (!empty($data['filter_product']) AND ($data['filter_product']!=-1)) {
			$sql .= " WHERE pm.product_number = ".$data['filter_product']." ";
		}

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getProductModificationLogDetails($data) {
		$sql = "SELECT * FROM oc_logProductModification pm left join oc_broadcaster b on pm.broadcaster_id = b.broadcaster_id";

		if (!empty($data['filter_product']) AND ($data['filter_product']!=-1)) {
			$sql .= " WHERE pm.product_number = ".$data['filter_product']." ";
		}
		
		$sql .= " ORDER BY pm.product_number,pm.startdate";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getProductModificationLog($product_number,$data) {
		$sql = "SELECT * FROM oc_logProductModification pm left join oc_broadcaster b on pm.broadcaster_id = b.broadcaster_id";

		if (!empty($data)) {
			$sql .= " WHERE pm.product_number in (".$product_number.") ";
		}
		
		$sql .= " ORDER BY pm.product_number,pm.startdate";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getAllProducts(){
		$sql = "SELECT name,model from oc_product p inner join oc_product_description pd on p.product_id = pd.product_id 
				where p.is_package=0 and p.is_ppv=0 and p.is_nvod=0";

		$query = $this->db->query($sql);
		return $query->rows;
	}

	

}
?>