<?php
/*
@File pkgwisechannellist.php(MODEL)
LOCALISATION:	 AlaCartewiseActiveconnection PAGE
    This class queries all the packages with the channels added to each of them.

@Author Ravi Ranjan
@date 20th Nov. 2015
*/
class ModelBulkPkgwiseChannelList extends Model {

	public function getTotalChannelListDetails($data) {

		$query = "SELECT count(*) as total FROM oc_product p inner join  oc_product_description pd
			on p.product_id = pd.product_id inner join oc_productToPackage px on px. product_id = p.product_id 
					WHERE px.package_id= ".$data['filter_package']." AND p.is_package =0 AND p.is_ppv =0";
		if($data['filter_broadcaster']=='0'){
			$query.='';
		}else{
			$query.=" AND p.broadcaster_id=".$data['filter_broadcaster'];
		}		
		$countquery = $this->db->query($query);
		return $countquery->row['total'];
	}

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails($data) { 
		$query = "SELECT p.product_id, p.service_id, pd.name,p.broadcaster_id,pd.product_type,p.model,ifnull(bd.name,'No Broadcaster') as broadcaster FROM oc_product p inner join  oc_product_description pd on p.product_id = pd.product_id 
			/*inner join oc_product_to_category pc on pc.product_id = p.product_id 
			inner join oc_category_description cd on cd.c*/
			inner join oc_productToPackage px on px. product_id = p.product_id 
			left join oc_broadcaster bd on bd.broadcaster_id = p.broadcaster_id
					WHERE px.package_id= ".$data['filter_package']." AND p.is_package =0 AND p.is_ppv =0";
		if($data['filter_broadcaster']=='0'){
			$query.="  ORDER BY p.product_id";
		}else{
			$query.=" AND p.broadcaster_id=".$data['filter_broadcaster']."  ORDER BY p.product_id";
		}		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$query .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($query);
		return $query->rows;
	}


/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the detail row.
*/	
	public function getChannelDetail($product_id) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price,p.broadcaster_id,pd.product_type,p.model FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->row;	
	}
/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd, ".DB_PREFIX."product_to_category cat, ".DB_PREFIX."category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}
	
	
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries the selected Package List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getPackages() {
		$query = $this->db->query("SELECT p.product_id,pd.name FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND p.is_package=1 and p.status=1");
		return $query->rows;
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

/*
FUNCTION NAME 		-	getBroadcasterName
DESCRIPTION 		-	Queries to get the name of broadcaster channel belongs the database.
INPUT PARAMETER 	-	boadcaster_id
OUTPUT PARAMETER 	- 	returns a row with column name.
*/	
	public function getBroadcasterName($broadcaster_id)
	{
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."broadcaster WHERE broadcaster_id='".$broadcaster_id."'");
		return $query->row['name'];
	}

	public function getPackageName($package_id)	{
		$query = $this->db->query("SELECT product_id as pkgId, name FROM ".DB_PREFIX."product_description WHERE product_id='".$package_id."'");
		return $query->row;
	}

	public function getPackageNo($package_id)	{
		$query = $this->db->query("SELECT model FROM ".DB_PREFIX."product WHERE product_id='".$package_id."'");
		return $query->row['model'];
	}

	public function getBroadcasterList(){
		$sql = "SELECT broadcaster_id, name FROM oc_broadcaster ORDER BY broadcaster_id ASC";
		$query = $this->db->query($sql);
		return $query->rows;
	}




}
?>