<?php
/*
@File pkgwisechannellist.php(MODEL)
LOCALISATION:	 AlaCartewiseActiveconnection PAGE
    This class queries all the packages with the channels added to each of them.

@Author Ravi Ranjan
@date 20th Nov. 2015
*/
class ModelBulkPkgwiseChannelcount extends Model {

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getChannelListDetails() {
			/*$query = "SELECT p.product_id,p.model,pd.name,ROUND(LENGTH(trim(BOTH ',' FROM channel_list))-
	LENGTH(REPLACE(trim(BOTH ',' FROM channel_list),',',''))/LENGTH(','))+1 AS count 
	FROM oc_product p inner join  oc_product_description pd 
	on p.product_id = pd.product_id where is_package=1 and p.status=1";*/
			$query = "SELECT pp.package_id as product_id,p.model,pd.name,count(*) as `count` FROM oc_product p inner join  oc_product_description pd on p.product_id = pd.product_id inner join oc_productToPackage pp on pp.package_id = p.product_id  
				where p.is_package=1 and p.status=1 group by pp.package_id,p.model,pd.name";

			$countquery = $this->db->query($query);
			return $countquery->rows;
	}

	/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

/*
FUNCTION NAME 		-	getChannelListDetails
DESCRIPTION 		-	Queries all the channel list details with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns the detail row.
*/	
	public function getChannelDetail($package_id=-1) {
		// var_dump($product_id);exit();
		/*$sql = "SELECT channel_list FROM ".DB_PREFIX."product 
				WHERE  is_package =1 AND is_ppv =0 AND product_id = ".$product_id." ";
		$query = $this->db->query($sql);
		return $query->row;*/	
		$channel_list=$this->db->query("SELECT p.channel_list FROM ".DB_PREFIX."product p WHERE p.product_id = '".$package_id."'");
		if($channel_list->row){
			$list=explode(',', trim($channel_list->row['channel_list']));
			$strlist="('".implode("','", $list)."')";
			$query = "SELECT  COUNT(p.product_id) AS total  FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd
					WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND pd.name IN ".$strlist." 
					GROUP BY p.product_id ORDER BY pd.name";
					
			$countquery = $this->db->query($query);
			return $countquery->num_rows;
			}else{
			return array();
	 	} 
	}
/*
FUNCTION NAME 		-	getOptions
DESCRIPTION 		-	Queries all the options with their descriptions.
INPUT PARAMETER 	-	product_id
OUTPUT PARAMETER 	- 	Returns all the rows retrieved.
*/	
	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd, ".DB_PREFIX."product_to_category cat, ".DB_PREFIX."category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}
	
	
/*
FUNCTION NAME 		-	getPackages
DESCRIPTION 		-	Queries the selected Package List.
INPUT PARAMETER 	-	Null
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getPackages() {
		$query = $this->db->query("SELECT p.product_id,pd.name FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND p.is_package=1");
		return $query->rows;
	}

	/*
FUNCTION NAME 		-	getUserDetails
DESCRIPTION 		-	Queries the selected User details with its description.
INPUT PARAMETER 	-	package_id
OUTPUT PARAMETER 	- 	Returns the row retrieved.
*/
	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

}
?>