<?php

class ModelBulkPkgSubsListAsOnDate extends Model {

/*
FUNCTION NAME 		-	getTotalProductCount
DESCRIPTION 		-	Retrieves the rows containing the count of rows in Product table.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	Returns a column "total" containing the count of categories in the database.
*/		
	public function getTotalProductCount($data) {
		$user_id = $this->session->data['user_id'];
		if ($data['filter_option']==1) {
			$datetime_obj_start = new DateTime($data['filter_date_start'], new DateTimeZone('Asia/Calcutta'));
			$datetime_obj = new DateTime($data['filter_date_end'], new DateTimeZone('Asia/Calcutta'));
			$filterStartDate= $datetime_obj_start->format('Y-m-d').' 00:00:00';
			$filterDate= $datetime_obj->format('Y-m-d').' 23:59:59';
		}elseif($data['filter_option']==2) {
			$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
			$filter_month = $datetime_obj->format('Y-m');
			$filterStartDate   = date('Y-m-01', strtotime($filter_month)).' 23:59:59';
			$filterDate   = date('Y-m-t', strtotime($filter_month)).' 23:59:59';
		}elseif($data['filter_option']==3) {
			$filterStartDate = $data['filter_year'].'-01-01 00:00:00'; 
			$filterDate   = $data['filter_year'].'-12-31 23:59:59';
		}else{
			return NULL;
		}
		$filterValue    = '';
		if($data['filter_operator']!='-1')
			$filterValue .= " AND c.operator_id=".$data['filter_operator'];
      	$query = "SELECT COUNT(*) AS total FROM  `oc_subscriptionDesubscription` cas
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				INNER JOIN oc_product pd ON ( d.product_id = pd.product_id ) 
				INNER JOIN oc_customer c ON (c.customer_id = cas.user_id)		
				INNER JOIN (
					SELECT max(id) as id from oc_subscriptionDesubscription WHERE cmd_id =6 AND modify_date <= '".$filterDate."' group by user_id, product_id
				) bm on cas.id = bm.id WHERE pd.is_package =1 and cas.exp_date >= '".$filterStartDate."'".$filterValue;
		$countquery = $this->db->query($query);
		return $countquery->row['total'];
	}

/*
FUNCTION NAME 		-	getProductDetails
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	

	public function getProductDetails($data){
		if ($data['filter_option']==1) {
			$datetime_obj_start = new DateTime($data['filter_date_start'], new DateTimeZone('Asia/Calcutta'));
			$datetime_obj = new DateTime($data['filter_date_end'], new DateTimeZone('Asia/Calcutta'));
			$filterStartDate= $datetime_obj_start->format('Y-m-d').' 00:00:00';
			$filterDate= $datetime_obj->format('Y-m-d').' 23:59:59';
		}elseif($data['filter_option']==2) {
			$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
			$filter_month = $datetime_obj->format('Y-m');
			$filterStartDate   = date('Y-m-01', strtotime($filter_month)).' 23:59:59';
			$filterDate   = date('Y-m-t', strtotime($filter_month)).' 23:59:59';
		}elseif($data['filter_option']==3) {
			$filterStartDate = $data['filter_year'].'-01-01 00:00:00'; 
			$filterDate   = $data['filter_year'].'-12-31 23:59:59';
		}else{
			return NULL;
		}
		$filterValue    = '';
		if($data['filter_operator']!='-1')
			$filterValue .= " AND c.operator_id=".$data['filter_operator'];
		$sql = "SELECT pd.product_id as pid,d.name as pname,c.customer_unique_id, concat(firstname,' ',lastname) as name,(pd.model) AS pno, cas.stbno as  stbno, 
				cas.modify_date, cas.exp_date
				FROM  `oc_subscriptionDesubscription` cas
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				INNER JOIN oc_product pd ON ( d.product_id = pd.product_id ) 
				INNER JOIN oc_customer c ON (c.customer_id = cas.user_id)
				INNER JOIN (
					SELECT max(id) as id from oc_subscriptionDesubscription WHERE cmd_id =6 AND modify_date <= '".$filterDate."' group by user_id, product_id
				) bm on cas.id = bm.id WHERE pd.is_package =1 and cas.exp_date >= '".$filterStartDate."'".$filterValue;
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getProductDetailsForPDF
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	
	public function getProductDetailsForPDF($product_id,$data){  
		if ($data['filter_option']==1) {
			$datetime_obj_start = new DateTime($data['filter_date_start'], new DateTimeZone('Asia/Calcutta'));
			$datetime_obj = new DateTime($data['filter_date_end'], new DateTimeZone('Asia/Calcutta'));
			$filterStartDate= $datetime_obj_start->format('Y-m-d').' 00:00:00';
			$filterDate= $datetime_obj->format('Y-m-d').' 23:59:59';
		}elseif($data['filter_option']==2) {
			$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
			$filter_month = $datetime_obj->format('Y-m');
			$filterStartDate   = date('Y-m-01', strtotime($filter_month)).' 23:59:59';
			$filterDate   = date('Y-m-t', strtotime($filter_month)).' 23:59:59';
		}elseif($data['filter_option']==3) {
			$filterStartDate = $data['filter_year'].'-01-01 00:00:00'; 
			$filterDate   = $data['filter_year'].'-12-31 23:59:59';
		}else{
			return NULL;
		}
		$filterValue    = '';
		if($data['filter_operator']!='-1')
			$filterValue .= " AND c.operator_id=".$data['filter_operator'];
		$sql = "SELECT pd.product_id as pid,d.name as pname,c.customer_unique_id, concat(firstname,' ',lastname) as name,(pd.model) AS pno, cas.stbno as  stbno, 
				cas.modify_date, cas.exp_date
				FROM  `oc_subscriptionDesubscription` cas
				INNER JOIN oc_product_description d ON ( d.product_id = cas.product_id ) 
				INNER JOIN oc_product pd ON ( d.product_id = pd.product_id ) 
				INNER JOIN oc_customer c ON (c.customer_id = cas.user_id)
				INNER JOIN (
					SELECT max(id) as id from oc_subscriptionDesubscription WHERE cmd_id =6 AND modify_date <= '".$filterDate."' group by user_id, product_id
				) bm on cas.id = bm.id WHERE pd.is_package =1 and cas.exp_date >= '".$filterStartDate."'".$filterValue;
		$query = $this->db->query($sql);
		return $query->rows;
	}	

	public function getOperatorList(){
		$sql = "SELECT user_id, username FROM oc_user ORDER BY user_id ASC";
		$query = $this->db->query($sql);
		return $query->rows;
	}
	public function getOperatorNameById($user_id){
		$sql = "SELECT username FROM oc_user WHERE user_id=".$user_id;
		$query = $this->db->query($sql);
		return $query->row['username'];
	}
}
?>
