<?php
/*
@File customer.php(MODEL)
REPORT:	 CUSTOMER PAGE
    This class queries the Total authorized subscribers as a  list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelBulkPackageWiseSubscription extends Model {

	public function getCustomersForPrint($data) {
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
			if($query->row['user_group_id']==1){
				$sql ="select Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.product_id as prod_pkg_no,C.pname, Z.operator, Z.operator_id, C.exp_date,C.pname,if(C.cmd_id=6,'Package','A-la-carte') as type from 
(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,
					s.customer_id as cust_id,cgd.name,c.STBNO, u.username as operator, c.operator_id
					FROM oc_customer c 
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.cmd_id, A.user_id,A.product_id,pd.name as pname,A.exp_date from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					inner join oc_product_description pd on A.product_id = pd.product_id
					where A.cmd_id in (6,10) and A.exp_date > now() 
				) C
				on Z.customer_id = C.user_id";
			}else{
				$sql ="select Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.product_id as prod_pkg_no,C.pname, Z.operator, Z.operator_id, C.exp_date,C.pname,if(C.cmd_id=6,'Package','A-la-carte') as type from 
(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,
					s.customer_id as cust_id,cgd.name,c.STBNO, u.username as operator, c.operator_id
					FROM oc_customer c 
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.cmd_id,A.user_id,A.product_id,pd.name as pname,A.exp_date from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					inner join oc_product_description pd on A.product_id = pd.product_id
					where A.cmd_id in (6,10) and A.exp_date > now() 
				) C
				on Z.customer_id = C.user_id WHERE Z.operator_id = ".$this->session->data['user_id']."";
			}

		$implode=array();	
		if (!empty($data['filter_pid'])) {
			$implode[] = "C.product_id='".(int)$data['filter_pid'] ."'";
		}
		if (!empty($data['filter_month'])) {

			$implode[] = "C.exp_date like '%".$filter_month."%'";

		}
		if (!empty($data['filter_customer_unique_id'])) {
			$implode[] = "Z.customer_unique_id = '". $this->db->escape($data['filter_customer_unique_id']) . "'";
		}

		if (!empty($data['filter_name'])) {
			$implode[] = "Z.custName LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}

		if (!empty($data['filter_stb'])) {
			if(strtoupper($data['filter_stb'])=='NULL'){
				$implode[] = "Z.STBNO = ''";
			}else{
				$implode[] = "Z.STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";	
			}
		}
		
		if (!empty($data['pdid'])) {
			$implode[] = "C.product_id =".$this->db->escape($data['pdid']);
		}

		if ($data['filter_customer_group_id']!='*') {
			$implode[] = "  Z.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
		}

		if (isset($data['filter_status']) && $data['filter_status']!='*') {
			if($data['filter_status']==2){
				$implode[]= " (Z.STBNO ='' || Z.STBNO='0')";
			}else if($data['filter_status']==0){
				// $implode[] = " Z.active_date IS NOT NULL AND Z.cust_id!=0 AND Z.is_active=0 AND Z.active_date NOT LIKE  $implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
				$implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
			}else{
				/*$implode[]= " Z.is_active = '" . (int)$data['filter_status'] . "'";*/
				$implode[] = " X.user_id is not null ";
			}
		}

		if (($this->session->data['user_group_id']==1)&&($data['filter_operator']!='*')) {
				$implode[] = "Z.operator_id='" .(int)$data['filter_operator'] . "'";
		}

		if($implode){
			if($this->session->data['user_group_id']!=1){
				$sql.=" AND ".implode( ' AND ', $implode);
			}else{
				$sql.=" WHERE ".implode( ' AND ', $implode);	
			}
			
		}	
		// echo $sql;
		$query = $this->db->query($sql);

		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Queries all the approved customer detials from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/
	public function getCustomers($data) {
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
		if($query->row['user_group_id']==1){
				$sql ="select Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.product_id as prod_pkg_no,C.pname, Z.operator, Z.operator_id, C.exp_date,C.pname,if(C.cmd_id=6,'Package','A-la-carte') as type from 
(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,
					s.customer_id as cust_id,cgd.name,c.STBNO, u.username as operator, c.operator_id
					FROM oc_customer c 
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.cmd_id, A.user_id,A.product_id,pd.name as pname,A.exp_date from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					inner join oc_product_description pd on A.product_id = pd.product_id
					where A.cmd_id in (6,10) and A.exp_date > now() 
				) C
				on Z.customer_id = C.user_id";

//================== 

			}else{
				$sql ="select Z.customer_id as customer_id,Z.customer_group_id, Z.custName AS name, Z.STBNO,Z.cust_id, Z.name AS customer_group, Z.customer_unique_id as customerNo, C.product_id as prod_pkg_no,C.pname, Z.operator, Z.operator_id, C.exp_date,C.pname,if(C.cmd_id=6,'Package','A-la-carte') as type from 
(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,
					s.customer_id as cust_id,cgd.name,c.STBNO, u.username as operator, c.operator_id
					FROM oc_customer c 
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.cmd_id,A.user_id,A.product_id,pd.name as pname,A.exp_date from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					inner join oc_product_description pd on A.product_id = pd.product_id
					where A.cmd_id in (6,10) and A.exp_date > now() 
				) C
				on Z.customer_id = C.user_id WHERE Z.operator_id = ".$this->session->data['user_id']."";
			}	

		$implode=array();	
		if (!empty($data['filter_pid'])) {
			$implode[] = "C.product_id='".(int)$data['filter_pid'] ."'";
		}
		if (!empty($data['filter_month'])) {

			$implode[] = "C.exp_date like '%".$filter_month."%'";

		}
		if (!empty($data['filter_customer_unique_id'])) {
			$implode[] = "Z.customer_unique_id = '". $this->db->escape($data['filter_customer_unique_id']) . "'";
		}

		if (!empty($data['filter_name'])) {
			$implode[] = "Z.custName LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
		}
		if (!empty($data['pdid'])) {
			$implode[] = "C.product_id =".$this->db->escape($data['pdid']);
		}

		if (!empty($data['filter_stb'])) {
			if(strtoupper($data['filter_stb'])=='NULL'){
				$implode[] = "Z.STBNO = ''";
			}else{
				$implode[] = "Z.STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";	
			}
		}
			
		if (!empty($data['filter_customer_group_id'])) {
			$implode[] = "  Z.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
		}

		if (isset($this->request->get['filter_status'])) {
			if($this->request->get['filter_status']==2){
				$implode[]= " (Z.STBNO ='' || Z.STBNO='0')";
			}else if($this->request->get['filter_status']==0){
				// $implode[] = " Z.active_date IS NOT NULL AND Z.cust_id!=0 AND Z.is_active=0 AND Z.active_date NOT LIKE  '0000-00-00 00:00:00'";
				$implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
			}else{
				/*$implode[]= " Z.is_active = '" . (int)$data['filter_status'] . "'";*/
				$implode[] = " X.user_id is not null ";
			}
		}

		if (($this->session->data['user_group_id']==1)&&(!empty($data['filter_operator']))) {
				$implode[] = "Z.operator_id='" .(int)$data['filter_operator'] . "'";
		}

		if ($this->session->data['user_group_id']==1) {
			if($implode){
				$sql.=" WHERE ".implode( ' AND ', $implode);
			}	
		}else{
			if($implode){
				$sql.=" AND ".implode( ' AND ', $implode);
			}	
		}
			// $sql.= " GROUP BY cas.user_id, cas.product_id";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
		return $query->rows;	
	}

/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalAuthSubs($data) {
			$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
			$filter_month = $datetime_obj->format('Y-m');
			$query = $this->db->query("SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id like '" . $this->session->data['user_id'] . "'");
			if($query->row['user_group_id']==1){			
				$query = "select count(*) as total from 
(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,
					s.customer_id as cust_id,cgd.name,c.STBNO, u.username as operator, c.operator_id
					FROM oc_customer c 
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.cmd_id,A.user_id,A.product_id,pd.name as pname,A.exp_date from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					inner join oc_product_description pd on A.product_id = pd.product_id
					where A.cmd_id in (6,10) and A.exp_date > now() 
				) C
				on Z.customer_id = C.user_id";

			}else{
				$query ="select count(*) as total from 
(select c.customer_id,c.customer_unique_id,c.customer_group_id,concat(c.firstname,' ',c.lastname) as custName,
					s.customer_id as cust_id,cgd.name,c.STBNO, u.username as operator, c.operator_id
					FROM oc_customer c 
					inner join oc_customer_group_description cgd on c.customer_group_id=cgd.customer_group_id
					INNER JOIN oc_user u ON u.user_id=c.operator_id
					left join oc_stb s on s.customer_id = c.customer_id 
				) Z LEFT join
				(select A.cmd_id,A.user_id,A.product_id,pd.name as pname,A.exp_date from oc_subscriptionDesubscription A inner join 
					(select max(id) as id FROM 
						oc_subscriptionDesubscription where cmd_id in (10,11,6,7) group by user_id,product_id 
					) cas ON cas.id = A.id
					inner join oc_product_description pd on A.product_id = pd.product_id
					where A.cmd_id in (6,10) and A.exp_date > now() 
				) C
				on Z.customer_id = C.user_id WHERE Z.operator_id = ".$this->session->data['user_id']."";
			}

			$implode=array();
			if (!empty($data['filter_pid'])) {
				$implode[] = "C.product_id='".(int)$data['filter_pid'] ."'";
			}
			if (!empty($data['filter_month'])) {
				$implode[] = "C.exp_date like '%".$filter_month."%'";
			}
			if (!empty($data['filter_customer_unique_id'])) {
				$implode[] = "Z.customer_unique_id ='" . $this->db->escape($data['filter_customer_unique_id']) . "'";
			}
			if (!empty($data['filter_name'])) {
				$implode[] = "Z.custName LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
			}

			if (!empty($data['filter_stb'])) {
				if(strtoupper($data['filter_stb'])=='NULL'){
					$implode[] = "Z.STBNO = ''";
				}else{
					$implode[] = "Z.STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";	
				}
				// $implode[] = "STBNO LIKE '%" . $this->db->escape($data['filter_stb']) . "%'";
			}

			if (!empty($data['pdid'])) {
				$implode[] = "C.product_id =".$this->db->escape($data['pdid']);
			}
			if (!empty($data['filter_customer_group_id'])) {
				$implode[] = " Z.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
			}

			if (isset($this->request->get['filter_status'])) {
				if($this->request->get['filter_status']==2){
					$implode[]= " (Z.STBNO ='' || Z.STBNO='0')";
				}else if($this->request->get['filter_status']==0){
					// $implode[] = " Z.active_date IS NOT NULL AND Z.cust_id!=0 AND Z.is_active=0 AND Z.active_date NOT LIKE  '0000-00-00 00:00:00'";
					$implode[] = " X.user_id is null and (Z.STBNO !='' && Z.STBNO!='0')";
				}else{
					// $implode[]= " Z.is_active = '" . (int)$data['filter_status'] . "'";
					$implode[] = " X.user_id is not null ";
				}
			}

			if (($this->session->data['user_group_id']==1)&&(!empty($data['filter_operator']))) {
					$implode[] = "Z.operator_id='" .(int)$data['filter_operator'] . "'";
			}



			if ($this->session->data['user_group_id']==1) {
				if($implode){
					$query.=" WHERE ".implode( ' AND ', $implode);
				}	
			}else{
				if($implode){
					$query.=" AND ".implode( ' AND ', $implode);
				}	
			}

			// $query.= " GROUP BY cas.user_id, cas.product_id";
			// echo $query;
		$countquery = $this->db->query($query);
			return $countquery->row['total'];
		}


	public function getOperators() {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "user");
	
		return $query->rows;
	}

	public function getProductAndPackages($data = array()) {
		$sql = "SELECT p.product_id,pd.name as pname FROM " . DB_PREFIX . "product p INNER JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id)";
		$sql .= " WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "'"; 
		
		if (!empty($data['filter_pname'])) {
			$sql .= " AND pd.name LIKE '" . $this->db->escape($data['filter_pname']) . "%'";
		}
		$sql .= " ORDER BY pd.name";	
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		$query = $this->db->query($sql);
	
		return $query->rows;
	}
}
?>