<?php

class ModelBulkPackageModificationLogs extends Model {

	public function getTotalPackageModificationLogs($data){
		$sql = "SELECT Count(*) AS total from oc_logPackageModification pm ";

		if (!empty($data['filter_package'])) {
			$sql .= " WHERE pm.package_number = ".$data['filter_package']." ";
		}

		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getPackageModificationLogDetails($data) {
		$sql = "SELECT pm.package_number, pm.package_name, pm.startdate, pm.enddate, pm.status AS 
				action FROM oc_logPackageModification pm";

		if (!empty($data['filter_package'])) {
			$sql .= " WHERE pm.package_number = ".$data['filter_package']." ";
		}
		
		$sql .= " GROUP BY pm.package_number,pm.batchno,pm.status";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getPackageModificationLogs($package_number,$data) {
		
		$sql ="SELECT pm.package_number,pm.package_name,pm.startdate,pm.enddate,pm.batchno,pm.status as action,ppm.product_number,ppm.product_name
			,ppm.status as channel_status
			FROM oc_logPackageModification pm
			INNER JOIN oc_logPkgProductModification ppm ON ppm.batchno = pm.batchno";
			

		if (!empty($data)) {
			$sql .= " WHERE pm.package_number in (".$package_number.") ";
		}

		$sql .=" ORDER BY pm.package_number,pm.batchno";

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}
		}
// var_dump($sql);die;
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

	public function getChannelDetail($product_id) {
		$sql = "SELECT p.product_id, p.service_id, pd.name, p.price,p.broadcaster_id,pd.product_type FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->row;	
	}

	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM ".DB_PREFIX."product p, ".DB_PREFIX."product_description pd, ".DB_PREFIX."product_to_category cat, ".DB_PREFIX."category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}	

	public function getPackages() {
		$query = $this->db->query("SELECT p.product_id,pd.name,p.model FROM ".DB_PREFIX."product p ,".DB_PREFIX."product_description pd where p.product_id=pd.product_id AND p.is_package=1");
		return $query->rows;
	}

	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

	public function getPackageName($package_id)
	{
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."product_description WHERE product_id='".$package_id."'");
		return $query->row['name'];
	}

}
?>