<?php

class ModelBulkNActivationLog extends Model {

	public function getLogsDetails($data=array()) {
		
		$sql = "SELECT l.id, l.command_id, l.target, l.target_level, l.datetime, l.status, l.resend, l.targetNo FROM ".DB_PREFIX."logCasCommands l WHERE l.command_id IN (0,1) ";
			if(isset($data['filter_value']) && isset($data['filter_date_added']) ){
				$sql .= " AND  l.target ='".$this->db->escape($data['filter_value'])."' AND l.datetime like '".$data['filter_date_added']."%' ";
			}else if(isset($data['filter_date_added']) ){
				$sql .= " AND  l.datetime LIKE '".$data['filter_date_added']."%' ";
			}else if(isset($data['filter_value'])  ){
				$sql .= " AND  l.target ='".$this->db->escape($data['filter_value'])."' ";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}			
				$sql .= " ORDER BY l.id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

		$query = $this->db->query($sql);
		return $query->rows;	
	}

	public function getLogsDetailsForPDF($data=array(),$year) {
		
		$yearStartDate = $year.'-01-01 00:00:00';
		$yearLastDate  = $year.'-12-31 23:59:59';
		$sql = "SELECT l.id, l.command_id, l.target, l.target_level, l.datetime, l.status, l.resend, l.targetNo FROM ".DB_PREFIX."logCasCommands l WHERE l.command_id IN (0,1) AND l.datetime BETWEEN '".$yearStartDate."' AND '".$yearLastDate."' ";

			if(isset($data['filter_value']) && isset($data['filter_date_added']) && ($data['filter_date_added']!='' && $data['filter_value']!='')){ 
				$sql .= " AND  l.target ='".$data['filter_value']."' AND l.datetime like '".$data['filter_date_added']."%' ";
			}else if(isset($data['filter_date_added']) && $data['filter_date_added']!=''){ 
				$sql .= " AND  l.datetime LIKE '".$data['filter_date_added']."%' ";
			}else if(isset($data['filter_value']) && $data['filter_value']!=''){ 
				$sql .= " AND  l.target ='".$data['filter_value']."' ";
			}
			
			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}
				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}			
				$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}

		$query = $this->db->query($sql);
		return $query->rows;	
	}

	public function getLogsDescriptionDetails() {
		$query = $this->db->query("SELECT command_id,description FROM ".DB_PREFIX."logDescription
			");
		return $query->rows;
	}

	public function getOptions($product_id) {
		$query = $this->db->query("SELECT vd.name,vd.option_value_id,p.product_id,p.price FROM ".DB_PREFIX."product_option_value p, ".DB_PREFIX."option_value_description vd
			WHERE p.product_id='".$product_id."' and p.option_value_id=vd.option_value_id");
			return $query->rows;
	}

	public function getChannelDetail($product_id) {
		$sql = "SELECT p.model,p.product_id, p.service_id, pd.name, p.price,p.broadcaster_id FROM oc_product p, oc_product_description pd
				WHERE p.product_id = pd.product_id AND p.is_package =0 AND p.is_ppv =0 AND p.product_id = ".$product_id." 
				GROUP BY p.product_id ORDER BY pd.name";
		$query = $this->db->query($sql);
		return $query->row;	
	}

	public function getCategories($product_id) {
		$query = $this->db->query("SELECT cd.name as category
			FROM oc_product p, oc_product_description pd, oc_product_to_category cat, oc_category_description cd
			WHERE  p.product_id ='".$product_id."' AND p.product_id = pd.product_id AND p.product_id = cat.product_id AND cat.category_id = cd.category_id AND p.is_package=0 AND p.is_ppv=0");
			return $query->rows;
	}

	public function getUserDetails($user_id) {
		$query = $this->db->query("SELECT `firstname`,`lastname`,`email` FROM ".DB_PREFIX."user WHERE `user_id`='".$user_id."'");
		return $query->row;
	}

	public function getTotalLogs($data = array()) {
		
		$sql="SELECT count(id) as total FROM ".DB_PREFIX."logCasCommands l WHERE l.command_id IN (0,1) ";
		
		if(isset($data['filter_value']) && isset($data['filter_date_added']) ){
				$sql .= " AND  l.target ='".$this->db->escape($data['filter_value'])."' AND l.datetime like '".$data['filter_date_added']."%' ";
			}else if(isset($data['filter_date_added']) ){
				$sql .= " AND  l.datetime LIKE '".$data['filter_date_added']."%' ";
			}else if(isset($data['filter_value'])  ){
				$sql .= " AND  l.target ='".$this->db->escape($data['filter_value'])."' ";
			}

		$query = $this->db->query($sql);
		if($query->row!='')
			return $query->row['total'];	
	}

	public function getBroadcasterName($broadcaster_id)
	{
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."broadcaster WHERE broadcaster_id='".$broadcaster_id."'");
		return $query->row;
	}

}
?>
