<?php

class ModelBulkMrpBroadcasterChannelWiseReport extends Model {

/*
FUNCTION NAME 		-	getProductDetails
DESCRIPTION 		-	Get product details from product_description table with con.
INPUT PARAMETER 	-	-
OUTPUT PARAMETER 	- 	is_default
*/	
	public function getMRPReport($data){
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$sql = "call bd_MRPBoradcasterReport('".$filter_month."')"; 
		$query =	$this->db->MultiQuery($sql);
		return $query;	
	}

	public function getBroadcasterName($b_id){
		$query = $this->db->query("SELECT name FROM ".DB_PREFIX."broadcaster where broadcaster_id=".$b_id);
		return $query->row['name'];
	}

	public function getBroadcasters(){
		$query = "SELECT broadcaster_id,name FROM oc_broadcaster";
		$countquery = $this->db->query($query);		
		return $countquery->rows;
	}

	public function getRegions(){
		$sql = "SELECT region_id, region_name FROM oc_region";
		$query = $this->db->query($sql);		
		return $query->rows;
	}

	public function getBroadcasterChannels($data){
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$monthStartDate = date('Y-m-01', strtotime($filter_month)); 
		$monthStartDate = $monthStartDate." 00:00:00";
		$monthEndDate = date('Y-m-t', strtotime($filter_month)); 
		$monthEndDate = $monthEndDate." 23:59:59";

		$query="select pd.name ,p.product_id,p.lcn  from oc_logProductModification px inner join oc_product p on px.product_number = p.model
			inner join oc_product_description pd on pd.product_id = p.product_id 
		 where px.broadcaster_id = ".$data['filter_broadcaster']." AND p.is_package=0 AND p.is_ppv=0 and px.startdate < '".$monthEndDate."' AND (px.enddate > '".$monthStartDate."' or px.enddate is NULL) group by p.product_id";

		$countquery = $this->db->query($query);		
		return $countquery->rows;	
	}

	public function isBroadcasterChannelExistInPackage($product_id,$package_id,$BroadcasterPackage){
		$CheckingArray= array();
		if($BroadcasterPackage){
			foreach ($BroadcasterPackage as $Values) {
				$CheckingArray[$Values['pkId']]=$Values['prodIds'];
			}
		}
		if(array_key_exists($package_id,$CheckingArray)){
			$verify = explode(',', $CheckingArray[$package_id]);
			if(in_array($product_id, $verify))
				return true;
			else
				return false;
		}else{
			return false;
		}
	}

	public function getBroadcasterChannelsInPackageThisMonth($data,$slot){
		$datetime_obj = new DateTime($data['filter_month'], new DateTimeZone('Asia/Calcutta'));
		$filter_month = $datetime_obj->format('Y-m');
		$monthStartDate = date('Y-m-', strtotime($filter_month)); 
		switch ($slot) {
			case 1:	$monthEndDate = $monthStartDate."07 23:59:59";
					$monthStartDate = $monthStartDate."01 00:00:00";
					break;
			case 2:	$monthEndDate = $monthStartDate."14 23:59:59";
					$monthStartDate = $monthStartDate."08 00:00:00";
					break;
			case 3:	$monthEndDate = $monthStartDate."21 23:59:59";
					$monthStartDate = $monthStartDate."15 00:00:00";
					break;
			case 4:	$monthEndDate = $monthStartDate."28 23:59:59";
					$monthStartDate = $monthStartDate."22 00:00:00";
					break;
			default:
					return NULL;
					break;
		}
		

/* COMMENT: inner join table y result a-la-cartes available in broadcaster with the duration. 
		 x result package available in that duration  */
		$query="select x.pkId,group_concat(x.prodId) as prodIds from 
		(	select pj.product_id as pkId,pz.product_id as prodId 
				from oc_logPackageModification pk 
				inner join oc_logPkgProductModification pp on pk.batchno = pp.batchno 
				inner join oc_product pj on pj.model = pk.package_number
				inner join oc_product pz on pz.model = pp.product_number
				WHERE pj.is_package=1 AND (pk.startdate <= '".$monthEndDate."' and (pk.enddate >= '".$monthStartDate."' OR pk.enddate is NULL) ) 
				and pp.status !='OUT'
				group by pj.product_id,pz.product_id 
		)x inner join 
		(select p.product_id as bprodId 
			from oc_logProductModification px 
			inner join oc_product p on px.product_number = p.model
			where px.broadcaster_id = ".$data['filter_broadcaster']." AND p.is_package=0 and px.startdate < '".$monthEndDate."' AND (px.enddate > '".$monthStartDate."' or px.enddate is NULL) 
			group by p.product_id
		) y on x.prodId = y.bprodId
		group by x.pkId";
// var_dump($query);die;
		$countquery = $this->db->query($query);		
		return $countquery->rows;
	}

}
?>
