<?php
/*
@File customer.php(MODEL)
REPORT:	 CUSTOMER PAGE
    This class queries the Total authorized subscribers as a  list from the database for the store
    to generate the report.

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ModelBulkBlackList extends Model {
/*
FUNCTION NAME 		-	getCustomer
DESCRIPTION 		-	Queries the customer details based on the customer_id
INPUT PARAMETER 	-	customer_id
OUTPUT PARAMETER 	- 	Returns the asked customer details.
*/    
    public function getCustomer($customer_id) {
		$query = $this->db->query("SELECT c.*, CONCAT(c.firstname, ' ', c.lastname) AS name FROM " . DB_PREFIX . "customer c  WHERE  (c.status=1 and c.customer_id=".$customer_id.")");

		return $query->rows;	
	}
/*
FUNCTION NAME 		-	getCustomers
DESCRIPTION 		-	Queries all the approved customer detials from the database. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved
*/
	public function getCustomers($data) {
		if($this->session->data['user_id']==1){
			$sql ="SELECT customer_id,stb_no FROM ".DB_PREFIX."stb s WHERE s.customer_id!=0 AND s.is_black_list=1 ";
		}else{
			$sql ="SELECT customer_id,stb_no FROM ".DB_PREFIX."stb s ON(c.customer_id=s.customer_id) WHERE s.customer_id!=0 AND s.is_black_list=1";
		}
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}				

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}	
		
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}	
		
		$query = $this->db->query($sql);
		return $query->rows;	
	}

	 /*
FUNCTION NAME         -    getCustomerpdf
DESCRIPTION         -    Queries all the approved customer detials from the database. 
INPUT PARAMETER     -    void
OUTPUT PARAMETER     -     Returns all the rows retrieved
*/
    public function getCustomerpdf($customer_id) {
        $sql ="SELECT customer_id,stb_no FROM " . DB_PREFIX . "stb s WHERE s.customer_id!=0 AND s.is_black_list=1 AND	
        	   s.customer_id=".$customer_id;
        $query = $this->db->query($sql);
        return $query->rows;    
    }
/*
FUNCTION NAME 		-	getTotalStbAddress
DESCRIPTION 		-	Retrieves number of  stb number assign to customer and balance.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns all the rows retrieved by the query.
*/		
	public function getTotalAuthSubs() {
		if($this->session->data['user_id']==1){
			$query = $this->db->query("SELECT count(*) AS total FROM " . DB_PREFIX . "stb s where s.customer_id!=0 AND s.is_black_list=1 ");
		}else{
			$query = $this->db->query("SELECT count(*) AS total FROM " . DB_PREFIX . "stb s where s.customer_id!=0 AND s.is_black_list=1 ");
		}
		// var_dump($query->row['total']);exit();
		return $query->row['total'];
	}

	public function getStbHw($stb_no) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stb   WHERE  stb_no='".$stb_no."'");

		return $query->rows;	
	}
}
?>
