<?php
	/*
	Author: Ravi Ranjan
	date:17 March 2018
	class for History for LCO MSO Transaction Activity.
	*/
	class ModelBillTransaction extends Model {

		public function getTransactionList($data) {

			if ($this->session->data["user_id"] == 1) {
				$sql = "SELECT mlt.mso_lco_tx_id,us.username,CONCAT(us.firstname,' ',us.lastname) as name,us.email,us.mobile_no,mlt.amount,mlt.payment_type,mlt.date_added,mlt.initiated_by from oc_user us INNER join oc_mso_lco_transaction mlt on(us.user_id = mlt.lco_id) where us.user_id != 1";

				$sql.= $this->getFiltercondition($data);

				$sql .= " ORDER BY mlt.mso_lco_tx_id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
				
				$query = $this->db->query($sql);
				
				return $query->rows;
			
			}else{

				$sql = "SELECT mlt.mso_lco_tx_id,us.username,CONCAT(us.firstname,' ',us.lastname) as name,us.email,us.mobile_no,mlt.amount,mlt.payment_type,mlt.date_added,mlt.initiated_by from oc_user us INNER join oc_mso_lco_transaction mlt on(us.user_id = mlt.lco_id) where us.user_id = ".$this->session->data["user_id"]."";
				$sql.= $this->getFiltercondition($data);
				
				$sql .= " ORDER BY mlt.mso_lco_tx_id DESC LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];

				$query = $this->db->query($sql);
				return $query->rows;
			}	
		}

		public function getTotalTransaction($data) {
			if ($this->session->data["user_id"] == 1) {
				$sql = "SELECT count(*) as total FROM `oc_mso_lco_transaction` mlt INNER join `oc_user` us on(mlt.lco_id = us.user_id) WHERE us.user_id !=1 ";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->row['total'];
			}else{
				$sql = "SELECT count(*) as total FROM `oc_mso_lco_transaction` mlt INNER join `oc_user` us on(mlt.lco_id = us.user_id) WHERE us.user_id = ".$this->session->data["user_id"]." ";
				$sql.= $this->getFiltercondition($data);
				$query = $this->db->query($sql);
				return $query->row['total'];
			}
		}
	//======================
			public function getTransactionListPDF($id) {

				$sql = "SELECT mlt.mso_lco_tx_id,us.username,CONCAT(us.firstname,' ',us.lastname) as name,us.email,us.mobile_no,mlt.amount,mlt.payment_type,mlt.date_added,mlt.initiated_by from oc_user us left join oc_mso_lco_transaction mlt on(us.user_id = mlt.lco_id) where mlt.mso_lco_tx_id =".$id."";

				$query = $this->db->query($sql);
				return $query->row;
		}
	//======================		

		public function getPaymentPdfData($pay_id) {
			$sql = "SELECT cus.customer_id,CONCAT(cus.firstname,' ', cus.lastname) as customer_name
			,cus.customer_unique_id as customer_no,cus.STBNO,pt.advance_amt,pt.pending_amt,pt.amt_paid,pt.balance,pd.pay_month,pd.payment_date,pd.pay_id
			from " . DB_PREFIX . "payment_transaction as pt left join " . DB_PREFIX . "payment_detail as pd on(pt.pay_id = pd.pay_id) 
			inner join " . DB_PREFIX . "customer as cus on(pt.customer_id = cus.customer_id) where pd.pay_id = ".$pay_id."";

			$query = $this->db->query($sql);
			return $query->row;	
		}

		public function getFiltercondition($data) {

			$final_bind='';
			$implode=array();

			if (!empty($data['filter_trans_id'])) { 
				$implode[] = " mlt.mso_lco_tx_id like '%".$this->db->escape($data['filter_trans_id'])."%'";
			}



			if (!empty($data['filter_username'])) { 
				$implode[]= "us.username = '".$this->db->escape($data['filter_username']) . "'";
			}

			if (!empty($data['filter_name'])) {
				
				$implode[] =  " CONCAT(us.firstname,' ', us.lastname) LIKE '%".$this->db->escape($data['filter_name'])."%'";
			}

			if (!empty($data['filter_email'])) {
				$implode[]= "us.email = '".trim($this->db->escape($data['filter_email'])) ."'";
			}

			if (!empty($data['filter_mobile_no'])) {
				$implode[]= "us.mobile_no like '%" .$data['filter_mobile_no'] . "%'";
			}

			if (!empty($data['filter_payment_type'])) {
				$implode[]= "mlt.payment_type like '%" .$this->db->escape($data['filter_payment_type']) . "%'";
			}
			
			if (!empty($data['filter_initiated_by'])) {
				$implode[]= "mlt.initiated_by like '%" .$this->db->escape($data['filter_initiated_by']) . "%'";
			}

			if (!empty($data['filter_amount'])) {
				$implode[]= "mlt.amount = '" .$this->db->escape($data['filter_amount']) . "'";
			}
			
			if (!empty($data['filter_transaction_date'])) {

				$implode[]= "mlt.`date_added` LIKE '%".$data['filter_transaction_date']."%'";
			}

			if($implode){
				$final_bind =" AND ".implode( ' AND ', $implode);
			}	

/*			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}				

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}	

				$final_bind .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
			}*/

			return $final_bind;
		}
}
?>
