<?php
	/*
	@File user_command_permission.php(Controller)
	ADMIN USER_COMMAND_PERMISSION PAGE
	    This class manages the user account website access permissions. Here 
	    the user can be restricted to access some pages or can have no access.
	    

	@Author Ravi Ranjan 
	@date 16th Dec. 2016
	*/
class ControllerUserUserCommandPermission extends Controller {
	private $error = array();
			/*
			FUNCTION NAME 		-	index
			DESCRIPTION 		-	Loads when admin clicks the user_group option in the dopdown list.
									It get all the user_group name list and displays it here.
			INPUT PARAMETER 	-	void
			OUTPUT PARAMETER 	- 	Rendering of the user_group page showing all the user_group name in a list.
			*/ 
			public function index() {
				$this->language->load('user/user_command_permission');
		 
				$this->document->setTitle($this->language->get('heading_title'));
		 		
				$this->load->model('user/user_command_permission');
				
				$this->getList();
			}
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the user_group account details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
	public function update() {

		$this->language->load('user/user_command_permission');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('user/user_command_permission');

			if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm(0)) {
// var_dump($this->request->get['operator_id']);
// var_dump($this->request->post);die;
				$this->model_user_user_command_permission->editUserGroup($this->request->get['operator_id'], $this->request->post);
				$this->session->data['success'] = $this->language->get('text_success_update');
				$url = '';
				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}
				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
				$this->redirect($this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getForm();
	}

/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the user_group account added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the user_group list.
*/	
	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}
		 
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}	
	
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
			
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
							
		$this->data['insert'] = $this->url->link('user/user_command_permission/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('user/user_command_permission/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');	
	
		$this->data['user_groups'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$user_group_total = $this->model_user_user_command_permission->getTotalUserGroups();
		
		$results = $this->model_user_user_command_permission->getUserGroups($data);
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('user/user_command_permission/update', 'token=' . $this->session->data['token'] . '&operator_id=' . $result['user_id'] . $url, 'SSL')
			);		
		
			$this->data['user_groups'][] = array(
				'operator_id' 	=> $result['user_id'],
				'name'          => $result['username'],
				'selected'      => isset($this->request->post['selected']) && in_array($result['user_id'], $this->request->post['selected']),
				'action'        => $action
			);
		}	
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_name'] = $this->language->get('column_name');
		$this->data['column_action'] = $this->language->get('column_action');

		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else if(isset($this->session->data['warning']))
		{
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		}
		else{
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$this->data['sort_name'] = $this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'] . '&sort=name' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $user_group_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
		
		$this->data['pagination'] = $pagination->render();				

		$this->data['sort'] = $sort; 
		$this->data['order'] = $order;

		$this->template = 'user/user_command_permission_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
 	}
		/*
		FUNCTION NAME 		-	getForm
		DESCRIPTION 		-	Builds the form for the insertion/updation of the user_group account content. 
		INPUT PARAMETER 	-	void
		OUTPUT PARAMETER 	- 	Rendering of the user_group form page.
		*/
	protected function getForm() {
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_select_all'] = $this->language->get('text_select_all');
		$this->data['text_unselect_all'] = $this->language->get('text_unselect_all');
				
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_access'] = $this->language->get('entry_access');
		$this->data['entry_modify'] = $this->language->get('entry_modify');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
 		if (isset($this->error['user_id'])) {
			$this->data['error_user'] = $this->error['user_id'];
		} else {
			$this->data['error_user'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
			
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
			
		if (!isset($this->request->get['operator_id'])) {
			$this->data['action'] = $this->url->link('user/user_command_permission/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('user/user_command_permission/update', 'token=' . $this->session->data['token'] . '&operator_id=' . $this->request->get['operator_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('user/user_command_permission', 'token=' . $this->session->data['token'] . $url, 'SSL');

		if (isset($this->request->get['operator_id']) && $this->request->server['REQUEST_METHOD'] != 'POST') {

			$user_group_info = $this->model_user_user_command_permission->getUserGroup($this->request->get['operator_id']);
		}

		$this->data['operators'] = $this->model_user_user_command_permission->getOperatorList($this->request->get['operator_id']);
    	if (isset($this->request->post['operator_id'])) {    		
      		$this->data['user_id'] = $this->request->post['operator_id'];
    	} elseif (!empty($user_group_info)) { 
    		// var_dump($user_group_info[0]['operator_id']);
			$this->data['user_id'] = $user_group_info[0]['operator_id'];
			$this->data['is_insert'] = array("0"=> true);
		} else {
      		$this->data['user_id'] = "";
    	}

		 $this->data['permissions']=array('0'    => 'Box Activation,1',
        							      '12'   => 'Account Information,1',
        							      '6'    => 'Package Subscription,1',
        							      '10'	 => 'NVOD Subscription,1',
        							      '23'	 => 'Suspend,1',	
        							  );
			if (isset($user_group_info)) 
			{
				 $this->data['permissions']=array('0'    => 'Box Activation,0',
		        							      '12'   => 'Account Information,0',
		        							      '6'    => 'Package Subscription,0',
		        							      '10'	 => 'NVOD Subscription,0',	
		        							      '23'	 => 'Suspend,0',
		        							      );
			   for ($i=0; $i < sizeof($user_group_info); $i++) 
			   { 
				  $this->data['permissions'][$user_group_info[$i]['command_id']]=$user_group_info[$i]['command_name'].",1";
		       }	
		   }

		if (isset($this->request->post['permission'])) {
			$this->data['permission'] = $this->request->post['permission'];
		} elseif (isset($user_group_info['permission'])) {
			$this->data['permission'] = $user_group_info['permission'];
		} else { 
			$this->data['permission'] = array();
		}


	
		$this->template = 'user/user_command_permission_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	protected function validateForm($flag) {
		if (!$this->user->hasPermission('modify', 'user/user_command_permission')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
?>