<?php  
/*
@File user.php(Controller)
ADMIN USER PAGE
    This class manages the user account who can access the admin page by inserting/deleting/updating
    the accounts. 
    

@Author Mohammad Azfar 
@date 13th Nov. 2014
*/
class ControllerUserUser extends Controller {  
	private $error = array();
/*
FUNCTION NAME 		-	index
DESCRIPTION 		-	Loads when admin clicks the user option in the dopdown list.
						It get all the user account list and displays it here.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the user account list page showing all the users in a list.
*/   
  	public function index() {
    	$this->language->load('user/user');

    	$this->document->setTitle($this->language->get('heading_title'));
	
		$this->load->model('user/user');
		
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	insert
DESCRIPTION 		-	Loads the insert user form page where the admin can give the
						details of the new user account. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the admin user form page.
*/     
  	public function insert() {
  		$obj = new restapi();
    	$this->language->load('user/user');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('user/user');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {   		
			$lcoId = $this->model_user_user->addUser($this->request->post);
			/*=====================================================================*/
			$post=$this->request->post;
			$data="lcoId=".$lcoId."&username=".$post['username']."&firstname=".$post['firstname']."&lastname=".$post['lastname']."&email=".$post['email']."&mobile_no=".$post['mobileno']."&address=".$post['address']."&status=".$post['status'];
      	  	$method ="POST";
	 		$url=KMS_API."/enableLco";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
			$error=true;
			$api_user_id="";
			$response=json_decode($apiresult);
			$errorMsg="";
			
			foreach ($response as $key => $value) {
				switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$api_user_id=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
			}
			/*=====================================================================*/
			// if($this->request->post['user_group_id']==19){
			// 	$data_arr=array("agentid" =>mt_rand(1,9999),"name" =>$this->request->post['username'],"password" => $this->request->post['password'],"operatorid" => $this->session->data['user_id']);
			// 	$data=json_encode($data_arr);
		 // 		$method ="POST";
		 // 		$url="http://10.1.72.179/cash/v2/register";
		 // 		$hdr = array('Content-Type: application/x-www-form-urlencoded');
	  //       	$apiresult = $obj->callAPI($method,$hdr,$url,$data);
	  //   		$response=json_decode($apiresult);
	  //   		$error='';
	  //   		$message='';
	  //   		foreach ($response as $key => $value) {
	  //   			if($key == 'error')
	  //   				$error=$value;
	  //   			if($key == 'message')
	  //   				$message=$value;
	  //   		}
	  //   		if(!$error){
	  //   			$this->session->data['success']=$message;
	  //   		}else{
	  //   			$this->session->data['warning']=$message;
	  //   		}
			// 	$url = '';

			// 	if (isset($this->request->get['sort'])) {
			// 		$url .= '&sort=' . $this->request->get['sort'];
			// 	}

			// 	if (isset($this->request->get['order'])) {
			// 		$url .= '&order=' . $this->request->get['order'];
			// 	}

			// 	if (isset($this->request->get['page'])) {
			// 		$url .= '&page=' . $this->request->get['page'];
			// 	}
							
			// 	$this->redirect($this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL'));
	  //   	}else{
				$this->session->data['success'] = $this->language->get('text_success_insert');
				
				$url = '';

				if (isset($this->request->get['sort'])) {
					$url .= '&sort=' . $this->request->get['sort'];
				}

				if (isset($this->request->get['order'])) {
					$url .= '&order=' . $this->request->get['order'];
				}

				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
							
				$this->redirect($this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL'));
			// }
    	}
	
    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	update
DESCRIPTION 		-	Loads when the admin wants to edit the user account details that was 
						added/uploaded earlier. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the  form with the detials already saved earlier.
*/
  	public function update() {
    	$this->language->load('user/user');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('user/user');
		
    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->model_user_user->editUser($this->request->get['user_id'], $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			/*============================================================*/
			$obj = new restapi();
			$post=$this->request->post;
			// echo "<pre>"; print_r($post); die;
			$lcoId= $this->request->get['user_id'];
			$data="lcoId=".$lcoId."&username=".$post['username']."&firstname=".$post['firstname']."&lastname=".$post['lastname']."&email=".$post['email']."&mobile_no=".$post['mobileno']."&address=".$post['address']."&status=".$post['status'];
      	  	$method ="POST";
	 		$url=KMS_API."/enableLco";
	 		$hdr = array('Content-Type: application/x-www-form-urlencoded',API_AUTH_NAME .':'.API_AUTH);
        	$apiresult=$obj->callAPI($method,$hdr,$url,$data);
			$error=true;
			$api_user_id="";
			$response=json_decode($apiresult);
			$errorMsg="";
			
			foreach ($response as $key => $value) {
				switch ($key) {
    				case 'error':
    					$error=	$value;
    					break;
    				case 'message':
    					$apimessage=$value;				
    					break;
    				case 'id':
    					$api_user_id=$value;	
    					break;
    				default:
    					$errorMsg=$errorMsg." ".$key.":".$value;	
    					break;
    			}
    		}

			/*============================================================*/
			$url = '';
					
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
	
    	$this->getForm();
  	}
/*
FUNCTION NAME 		-	delete
DESCRIPTION 		-	Delete the selected user listed on the page. Admin selects the 
						checkbox against the user account in the list to be deleted and it gets deleted 
						after clicking the delete button. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the user list page after deleting the selected user from the list.
*/ 
  	public function delete() { 
    	$this->language->load('user/user');

    	$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('user/user');
		
    	if (isset($this->request->post['selected']) && $this->validateDelete()) {
      		foreach ($this->request->post['selected'] as $user_id) {
				$this->model_user_user->deleteUser($user_id);	
			}

			$this->session->data['success'] = $this->language->get('text_success_delete');
			
			$url = '';
					
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->redirect($this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL'));
    	}
	
    	$this->getList();
  	}
/*
FUNCTION NAME 		-	getList
DESCRIPTION 		-	Gets all the user account added by the admin. Calls a retrieval from the 
						database and make a list for it.
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Renders the user list.
*/	
  	protected function getList() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'username';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
			
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
					
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['enable'] = $this->url->link('user/user/enable', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['disable']= $this->url->link('user/user/disable', 'token=' . $this->session->data['token'] . $url, 'SSL');	
		$this->data['insert'] = $this->url->link('user/user/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		$this->data['delete'] = $this->url->link('user/user/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');			
			
    	$this->data['users'] = array();

		$data = array(
			'sort'  => $sort,
			'order' => $order,
			'start' => ($page - 1) * $this->config->get('config_admin_limit'),
			'limit' => $this->config->get('config_admin_limit')
		);
		
		$user_total = $this->model_user_user->getTotalUsers();
		
		$results = $this->model_user_user->getUsers($data);
    	
		foreach ($results as $result) {
			$action = array();
			
			$action[] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('user/user/update', 'token=' . $this->session->data['token'] . '&user_id=' . $result['user_id'] . $url, 'SSL')
			);
						
      		$this->data['users'][] = array(
				'user_id'    => $result['user_id'],
				'username'   => $result['username'],
				'mobileno'   => $result['mobile_no'],
				'suspend'	 => ($result['is_suspend'] ? "Suspended": "Not Suspended"),
				'status'     => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
				'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
				'selected'   => isset($this->request->post['selected']) && in_array($result['user_id'], $this->request->post['selected']),
				'action'     => $action
			);
		}	
			
		$this->data['heading_title'] = $this->language->get('heading_title');
		
		$this->data['text_no_results'] = $this->language->get('text_no_results');

		$this->data['column_username'] = $this->language->get('column_username');
		$this->data['column_status'] = $this->language->get('column_status');
		$this->data['column_date_added'] = $this->language->get('column_date_added');
		$this->data['column_action'] = $this->language->get('column_action');
		
		$this->data['button_insert'] = $this->language->get('button_insert');
		$this->data['button_delete'] = $this->language->get('button_delete');
 		
 		if (isset($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
		
			unset($this->session->data['warning']);
		}
 		else if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
		
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$url = '';

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
					
		$this->data['sort_username'] = $this->url->link('user/user', 'token=' . $this->session->data['token'] . '&sort=username' . $url, 'SSL');
		$this->data['sort_status'] = $this->url->link('user/user', 'token=' . $this->session->data['token'] . '&sort=status' . $url, 'SSL');
		$this->data['sort_date_added'] = $this->url->link('user/user', 'token=' . $this->session->data['token'] . '&sort=date_added' . $url, 'SSL');
		
		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
												
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		$pagination = new Pagination();
		$pagination->total = $user_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_admin_limit');
		$pagination->text = $this->language->get('text_pagination');
		$pagination->url = $this->url->link('user/user', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');
			
		$this->data['pagination'] = $pagination->render();
								
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;

		$this->template = 'user/user_list.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
  	}
/*
FUNCTION NAME 		-	getForm
DESCRIPTION 		-	Builds the form for the insertion/updation of the user account content. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Rendering of the user form page.
*/	
	protected function getForm() {
    	$this->data['heading_title'] = $this->language->get('heading_title');

    	$this->data['text_enabled'] = $this->language->get('text_enabled');
    	$this->data['text_disabled'] = $this->language->get('text_disabled');

    	$this->data['text_sdk_enabled'] = $this->language->get('text_sdk_enabled');
    	$this->data['text_sdk_disabled'] = $this->language->get('text_sdk_disabled');
		
    	$this->data['entry_username'] = $this->language->get('entry_username');
    	$this->data['entry_password'] = $this->language->get('entry_password');
    	$this->data['entry_confirm'] = $this->language->get('entry_confirm');
    	$this->data['entry_firstname'] = $this->language->get('entry_firstname');
    	$this->data['entry_lastname'] = $this->language->get('entry_lastname');
    	$this->data['entry_email'] = $this->language->get('entry_email');
    	$this->data['entry_user_group'] = $this->language->get('entry_user_group');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sdk_status'] = $this->language->get('entry_sdk_status');
		$this->data['entry_captcha'] = $this->language->get('entry_captcha');

    	$this->data['button_save'] = $this->language->get('button_save');
    	$this->data['button_cancel'] = $this->language->get('button_cancel');
    
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

 		if (isset($this->error['username'])) {
			$this->data['error_username'] = $this->error['username'];
		} else {
			$this->data['error_username'] = '';
		}

 		if (isset($this->error['password'])) {
			$this->data['error_password'] = $this->error['password'];
		} else {
			$this->data['error_password'] = '';
		}
		
 		if (isset($this->error['confirm'])) {
			$this->data['error_confirm'] = $this->error['confirm'];
		} else {
			$this->data['error_confirm'] = '';
		}
		
	 	if (isset($this->error['firstname'])) {
			$this->data['error_firstname'] = $this->error['firstname'];
		} else {
			$this->data['error_firstname'] = '';
		}
		
	 	if (isset($this->error['lastname'])) {
			$this->data['error_lastname'] = $this->error['lastname'];
		} else {
			$this->data['error_lastname'] = '';
		}
		
		if (isset($this->error['email'])) {
			$this->data['error_email'] = $this->error['email'];
		} else {
			$this->data['error_email'] = '';
		}
		if (isset($this->error['mobile_no'])) {
			$this->data['error_mobile_no'] = $this->error['mobile_no'];
		} else {
			$this->data['error_mobile_no'] = '';
		}
		if (isset($this->error['address'])) {
			$this->data['error_address'] = $this->error['address'];
		} else {
			$this->data['error_address'] = '';
		}


		$url = '';
			
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL'),
      		'separator' => ' :: '
   		);
		
		if (!isset($this->request->get['user_id'])) {
			$this->data['action'] = $this->url->link('user/user/insert', 'token=' . $this->session->data['token'] . $url, 'SSL');
		} else {
			$this->data['action'] = $this->url->link('user/user/update', 'token=' . $this->session->data['token'] . '&user_id=' . $this->request->get['user_id'] . $url, 'SSL');
		}
		  
    	$this->data['cancel'] = $this->url->link('user/user', 'token=' . $this->session->data['token'] . $url, 'SSL');

    	if (isset($this->request->get['user_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
      		$user_info = $this->model_user_user->getUser($this->request->get['user_id']);
      	
    	}

    	if (isset($this->request->post['username'])) {
      		$this->data['username'] = $this->request->post['username'];
    	} elseif (!empty($user_info)) {
			$this->data['username'] = $user_info['username'];
		} else {
      		$this->data['username'] = '';
    	}
  
  		if (isset($this->request->post['password'])) {
    		$this->data['password'] = $this->request->post['password'];
		} else {
			$this->data['password'] = '';
		}
		
  		if (isset($this->request->post['confirm'])) {
    		$this->data['confirm'] = $this->request->post['confirm'];
		} else {
			$this->data['confirm'] = '';
		}
  
    	if (isset($this->request->post['firstname'])) {
      		$this->data['firstname'] = $this->request->post['firstname'];
    	} elseif (!empty($user_info)) {
			$this->data['firstname'] = $user_info['firstname'];
		} else {
      		$this->data['firstname'] = '';
    	}

    	if (isset($this->request->post['lastname'])) {
      		$this->data['lastname'] = $this->request->post['lastname'];
    	} elseif (!empty($user_info)) {
			$this->data['lastname'] = $user_info['lastname'];
		} else {
      		$this->data['lastname'] = '';
   		}

   		if (isset($this->request->post['mobileno'])) {
      		$this->data['mobileno'] = $this->request->post['mobileno'];
    	} elseif (!empty($user_info)) {
			$this->data['mobileno'] = $user_info['mobile_no'];
		} else {
      		$this->data['mobileno'] = '';
   		}

   		if (isset($this->request->post['address'])) {
      		$this->data['address'] = $this->request->post['address'];
    	} elseif (!empty($user_info)) {
			$this->data['address'] = $user_info['address'];
		} else {
      		$this->data['address'] = '';
   		}
  
    	if (isset($this->request->post['email'])) {
      		$this->data['email'] = $this->request->post['email'];
    	} elseif (!empty($user_info)) {
			$this->data['email'] = $user_info['email'];
		} else {
      		$this->data['email'] = '';
    	}

    	if (isset($this->request->post['user_group_id'])) {
      		$this->data['user_group_id'] = $this->request->post['user_group_id'];
    	} elseif (!empty($user_info)) {
			$this->data['user_group_id'] = $user_info['user_group_id'];
		} else {
      		$this->data['user_group_id'] = '';
    	}
		
		$this->load->model('user/user_group');
		
    	$this->data['user_groups'] = $this->model_user_user->getUserGroups();
 
     	if (isset($this->request->post['status'])) {
      		$this->data['status'] = $this->request->post['status'];
    	} elseif (!empty($user_info)) {
			$this->data['status'] = $user_info['status'];
		} else {
      		$this->data['status'] = 0;
    	}
		
		if (isset($this->request->post['sdk_status'])) {
      		$this->data['sdk_status'] = $this->request->post['sdk_status'];
    	} elseif (!empty($user_info)) {
			$this->data['sdk_status'] = $user_info['sdk_enabled'];
		} else {
      		$this->data['sdk_status'] = 0;
    	}
		$this->template = 'user/user_form.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());	
  	}
/*
FUNCTION NAME 		-	validateForm
DESCRIPTION 		-	Validates the user details given in the form for insertion/updation
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	public function isValid($str) {
    	return preg_match('/[^A-Za-z0-9 ]/', $str);
	}
  	protected function validateForm() {
    	if (!$this->user->hasPermission('modify', 'user/user')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	}

    	if (!strlen(trim($this->request->post['username']))||(utf8_strlen($this->request->post['username']) < 3) || (utf8_strlen($this->request->post['username']) > 20)) {
      		$this->error['username'] = $this->language->get('error_username');
    	}
    	if ( preg_match('/^\s/',$this->request->post['username']) ){
			$this->error['username'] = $this->language->get('Space not allowed!');
		}elseif ( $this->isValid($this->request->post['username'])){
  			$this->error['username'] = $this->language->get('Special Characters not allowed!');
  		}
		
		$user_info = $this->model_user_user->getUserByUsername($this->request->post['username']);
		
		if (!isset($this->request->get['user_id'])) {
			if ($user_info) {
				$this->error['username'] = $this->language->get('error_exists');
			}
		} else {
			if ($user_info && ($this->request->get['user_id'] != $user_info['user_id'])) {
				$this->error['username'] = $this->language->get('error_exists');
			}
		}
		
    	if (!strlen(trim($this->request->post['firstname']))||(utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
    	}elseif ( preg_match('/^\s/',$this->request->post['firstname']) ){
			$this->error['firstname'] = $this->language->get('Space not allowed!');
		}elseif ( $this->isValid($this->request->post['firstname'])){
  			$this->error['firstname'] = $this->language->get('Special Characters not allowed!');
  		}

    	if (!strlen(trim($this->request->post['lastname']))||(utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
      		$this->error['lastname'] = $this->language->get('error_lastname');
    	}elseif ( preg_match('/^\s/',$this->request->post['lastname']) ){
			$this->error['lastname'] = $this->language->get('Space not allowed!');
		}elseif ( $this->isValid($this->request->post['lastname'])){
  			$this->error['lastname'] = $this->language->get('Special Characters not allowed!');
  		}

    	$regex = '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/';
    	if ((utf8_strlen($this->request->post['email']) < 3) || (utf8_strlen($this->request->post['email']) > 50)) {
      		$this->error['email'] = $this->language->get('error_email');
    	}
    	//elseif (!preg_match($regex, $this->request->post['email'])) {
    	else if(!preg_match($regex, $this->request->post['email'])){
    		$this->error['email'] = $this->language->get('error_email_format');
    	}	

    	$isEmailExists = $this->model_user_user->getUserByEmail($this->request->post['email']);
    	if (!isset($this->request->get['user_id'])) {
	    	if($isEmailExists) {
				$this->error['email'] = $this->language->get('Duplicate E-Mail address!');
			}
		}

    	if ($this->request->post['password'] || (!isset($this->request->get['user_id']))) {
      		if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
        		$this->error['password'] = $this->language->get('error_password');
      		}
	
	  		if ($this->request->post['password'] != $this->request->post['confirm']) {
	    		$this->error['confirm'] = $this->language->get('error_confirm');
	  		}
    	}
    	if((utf8_strlen($this->request->post['mobileno']) >0)&&($this->request->post['mobileno']!='0')){
	    	if ((utf8_strlen($this->request->post['mobileno']) < 10) || (utf8_strlen($this->request->post['mobileno']) > 10)) {
	      			$this->error['mobile_no'] = $this->language->get('error_mobile_no');
	    	}elseif(!is_numeric($this->request->post['mobileno'])){
	    			$this->error['mobile_no'] = $this->language->get('error_mobile_no_digits');
	    	}elseif(substr($this->request->post['mobileno'], 0,1)==0){
	    			$this->error['mobile_no'] = $this->language->get('error_mobile_no_invalid');
	    	}
	    }

	    if(utf8_strlen($this->request->post['address']) >0){
		    if ((utf8_strlen($this->request->post['address']) < 3) || (utf8_strlen($this->request->post['address']) > 64)) {
				$this->error['address'] = $this->language->get('Address must be between 3-64 characters!');
			}elseif ( preg_match('/^\s/',$this->request->post['address']) ){
				$this->error['address'] = $this->language->get('Space not allowed!');
			}elseif(preg_match('/[^a-z0-9 ]+/i', $this->request->post['address'])) {
				$this->error['address'] = $this->language->get('Special characters not allowed!');
			}
		}

    	if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}
	
    	if (!$this->error) {
      		return true;
    	} else {
      		return false;
    	}
  	}
/*
FUNCTION NAME 		-	validateDelete
DESCRIPTION 		-	Validates the details of the user content when deleted. 
						Checks if the deteled user is already there in the database or not. 
INPUT PARAMETER 	-	void
OUTPUT PARAMETER 	- 	Returns true if no error else returns false.
*/
  	protected function validateDelete() { 
    	if (!$this->user->hasPermission('modify', 'user/user')) {
      		$this->error['warning'] = $this->language->get('error_permission');
    	} 
	  	  
		foreach ($this->request->post['selected'] as $user_id) {
			if ($this->user->getId() == $user_id) {
				$this->error['warning'] = $this->language->get('error_account');
			}
		}
		 
		if (!$this->error) {
	  		return true;
		} else { 
	  		return false;
		}
  	}

  	public function enable() {  
    	$this->language->load('user/user');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('user/user');
    	if (isset($this->request->post['selected'])) {
      		foreach ($this->request->post['selected'] as $user_id) {  
				$this->model_user_user->enableUser($user_id);	
			}
			$this->session->data['success'] = "User enabled successfully.!";
    	}else{
			$this->error['warning']="Warning: Please select atleast one to process!";
			
		}

    	$this->getList();
  	}

  	public function disable() {  #echo "hi jack";
    	$this->language->load('user/user');
    	$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('user/user');
		// echo "thanks!"; var_dump($this->request->post) ; die;
    	if (isset($this->request->post['selected'])) {
      		foreach ($this->request->post['selected'] as $user_id) {  //var_dump($user_id); die;
				$this->model_user_user->disableUser($user_id);	
			}
			$this->session->data['success'] = "User disabled successfully.!";			
    	}else{
			$this->error['warning']="Warning: Please select atleast one to process!";
			
		}
	
    	$this->getList();
  	}

}
?>